/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.satisfy.vinery.core.block.entity.FermentationBarrelBlockEntity;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.RecipeTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class FermentationBarrelRecipe
implements Recipe<FermentationBarrelBlockEntity> {
    private final ResourceLocation identifier;
    private final NonNullList<Ingredient> inputs;
    private final String juiceType;
    private final int juiceAmount;
    private final ItemStack output;
    private final boolean wineBottleRequired;

    public FermentationBarrelRecipe(ResourceLocation identifier, NonNullList<Ingredient> inputs, String juiceType, int juiceAmount, ItemStack output, boolean wineBottleRequired) {
        this.identifier = identifier;
        this.inputs = inputs;
        this.juiceType = juiceType;
        this.juiceAmount = juiceAmount;
        this.output = output;
        this.wineBottleRequired = wineBottleRequired;
    }

    public String getJuiceType() {
        return this.juiceType;
    }

    public int getJuiceAmount() {
        return this.juiceAmount;
    }

    public boolean isWineBottleRequired() {
        return this.wineBottleRequired;
    }

    public boolean matches(FermentationBarrelBlockEntity blockEntity, Level world) {
        ItemStack wineBottle;
        if (this.juiceAmount > 0) {
            if (blockEntity.getFluidLevel() < this.juiceAmount) {
                return false;
            }
            if (!this.juiceType.equals(blockEntity.getJuiceType())) {
                return false;
            }
        }
        if (this.wineBottleRequired && ((wineBottle = blockEntity.m_8020_(4)).m_41619_() || !wineBottle.m_150930_((Item)ObjectRegistry.WINE_BOTTLE.get()))) {
            return false;
        }
        StackedContents recipeMatcher = new StackedContents();
        int matchingStacks = 0;
        for (int i = 1; i < 4; ++i) {
            ItemStack itemStack = blockEntity.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            ++matchingStacks;
            recipeMatcher.m_36468_(itemStack, 1);
        }
        return matchingStacks == this.inputs.size() && recipeMatcher.m_36475_((Recipe)this, null);
    }

    @NotNull
    public ItemStack assemble(FermentationBarrelBlockEntity blockEntity, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.identifier;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<FermentationBarrelRecipe> {
        @NotNull
        public FermentationBarrelRecipe fromJson(ResourceLocation id, JsonObject json) {
            NonNullList ingredients = NonNullList.m_122779_();
            if (json.has("ingredients")) {
                JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
                for (int i = 0; i < jsonArray.size() && i < 3; ++i) {
                    ingredients.add((Object)Ingredient.m_43917_((JsonElement)jsonArray.get(i)));
                }
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for Fermentation Barrel recipe");
            }
            String juiceType = "white_general";
            int juiceAmount = 10;
            if (json.has("juice")) {
                JsonObject juiceObject = GsonHelper.m_13930_((JsonObject)json, (String)"juice");
                juiceType = GsonHelper.m_13851_((JsonObject)juiceObject, (String)"type", (String)"white_general");
                juiceAmount = GsonHelper.m_13824_((JsonObject)juiceObject, (String)"amount", (int)10);
            }
            boolean wineBottleRequired = false;
            if (json.has("wine_bottle")) {
                JsonObject wineBottleObject = GsonHelper.m_13930_((JsonObject)json, (String)"wine_bottle");
                wineBottleRequired = GsonHelper.m_13855_((JsonObject)wineBottleObject, (String)"required", (boolean)false);
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new FermentationBarrelRecipe(id, (NonNullList<Ingredient>)ingredients, juiceType, juiceAmount, result, wineBottleRequired);
        }

        @NotNull
        public FermentationBarrelRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            int ingredientCount = buf.m_130242_();
            NonNullList ingredients = NonNullList.m_122779_();
            for (int i = 0; i < ingredientCount && i < 3; ++i) {
                ingredients.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            String juiceType = buf.m_130277_();
            int juiceAmount = buf.m_130242_();
            boolean wineBottleRequired = buf.readBoolean();
            ItemStack result = buf.m_130267_();
            return new FermentationBarrelRecipe(id, (NonNullList<Ingredient>)ingredients, juiceType, juiceAmount, result, wineBottleRequired);
        }

        public void toNetwork(FriendlyByteBuf buf, FermentationBarrelRecipe recipe) {
            buf.m_130130_(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.m_43923_(buf);
            }
            buf.m_130070_(recipe.juiceType);
            buf.m_130130_(recipe.juiceAmount);
            buf.writeBoolean(recipe.wineBottleRequired);
            buf.m_130055_(recipe.output);
        }
    }
}

