/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.client.gui.handler;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.satisfy.vinery.client.gui.handler.slot.ExtendedSlot;
import net.satisfy.vinery.client.gui.handler.slot.FermentationBarrelOutputSlot;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.RecipeTypesRegistry;
import net.satisfy.vinery.core.registry.ScreenhandlerTypeRegistry;
import net.satisfy.vinery.core.util.JuiceUtil;
import org.jetbrains.annotations.NotNull;

public class FermentationBarrelGuiHandler
extends AbstractContainerMenu {
    private final Container inventory;
    private final Level level;
    public final ContainerData data;
    private static final int WINE_BOTTLE_SLOT = 4;
    private static final int OUTPUT_SLOT_GENERAL = 5;

    public FermentationBarrelGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(6), (ContainerData)new SimpleContainerData(4));
    }

    public FermentationBarrelGuiHandler(int syncId, Inventory playerInventory, Container inventory, ContainerData data) {
        super((MenuType)ScreenhandlerTypeRegistry.FERMENTATION_BARREL_GUI_HANDLER.get(), syncId);
        this.inventory = inventory;
        this.level = playerInventory.f_35978_.m_9236_();
        this.data = data;
        this.m_38884_(data);
        this.addBlockEntitySlots(playerInventory);
        this.addPlayerInventory(playerInventory);
    }

    private void addBlockEntitySlots(Inventory playerInventory) {
        this.m_38897_(new ExtendedSlot(this.inventory, 0, 39, 17, stack -> JuiceUtil.isJuice(stack) && this.canAddJuice((ItemStack)stack)));
        this.m_38897_(new ExtendedSlot(this.inventory, 1, 67, 58, this::isIngredient));
        this.m_38897_(new ExtendedSlot(this.inventory, 2, 85, 58, this::isIngredient));
        this.m_38897_(new ExtendedSlot(this.inventory, 3, 103, 58, this::isIngredient));
        this.m_38897_(new ExtendedSlot(this.inventory, 4, 123, 58, stack -> stack.m_150930_((Item)ObjectRegistry.WINE_BOTTLE.get())));
        this.m_38897_(new FermentationBarrelOutputSlot(playerInventory.f_35978_, this.inventory, 5, 103, 17));
    }

    private boolean canAddJuice(ItemStack stack) {
        String newJuiceType = JuiceUtil.getJuiceType(stack);
        String currentJuiceType = this.getJuiceType();
        return currentJuiceType.isEmpty() || currentJuiceType.equals(newJuiceType);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    private boolean isIngredient(ItemStack stack) {
        return this.level.m_7465_().m_44013_((RecipeType)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get()).stream().anyMatch(recipe -> recipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(stack)));
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            itemStack = stackInSlot.m_41777_();
            int containerSlots = 6;
            if (index < containerSlots) {
                if (!this.m_38903_(stackInSlot, containerSlots, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (JuiceUtil.isJuice(stackInSlot) ? !this.m_38903_(stackInSlot, 0, 1, false) : (stackInSlot.m_150930_((Item)ObjectRegistry.WINE_BOTTLE.get()) ? !this.m_38903_(stackInSlot, 4, 5, false) : (this.isIngredient(stackInSlot) ? !this.m_38903_(stackInSlot, 1, 4, false) : (index < this.f_38839_.size() - 9 ? !this.m_38903_(stackInSlot, this.f_38839_.size() - 9, this.f_38839_.size(), false) : !this.m_38903_(stackInSlot, containerSlots, this.f_38839_.size() - 9, false))))) {
                    return ItemStack.f_41583_;
                }
                if (stackInSlot.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
                if (stackInSlot.m_41613_() == itemStack.m_41613_()) {
                    return ItemStack.f_41583_;
                }
                slot.m_142406_(player, stackInSlot);
            }
        }
        return itemStack;
    }

    public boolean m_6875_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public String getJuiceType() {
        int juiceTypeValue = this.data.m_6413_(3);
        return this.getJuiceTypeFromValue(juiceTypeValue);
    }

    private String getJuiceTypeFromValue(int value) {
        return switch (value) {
            case 0 -> "white_general";
            case 1 -> "red_general";
            case 2 -> "white_savanna";
            case 3 -> "red_savanna";
            case 4 -> "white_taiga";
            case 5 -> "red_taiga";
            case 6 -> "white_jungle";
            case 7 -> "red_jungle";
            case 8 -> "apple";
            case 9 -> "red_crimson";
            case 10 -> "white_warped";
            default -> "";
        };
    }

    public int getFluidLevel() {
        return this.data.m_6413_(2);
    }

    public int getScaledProgress(int maxProgress) {
        int progress = this.data.m_6413_(0);
        int totalProgress = this.data.m_6413_(1);
        if (progress == 0 || totalProgress == 0) {
            return 0;
        }
        return (int)((double)progress / (double)totalProgress * (double)maxProgress);
    }
}

