/*
 * Decompiled with CFR 0.152.
 */
package com.jkvin114.displaydelight.events;

import com.jkvin114.displaydelight.block.AbstractStackablePlatedFoodBlock;
import com.jkvin114.displaydelight.block.SmallPlatedFoodBlock;
import com.jkvin114.displaydelight.init.BlockAssociations;
import com.jkvin114.displaydelight.init.DisplayBlocks;
import com.jkvin114.displaydelight.init.DisplayConfig;
import com.jkvin114.displaydelight.init.DisplayTags;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class InterationManager {
    public static boolean tryTakeItemWithBareHand(Player player, ServerLevel world, BlockHitResult rez) {
        Block plateItem;
        InteractionHand handy = InteractionHand.MAIN_HAND;
        BlockPos pos = rez.m_82425_();
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof AbstractStackablePlatedFoodBlock) {
            AbstractStackablePlatedFoodBlock target = (AbstractStackablePlatedFoodBlock)block;
            plateItem = BlockAssociations.getPlatedItemFor((Block)target);
            int count = 1;
            if (player.m_6047_()) {
                count = target.getStacks(state);
                world.m_7731_(pos, ((Block)DisplayBlocks.PLATE.get()).m_49966_(), 2);
            } else if (target.getStacks(state) > 1) {
                BlockState newState = target.getDecrementedState(state);
                world.m_7731_(pos, newState, 2);
            } else {
                world.m_7731_(pos, ((Block)DisplayBlocks.PLATE.get()).m_49966_(), 2);
            }
            world.m_5594_(null, pos, SoundEvents.f_11752_, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            HashSet<Block> set = new HashSet<Block>();
            set.add(plateItem);
            if (player.m_150109_().m_18949_(set)) {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)plateItem, count));
            } else {
                player.m_21008_(handy, new ItemStack((ItemLike)plateItem, count));
            }
            player.m_21011_(handy, true);
            return true;
        }
        plateItem = state.m_60734_();
        if (plateItem instanceof SmallPlatedFoodBlock) {
            SmallPlatedFoodBlock target = (SmallPlatedFoodBlock)plateItem;
            plateItem = BlockAssociations.getSmallPlatedItemFor((Block)target);
            world.m_7731_(pos, ((Block)DisplayBlocks.SMALL_PLATE.get()).m_49966_(), 2);
            world.m_5594_(null, pos, SoundEvents.f_11752_, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            HashSet<Block> set = new HashSet<Block>();
            set.add(plateItem);
            if (player.m_150109_().m_18949_(set)) {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)plateItem, 1));
            } else {
                player.m_21008_(handy, new ItemStack((ItemLike)plateItem, 1));
            }
            player.m_21011_(handy, true);
            return true;
        }
        return false;
    }

    public static boolean tryPlaceItemOnSmallPlate(Player player, ServerLevel world, BlockHitResult rez, boolean isMainHand) {
        InteractionHand handy = isMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack stack = player.m_21120_(handy);
        if (!stack.m_204117_(DisplayTags.SMALL_PLATE_DISPLAYABLE)) {
            return false;
        }
        BlockPos pos = rez.m_82425_();
        BlockState state = world.m_8055_(pos);
        if (!state.m_60713_((Block)DisplayBlocks.SMALL_PLATE.get())) {
            return false;
        }
        Block plateBlock = BlockAssociations.getSmallPlateBlockFor(stack.m_41720_());
        if (!(plateBlock instanceof SmallPlatedFoodBlock)) {
            return false;
        }
        SmallPlatedFoodBlock food = (SmallPlatedFoodBlock)plateBlock;
        UseOnContext ctx = new UseOnContext(player, handy, rez);
        BlockState newstate = food.getStateFrom(state, ctx.m_8125_());
        world.m_7731_(pos, newstate, 2);
        world.m_5594_(null, pos, state.getSoundType((LevelReader)world, pos, (Entity)player).m_56777_(), SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        player.m_21011_(handy, true);
        return true;
    }

    public static boolean tryPlaceItemOnPlate(Player player, ServerLevel world, BlockHitResult rez, boolean isMainHand) {
        InteractionHand handy = isMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack handStack = player.m_21120_(handy);
        if (!handStack.m_204117_(DisplayTags.PLATE_DISPLAYABLE)) {
            return false;
        }
        BlockPos pos = rez.m_82425_();
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof AbstractStackablePlatedFoodBlock) {
            AbstractStackablePlatedFoodBlock target = (AbstractStackablePlatedFoodBlock)block;
            if (handStack.m_150930_(target.getStackFor().m_41720_()) && target.getStacks(state) < target.getMaxStackable()) {
                int count = 1;
                if (player.m_6047_()) {
                    int stacksLeft = target.getMaxStackable() - target.getStacks(state);
                    count = player.m_7500_() ? stacksLeft : Math.min(stacksLeft, handStack.m_41613_());
                }
                world.m_7731_(pos, target.getIncrementedState(state, count), 2);
                world.m_5594_(null, pos, state.getSoundType((LevelReader)world, pos, (Entity)player).m_56777_(), SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                if (!player.m_7500_()) {
                    handStack.m_41774_(count);
                }
                player.m_21011_(handy, true);
                return true;
            }
        } else if (state.m_60713_((Block)DisplayBlocks.PLATE.get())) {
            Block plateBlock = BlockAssociations.getPlateBlockFor(handStack.m_41720_());
            if (!(plateBlock instanceof AbstractStackablePlatedFoodBlock)) {
                return false;
            }
            AbstractStackablePlatedFoodBlock target = (AbstractStackablePlatedFoodBlock)plateBlock;
            int count = 1;
            if (player.m_6047_()) {
                int stacksLeft = target.getMaxStackable();
                count = player.m_7500_() ? stacksLeft : Math.min(stacksLeft, handStack.m_41613_());
            }
            UseOnContext ctx = new UseOnContext(player, handy, rez);
            BlockState newstate = target.getStateFrom(state, ctx.m_8125_(), count);
            world.m_7731_(pos, newstate, 2);
            world.m_5594_(null, pos, state.getSoundType((LevelReader)world, pos, (Entity)player).m_56777_(), SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            if (!player.m_7500_()) {
                handStack.m_41774_(count);
            }
            player.m_21011_(handy, true);
            return true;
        }
        return false;
    }

    public static boolean tryPlaceItem(Player player, ServerLevel world, BlockHitResult rez, boolean isMainHand) {
        InteractionHand handy = isMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack stack = player.m_21120_(handy);
        if (!stack.m_204117_(DisplayTags.DISPLAYABLE)) {
            return false;
        }
        BlockPos pos = rez.m_82425_();
        if (player.m_6047_()) {
            Block target = BlockAssociations.getBlockFor(stack.m_41720_());
            if (target.m_5456_().m_6225_(new UseOnContext(player, handy, rez)) == InteractionResult.CONSUME) {
                world.m_5594_(null, pos.m_7494_(), target.m_49966_().getSoundType((LevelReader)world, pos.m_7494_(), (Entity)player).m_56777_(), SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                player.m_21011_(handy, true);
                return true;
            }
        } else if (world.m_8055_(pos).m_60783_((BlockGetter)world, pos, Direction.UP) && rez.m_82434_() == Direction.UP && ((Boolean)DisplayConfig.MESSAGE.get()).booleanValue()) {
            player.m_5661_((Component)Component.m_237115_((String)"item.displaydelight.tooltip.displayable"), true);
        }
        return false;
    }
}

