/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.block.InventoryCableConnectorBlock;
import com.tom.storagemod.block.LevelEmitterBlock;
import com.tom.storagemod.gui.LevelEmitterMenu;
import com.tom.storagemod.tile.InventoryConnectorBlockEntity;
import com.tom.storagemod.util.TickerUtil;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class LevelEmitterBlockEntity
extends BlockEntity
implements TickerUtil.TickableServer,
MenuProvider {
    private ItemStack filter = ItemStack.f_41583_;
    private int count = 1;
    private LazyOptional<IItemHandler> top;
    private boolean lessThan;

    public LevelEmitterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Content.levelEmitterTile.get(), pos, state);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateServer() {
        BlockState state;
        if (this.f_58857_.m_46467_() % 20L == 1L) {
            state = this.f_58857_.m_8055_(this.f_58858_);
            Direction facing = (Direction)state.m_61143_((Property)InventoryCableConnectorBlock.FACING);
            Stack<BlockPos> toCheck = new Stack<BlockPos>();
            HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
            checkedBlocks.add(this.f_58858_);
            BlockPos up = this.f_58858_.m_121945_(facing.m_122424_());
            state = this.f_58857_.m_8055_(up);
            if (!(state.m_60734_() instanceof IInventoryCable)) {
                BlockEntity te;
                if (!(this.top != null && this.top.isPresent() || (te = this.f_58857_.m_7702_(up)) == null)) {
                    this.top = te.getCapability(ForgeCapabilities.ITEM_HANDLER, facing);
                }
            } else {
                this.top = null;
                toCheck.add(up);
                while (!toCheck.isEmpty()) {
                    BlockPos cp = (BlockPos)toCheck.pop();
                    if (checkedBlocks.contains(cp)) continue;
                    checkedBlocks.add(cp);
                    if (this.f_58857_.m_46749_(cp)) {
                        state = this.f_58857_.m_8055_(cp);
                        if (state.m_60734_() == Content.connector.get()) {
                            BlockEntity te = this.f_58857_.m_7702_(cp);
                            if (!(te instanceof InventoryConnectorBlockEntity)) break;
                            this.top = ((InventoryConnectorBlockEntity)te).getInventory();
                            break;
                        }
                        if (state.m_60734_() instanceof IInventoryCable) {
                            toCheck.addAll(((IInventoryCable)state.m_60734_()).next(this.f_58857_, state, cp));
                        }
                    }
                    if (checkedBlocks.size() <= Config.get().invConnectorMax) continue;
                }
            }
        }
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 10L == 2L && this.top != null) {
            state = this.f_58857_.m_8055_(this.f_58858_);
            boolean p = (Boolean)state.m_61143_((Property)LevelEmitterBlock.POWERED);
            boolean currState = false;
            IItemHandler top = (IItemHandler)this.top.orElse((Object)EmptyHandler.INSTANCE);
            if (this.filter.m_41619_()) {
                currState = false;
            } else {
                int counter = 0;
                for (int i = 0; i < top.getSlots(); ++i) {
                    ItemStack inSlot = top.getStackInSlot(i);
                    if (!ItemStack.m_150942_((ItemStack)inSlot, (ItemStack)this.getFilter())) continue;
                    counter += inSlot.m_41613_();
                }
                if (this.lessThan) {
                    currState = counter < this.count;
                } else {
                    boolean bl = currState = counter > this.count;
                }
            }
            if (currState != p) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)LevelEmitterBlock.POWERED, (Comparable)Boolean.valueOf(currState)), 3);
                Direction direction = (Direction)state.m_61143_((Property)LevelEmitterBlock.FACING);
                BlockPos blockpos = this.f_58858_.m_121945_(direction);
                if (!ForgeEventFactory.onNeighborNotify((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_), EnumSet.of(direction), (boolean)false).isCanceled()) {
                    this.f_58857_.m_46586_(blockpos, state.m_60734_(), this.f_58858_);
                    this.f_58857_.m_46590_(blockpos, state.m_60734_(), direction.m_122424_());
                }
            }
        }
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("Filter", (Tag)this.getFilter().m_41739_(new CompoundTag()));
        compound.m_128405_("Count", this.count);
        compound.m_128379_("lessThan", this.lessThan);
    }

    public void m_142466_(CompoundTag nbtIn) {
        super.m_142466_(nbtIn);
        this.setFilter(ItemStack.m_41712_((CompoundTag)nbtIn.m_128469_("Filter")));
        this.count = nbtIn.m_128451_("Count");
        this.lessThan = nbtIn.m_128471_("lessThan");
    }

    public void setFilter(ItemStack filter) {
        this.filter = filter;
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public void setLessThan(boolean lessThan) {
        this.lessThan = lessThan;
    }

    public boolean isLessThan() {
        return this.lessThan;
    }

    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
        return new LevelEmitterMenu(p_createMenu_1_, p_createMenu_2_, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"ts.level_emitter");
    }

    public boolean stillValid(Player p_59619_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(p_59619_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }
}

