/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.item;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class TransformingItem
extends TieredItem {
    private final TagKey<Block> blockTagKey;
    private final SoundEvent sound;
    private final Supplier<Map<Block, Block>> transformations;

    public TransformingItem(Tier material, Supplier<Map<Block, Block>> transformations, Item.Properties settings, SoundEvent sound, TagKey<Block> blockTagKey) {
        super(material, settings);
        this.transformations = transformations;
        this.sound = sound;
        this.blockTagKey = blockTagKey;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        BlockState state = world.m_8055_(pos);
        if (world.f_46443_ && state.m_204336_(this.blockTagKey)) {
            player.m_5496_(this.sound, 0.75f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return this.transformations.get().entrySet().stream().filter(entry -> state.m_60713_((Block)entry.getKey())).findFirst().map(entry -> {
            this.transform(world, state, (Block)entry.getValue(), pos, player, context.m_43722_());
            return InteractionResult.SUCCESS;
        }).orElseGet(() -> super.m_6225_(context));
    }

    public void transform(Level world, BlockState oldState, Block block, BlockPos pos, Player player, ItemStack stack) {
        BlockState state = block.m_49966_();
        for (Property property : oldState.m_61147_()) {
            if (!state.m_61138_(property)) continue;
            if (property instanceof BooleanProperty) {
                BooleanProperty bool = (BooleanProperty)property;
                state = (BlockState)state.m_61124_((Property)bool, (Comparable)((Boolean)oldState.m_61143_((Property)bool)));
                continue;
            }
            if (property instanceof DirectionProperty) {
                DirectionProperty direction = (DirectionProperty)property;
                state = (BlockState)state.m_61124_((Property)direction, (Comparable)((Direction)oldState.m_61143_((Property)direction)));
                continue;
            }
            if (property instanceof EnumProperty) {
                EnumProperty enu = (EnumProperty)property;
                state = (BlockState)state.m_61124_((Property)enu, oldState.m_61143_((Property)enu));
                continue;
            }
            if (!(property instanceof IntegerProperty)) continue;
            IntegerProperty i = (IntegerProperty)property;
            state = (BlockState)state.m_61124_((Property)i, (Comparable)((Integer)state.m_61143_((Property)i)));
        }
        world.m_46597_(pos, state);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!player.m_150110_().f_35937_) {
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
        }
        player.m_5496_(world.m_8055_(pos).m_60827_().m_56777_(), 1.0f, 1.0f);
        world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
    }
}

