/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.entity;

import com.ninni.etcetera.registry.EtceteraEntityType;
import com.ninni.etcetera.registry.EtceteraSoundEvents;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class ChappleEntity
extends Chicken
implements Shearable {
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(ChappleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> APPLE_LAY_TIME = SynchedEntityData.m_135353_(ChappleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Ingredient BREEDING_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_});
    @Nullable
    private UUID lightningId;

    public ChappleEntity(EntityType<? extends Chicken> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, BREEDING_INGREDIENT, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)Type.NORMAL.name);
        this.f_19804_.m_135372_(APPLE_LAY_TIME, (Object)(this.f_19796_.m_188503_(6000) + 6000));
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("Type", this.getChappleType().name);
        nbt.m_128405_("AppleLayTime", this.getAppleLayTime());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setType(Type.fromName(nbt.m_128461_("Type")));
        this.setAppleLayTime(this.getAppleLayTime());
    }

    public void setType(Type type) {
        this.f_19804_.m_135381_(TYPE, (Object)type.name);
    }

    public Type getChappleType() {
        return Type.fromName((String)this.f_19804_.m_135370_(TYPE));
    }

    public int getAppleLayTime() {
        return (Integer)this.f_19804_.m_135370_(APPLE_LAY_TIME);
    }

    public void setAppleLayTime(int appleLayTime) {
        this.f_19804_.m_135381_(APPLE_LAY_TIME, (Object)appleLayTime);
    }

    public void m_8107_() {
        super.m_8107_();
        this.f_28231_ = 1000;
        if (this.m_6084_() && !this.m_6162_() && !this.m_28264_()) {
            this.setAppleLayTime(this.getAppleLayTime() - 1);
        }
        if (this.m_6084_() && !this.m_6162_() && !this.m_28264_() && this.getAppleLayTime() <= 0 && !this.m_9236_().f_46443_ && this.getAppleLayTime() <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            if (this.getChappleType() == Type.GOLDEN && this.f_19796_.m_188503_(3) == 0) {
                this.m_19998_((ItemLike)Items.f_42436_);
            } else {
                this.m_19998_((ItemLike)Items.f_42410_);
            }
            this.m_146850_(GameEvent.f_157810_);
            this.setAppleLayTime(this.f_19796_.m_188503_(6000) + 6000);
        }
    }

    public InteractionResult m_6071_(Player player2, InteractionHand hand) {
        ItemStack itemStack = player2.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42574_) && this.m_6220_()) {
            this.m_5851_(SoundSource.PLAYERS);
            this.m_146852_(GameEvent.f_157781_, (Entity)player2);
            if (!this.m_9236_().f_46443_) {
                itemStack.m_41622_(1, (LivingEntity)player2, player -> player.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_5851_(SoundSource shearedSoundCategory) {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12075_, shearedSoundCategory, 1.0f, 1.0f);
        if (!this.m_9236_().f_46443_) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.m_146870_();
            Chicken chicken = (Chicken)EntityType.f_20555_.m_20615_(this.m_9236_());
            chicken.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            chicken.m_21153_(this.m_21223_());
            chicken.f_20883_ = this.f_20883_;
            if (this.m_8077_()) {
                chicken.m_6593_(this.m_7770_());
                chicken.m_20340_(this.m_20151_());
            }
            if (this.m_21532_()) {
                chicken.m_21530_();
            }
            chicken.m_20331_(this.m_20147_());
            this.m_9236_().m_7967_((Entity)chicken);
            for (int i = 0; i < 5; ++i) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20227_(1.0), this.m_20189_(), new ItemStack((ItemLike)this.getChappleType().apple)));
            }
        }
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.m_6162_();
    }

    public void m_8038_(ServerLevel world, LightningBolt lightning) {
        UUID uUID = lightning.m_20148_();
        if (!uUID.equals(this.lightningId)) {
            this.setType(this.getChappleType() == Type.NORMAL ? Type.GOLDEN : Type.NORMAL);
            this.lightningId = uUID;
            this.m_5496_((SoundEvent)EtceteraSoundEvents.ENTITY_CHAPPLE_CONVERT.get(), 3.0f, 1.0f);
        }
    }

    public ChappleEntity getBreedOffspring(ServerLevel serverWorld, AgeableMob passiveEntity) {
        ChappleEntity chapple = (ChappleEntity)((EntityType)EtceteraEntityType.CHAPPLE.get()).m_20615_((Level)serverWorld);
        chapple.setType(this.chooseBabyType((ChappleEntity)passiveEntity));
        return chapple;
    }

    private Type chooseBabyType(ChappleEntity chapple) {
        Type type2;
        Type type = this.getChappleType();
        return type == (type2 = chapple.getChappleType()) && this.f_19796_.m_188503_(1024) == 0 ? (type == Type.GOLDEN ? Type.NORMAL : Type.GOLDEN) : (this.f_19796_.m_188499_() ? type : type2);
    }

    public static enum Type {
        NORMAL("normal", Items.f_42410_),
        GOLDEN("golden", Items.f_42436_);

        final String name;
        final Item apple;

        private Type(String name, Item apple) {
            this.name = name;
            this.apple = apple;
        }

        static Type fromName(String name) {
            for (Type type : Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return NORMAL;
        }
    }
}

