/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.benefit;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.premade.registry.RegistryObjectConfig;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButtonMapped;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.solonion.common.benefit.BenefitAttribute;
import team.creative.solonion.common.benefit.BenefitMobEffect;
import team.creative.solonion.common.benefit.BenefitType;

public abstract class Benefit<T> {
    public final RegistryObjectConfig<T> property;
    public double value;

    public Benefit(RegistryObjectConfig<T> property, double value) {
        this.property = property;
        this.value = value;
    }

    public Benefit(Registry<T> registry, CompoundTag nbt) {
        this.property = new RegistryObjectConfig(registry, ResourceLocation.m_135820_((String)nbt.m_128461_("key")));
        this.value = nbt.m_128459_("val");
    }

    public boolean equals(Object obj) {
        if (obj instanceof Benefit) {
            Benefit benefit = (Benefit)obj;
            return this.property.equals(benefit.property) && this.value == benefit.value;
        }
        return false;
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("type", BenefitType.getId(this));
        nbt.m_128359_("key", this.property.location.toString());
        nbt.m_128347_("val", this.value);
        return nbt;
    }

    static {
        ConfigTypeConveration.registerTypeCreator(Benefit.class, () -> new BenefitAttribute(Attributes.f_22276_, 2.0));
        ConfigTypeConveration.registerType(Benefit.class, (ConfigTypeConveration)new ConfigTypeConveration<Benefit>(){

            public Benefit readElement(HolderLookup.Provider provider, Benefit defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey key) {
                if (element.isJsonObject()) {
                    JsonObject object = element.getAsJsonObject();
                    if (object.has("attribute")) {
                        return new BenefitAttribute(new ResourceLocation(object.get("attribute").getAsString()), object.get("value").getAsDouble());
                    }
                    return new BenefitMobEffect(new ResourceLocation(object.get("effect").getAsString()), object.get("value").getAsDouble());
                }
                if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                    try {
                        return BenefitType.load(TagParser.m_129359_((String)element.getAsString()));
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
                return defaultValue;
            }

            public JsonElement writeElement(HolderLookup.Provider provider, Benefit value, boolean saveDefault, boolean ignoreRestart, Side side, ConfigKey key) {
                return new JsonPrimitive(value.save().toString());
            }

            @OnlyIn(value=Dist.CLIENT)
            public void createControls(final GuiParent parent, final IGuiConfigParent configParent, ConfigKey key, Side side) {
                parent.flow = GuiFlow.STACK_Y;
                parent.add((GuiControl)new GuiStateButtonMapped<BenefitType>("state", 0, BenefitType.typeMap()){

                    public void raiseEvent(GuiEvent event) {
                        GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("elements");
                        Registry registry = ((BenefitType)this.getSelected()).registry();
                        GuiParent subConfig = (GuiParent)parent.get("subConfig");
                        subConfig.clear();
                        ((BenefitType)this.getSelected()).createControls(subConfig, configParent);
                        box.setLines(new TextMapBuilder().addComponent((Iterable)registry.m_6566_(), value -> {
                            if (value.m_135827_().equals("minecraft")) {
                                return Component.m_237113_((String)value.m_135815_());
                            }
                            return Component.m_237113_((String)value.toString());
                        }));
                        super.raiseEvent(event);
                        this.reflow();
                    }
                });
                parent.add((GuiControl)new GuiComboBoxMapped("elements", new TextMapBuilder()).setSearchbar(true));
                parent.add((GuiControl)new GuiTextfield("value").setFloatOnly().setDim(20, 6));
                parent.add((GuiControl)new GuiParent("subConfig"));
            }

            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(Benefit value, Benefit defaultValue, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                GuiStateButtonMapped state = (GuiStateButtonMapped)parent.get("state");
                state.select((Object)BenefitType.getType(value));
                state.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)state));
                GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("elements");
                box.select((Object)value.property.location);
                GuiTextfield text = (GuiTextfield)parent.get("value");
                text.setText("" + value.value);
                GuiParent subConfig = (GuiParent)parent.get("subConfig");
                ((BenefitType)state.getSelected()).loadValue(value, subConfig, configParent);
            }

            @OnlyIn(value=Dist.CLIENT)
            protected Benefit saveValue(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                GuiStateButtonMapped state = (GuiStateButtonMapped)parent.get("state");
                GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("elements");
                GuiTextfield text = (GuiTextfield)parent.get("value");
                return ((BenefitType)state.getSelected()).saveValue((ResourceLocation)box.getSelected(), text.parseDouble(), (GuiParent)parent.get("subConfig"), configParent);
            }

            public Benefit set(ConfigKey key, Benefit value) {
                return value;
            }
        });
    }
}

