/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.supplementaries.client.screens.BlackBoardScreen;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;

public abstract class BlackboardButton
implements GuiEventListener,
Renderable,
NarratableEntry {
    protected final BlackBoardScreen parent;
    public final int size;
    public final int x;
    public final int y;
    protected boolean shouldDrawOverlay;
    protected byte color;
    protected boolean focused;

    public BlackboardButton(BlackBoardScreen screen, int x, int y, byte color, int size) {
        this.x = x;
        this.y = y;
        this.parent = screen;
        this.color = color;
        this.size = size;
    }

    public byte getColor() {
        return this.color;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.shouldDrawOverlay = this.m_5953_(mouseX, mouseY);
        this.renderButton(graphics);
        if (this.isShouldDrawOverlay()) {
            this.renderHoverOverlay(graphics);
        }
    }

    protected abstract void renderButton(GuiGraphics var1);

    public void renderHoverOverlay(GuiGraphics graphics) {
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 90.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280411_(ModTextures.BLACKBOARD_GUI_GRID, this.x - 1, this.y - 1, this.size + 2, this.size + 2, 0.0f, 0.0f, 16, 16, 16, 16);
        pose.m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean flag;
        if (this.isValidClickButton(button) && (flag = this.m_5953_(mouseX, mouseY))) {
            this.playDownSound(Minecraft.m_91087_().m_91106_());
            this.onClick();
            return true;
        }
        return false;
    }

    protected abstract void onClick();

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    public boolean isShouldDrawOverlay() {
        return this.shouldDrawOverlay;
    }

    public boolean m_93696_() {
        return this.focused;
    }

    public void m_93692_(boolean focused) {
        this.focused = focused;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.size) && mouseY < (double)(this.y + this.size);
    }

    public void playDownSound(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }
}

