/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.registry;

import de.cristelknight.doapi.common.block.entity.SideBoardBlockEntity;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.candlelight.Candlelight;
import net.satisfy.candlelight.entity.CookingPanBlockEntity;
import net.satisfy.candlelight.entity.DinnerBellBlockEntity;
import net.satisfy.candlelight.entity.EffectFoodBlockEntity;
import net.satisfy.candlelight.entity.LargeCookingPotBlockEntity;
import net.satisfy.candlelight.entity.StoveBlockEntity;
import net.satisfy.candlelight.entity.TypeWriterEntity;
import net.satisfy.candlelight.registry.ObjectRegistry;

public class BlockEntityRegistry {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"candlelight", (ResourceKey)Registries.f_256922_);
    public static final RegistrySupplier<BlockEntityType<SideBoardBlockEntity>> SIDEBOARD = BlockEntityRegistry.create("sideboard", () -> BlockEntityType.Builder.m_155273_(SideBoardBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SIDEBOARD.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<LargeCookingPotBlockEntity>> COOKING_POT_BLOCK_ENTITY = BlockEntityRegistry.create("cooking_pot", () -> BlockEntityType.Builder.m_155273_(LargeCookingPotBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COOKING_POT.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<TypeWriterEntity>> TYPE_WRITER_BLOCK_ENTITY = BlockEntityRegistry.create("type_writer", () -> BlockEntityType.Builder.m_155273_(TypeWriterEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.TYPEWRITER_IRON.get(), (Block)ObjectRegistry.TYPEWRITER_COPPER.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CookingPanBlockEntity>> COOKING_PAN_BLOCK_ENTITY = BlockEntityRegistry.create("cooking_pan", () -> BlockEntityType.Builder.m_155273_(CookingPanBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COOKING_PAN.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<EffectFoodBlockEntity>> EFFECT_FOOD_BLOCK_ENTITY = BlockEntityRegistry.create("effect_food_block", () -> BlockEntityType.Builder.m_155273_(EffectFoodBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.LASAGNE_BLOCK.get(), (Block)ObjectRegistry.TOMATO_MOZZARELLA_BLOCK.get(), (Block)ObjectRegistry.PORK_RIBS_BLOCK.get(), (Block)ObjectRegistry.FRESH_GARDEN_SALAD_BLOCK.get(), (Block)ObjectRegistry.BEEF_WELLINGTON_BLOCK.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<DinnerBellBlockEntity>> DINNER_BELL_BLOCK_ENTITY = BlockEntityRegistry.create("dinner_bell", () -> BlockEntityType.Builder.m_155273_(DinnerBellBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.DINNER_BELL.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<StoveBlockEntity>> STOVE_BLOCK_ENTITY = BlockEntityRegistry.create("stove_block", () -> BlockEntityType.Builder.m_155273_(StoveBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COBBLESTONE_STOVE.get(), (Block)ObjectRegistry.MUD_STOVE.get(), (Block)ObjectRegistry.GRANITE_STOVE.get(), (Block)ObjectRegistry.SANDSTONE_STOVE.get(), (Block)ObjectRegistry.STONE_BRICKS_STOVE.get(), (Block)ObjectRegistry.RED_NETHER_BRICKS_STOVE.get(), (Block)ObjectRegistry.DEEPSLATE_STOVE.get(), (Block)ObjectRegistry.QUARTZ_STOVE.get(), (Block)ObjectRegistry.END_STOVE.get(), (Block)ObjectRegistry.BASALT_STOVE.get(), (Block)ObjectRegistry.BAMBOO_STOVE.get()}).m_58966_(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> create(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(path, type);
    }

    public static void init() {
        Candlelight.LOGGER.debug("Registering Mod BlockEntities for candlelight");
        BLOCK_ENTITY_TYPES.register();
    }
}

