/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.painting.pipes;

import me.dantaeusb.zetter.painting.parameters.AbstractToolParameters;
import me.dantaeusb.zetter.painting.parameters.DitheringParameterHolder;
import me.dantaeusb.zetter.painting.pipes.Pipe;
import me.dantaeusb.zetter.painting.tools.AbstractTool;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.network.chat.Component;

public class DitheringPipe
implements Pipe {
    @Override
    public boolean shouldUsePipe(AbstractTool tool, AbstractToolParameters params) {
        if (params instanceof DitheringParameterHolder) {
            return ((DitheringParameterHolder)((Object)params)).getDithering() != DitheringOption.NO_DITHERING;
        }
        return false;
    }

    @Override
    public int applyPipe(CanvasData canvas, AbstractToolParameters params, int color, int index, float localIntensity) {
        if (params instanceof DitheringParameterHolder && ((DitheringParameterHolder)((Object)params)).getDithering() == DitheringOption.DENSE_DITHERING) {
            int posX = index % canvas.getWidth();
            int posY = index / canvas.getWidth();
            if (posY % 2 == 0) {
                return posX % 2 == 0 ? canvas.getColorAt(index) : color;
            }
            return posX % 2 == 1 ? canvas.getColorAt(index) : color;
        }
        return color;
    }

    public static enum DitheringOption {
        NO_DITHERING(1, 0, (Component)Component.m_237115_((String)"container.zetter.painting.dithering.no")),
        DENSE_DITHERING(2, 0, (Component)Component.m_237115_((String)"container.zetter.painting.dithering.dense"));

        public static final DitheringOption DEFAULT;
        public final int size;
        public final int shift;
        public final Component translatableComponent;

        private DitheringOption(int size, int shift, Component translatableComponent) {
            this.size = size;
            this.shift = shift;
            this.translatableComponent = translatableComponent;
        }

        static {
            DEFAULT = NO_DITHERING;
        }
    }
}

