/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.core;

import java.util.Optional;
import me.dantaeusb.zetter.network.packet.CArtistTableModeChangePacket;
import me.dantaeusb.zetter.network.packet.CCanvasActionPacket;
import me.dantaeusb.zetter.network.packet.CCanvasHistoryActionPacket;
import me.dantaeusb.zetter.network.packet.CCanvasRequestExportPacket;
import me.dantaeusb.zetter.network.packet.CCanvasRequestPacket;
import me.dantaeusb.zetter.network.packet.CCanvasRequestViewPacket;
import me.dantaeusb.zetter.network.packet.CCanvasUnloadRequestPacket;
import me.dantaeusb.zetter.network.packet.CPaletteUpdatePacket;
import me.dantaeusb.zetter.network.packet.CSignPaintingPacket;
import me.dantaeusb.zetter.network.packet.SCanvasHistoryActionPacket;
import me.dantaeusb.zetter.network.packet.SCanvasRemovalPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncExportErrorPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncExportPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncViewPacket;
import me.dantaeusb.zetter.network.packet.SEaselCanvasInitializationPacket;
import me.dantaeusb.zetter.network.packet.SEaselResetPacket;
import me.dantaeusb.zetter.network.packet.SEaselStateSyncPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(modid="zetter", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ZetterNetwork {
    public static SimpleChannel simpleChannel;
    public static final ResourceLocation simpleChannelRL;
    public static final String MESSAGE_PROTOCOL_VERSION = "0.3";
    public static final byte PAINTING_FRAME = 21;
    public static final byte CANVAS_REQUEST = 22;
    public static final byte CANVAS_SYNC = 24;
    public static final byte PAINTING_UNLOAD_CANVAS = 23;
    public static final byte PALETTE_UPDATE = 25;
    public static final byte PAINTING_RENAME = 26;
    public static final byte CANVAS_REQUEST_SYNC_VIEW = 28;
    public static final byte CANVAS_SYNC_VIEW = 27;
    public static final byte CANVAS_REMOVE = 29;
    public static final byte EASEL_SYNC = 30;
    public static final byte HISTORY_UPDATE = 31;
    public static final byte HISTORY_SYNC = 33;
    public static final byte HISTORY_RESET = 34;
    public static final byte ARTIST_TABLE_MODE = 32;
    public static final byte EASEL_CANVAS_INIT = 35;
    public static final byte CANVAS_REQUEST_EXPORT = 40;
    public static final byte CANVAS_EXPORT = 41;
    public static final byte CANVAS_EXPORT_ERROR = 42;

    @SubscribeEvent
    public static void onCommonSetupEvent(FMLCommonSetupEvent event) {
        simpleChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)simpleChannelRL, () -> MESSAGE_PROTOCOL_VERSION, ZetterNetwork::isThisProtocolAcceptedByClient, ZetterNetwork::isThisProtocolAcceptedByServer);
        simpleChannel.registerMessage(21, CCanvasActionPacket.class, CCanvasActionPacket::writePacketData, CCanvasActionPacket::readPacketData, CCanvasActionPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(22, CCanvasRequestPacket.class, CCanvasRequestPacket::writePacketData, CCanvasRequestPacket::readPacketData, CCanvasRequestPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(23, CCanvasUnloadRequestPacket.class, CCanvasUnloadRequestPacket::writePacketData, CCanvasUnloadRequestPacket::readPacketData, CCanvasUnloadRequestPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(24, SCanvasSyncPacket.class, SCanvasSyncPacket::writePacketData, SCanvasSyncPacket::readPacketData, SCanvasSyncPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(25, CPaletteUpdatePacket.class, CPaletteUpdatePacket::writePacketData, CPaletteUpdatePacket::readPacketData, CPaletteUpdatePacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(26, CSignPaintingPacket.class, CSignPaintingPacket::writePacketData, CSignPaintingPacket::readPacketData, CSignPaintingPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(27, SCanvasSyncViewPacket.class, SCanvasSyncViewPacket::writePacketData, SCanvasSyncViewPacket::readPacketData, SCanvasSyncViewPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(28, CCanvasRequestViewPacket.class, CCanvasRequestViewPacket::writePacketData, CCanvasRequestViewPacket::readPacketData, CCanvasRequestViewPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(29, SCanvasRemovalPacket.class, SCanvasRemovalPacket::writePacketData, SCanvasRemovalPacket::readPacketData, SCanvasRemovalPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(30, SEaselStateSyncPacket.class, SEaselStateSyncPacket::writePacketData, SEaselStateSyncPacket::readPacketData, SEaselStateSyncPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(31, CCanvasHistoryActionPacket.class, CCanvasHistoryActionPacket::writePacketData, CCanvasHistoryActionPacket::readPacketData, CCanvasHistoryActionPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(32, CArtistTableModeChangePacket.class, CArtistTableModeChangePacket::writePacketData, CArtistTableModeChangePacket::readPacketData, CArtistTableModeChangePacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(33, SCanvasHistoryActionPacket.class, SCanvasHistoryActionPacket::writePacketData, SCanvasHistoryActionPacket::readPacketData, SCanvasHistoryActionPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(34, SEaselResetPacket.class, SEaselResetPacket::writePacketData, SEaselResetPacket::readPacketData, SEaselResetPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(35, SEaselCanvasInitializationPacket.class, SEaselCanvasInitializationPacket::writePacketData, SEaselCanvasInitializationPacket::readPacketData, SEaselCanvasInitializationPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(40, CCanvasRequestExportPacket.class, CCanvasRequestExportPacket::writePacketData, CCanvasRequestExportPacket::readPacketData, CCanvasRequestExportPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(41, SCanvasSyncExportPacket.class, SCanvasSyncExportPacket::writePacketData, SCanvasSyncExportPacket::readPacketData, SCanvasSyncExportPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(42, SCanvasSyncExportErrorPacket.class, SCanvasSyncExportErrorPacket::writePacketData, SCanvasSyncExportErrorPacket::readPacketData, SCanvasSyncExportErrorPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static boolean isThisProtocolAcceptedByClient(String protocolVersion) {
        return MESSAGE_PROTOCOL_VERSION.equals(protocolVersion);
    }

    public static boolean isThisProtocolAcceptedByServer(String protocolVersion) {
        return MESSAGE_PROTOCOL_VERSION.equals(protocolVersion);
    }

    static {
        simpleChannelRL = new ResourceLocation("zetter", "zetter_channel");
    }
}

