/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.botaniaseeds.blocks;

import io.github.chakyl.botaniaseeds.registry.ModElements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.item.material.MysticalPetalItem;
import vazkii.botania.xplat.BotaniaConfig;

public class MysticalFlowerCropBlock
extends CropBlock
implements IPlantable {
    public static int MAX_AGE = 5;
    public static final IntegerProperty AGE = BlockStateProperties.f_61408_;
    private final Block FLOWER_BLOCK;
    private final DyeColor DYE_COLOR;

    public MysticalFlowerCropBlock(Block flowerBlock, DyeColor dyeColor, BlockBehaviour.Properties properties) {
        super(properties);
        this.FLOWER_BLOCK = flowerBlock;
        this.DYE_COLOR = dyeColor;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{AGE});
    }

    protected IntegerProperty m_7959_() {
        return AGE;
    }

    public int m_7419_() {
        return MAX_AGE;
    }

    protected Item getBaseSeedId() {
        return switch (this.DYE_COLOR) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> (Item)ModElements.WHITE_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.ORANGE -> (Item)ModElements.ORANGE_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.MAGENTA -> (Item)ModElements.MAGENTA_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.LIGHT_BLUE -> (Item)ModElements.LIGHT_BLUE_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.YELLOW -> (Item)ModElements.YELLOW_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.LIME -> (Item)ModElements.LIME_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.PINK -> (Item)ModElements.PINK_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.GRAY -> (Item)ModElements.GRAY_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.LIGHT_GRAY -> (Item)ModElements.LIGHT_GRAY_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.CYAN -> (Item)ModElements.CYAN_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.PURPLE -> (Item)ModElements.PURPLE_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.BLUE -> (Item)ModElements.BLUE_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.BROWN -> (Item)ModElements.BROWN_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.GREEN -> (Item)ModElements.GREEN_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.RED -> (Item)ModElements.RED_MYSTICAL_FLOWER_SEED.get();
            case DyeColor.BLACK -> (Item)ModElements.BLACK_MYSTICAL_FLOWER_SEED.get();
        };
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        int hex = MysticalPetalItem.getPetalLikeColor((DyeColor)this.DYE_COLOR);
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        Vec3 offset = state.m_60824_((BlockGetter)world, pos);
        double x = (double)pos.m_123341_() + offset.f_82479_;
        double y = (double)pos.m_123342_() + offset.f_82480_;
        double z = (double)pos.m_123343_() + offset.f_82481_;
        if (rand.m_188500_() < BotaniaConfig.client().flowerParticleFrequency() - (double)(1.0f / (float)MAX_AGE)) {
            SparkleParticleData data = SparkleParticleData.sparkle((float)rand.m_188501_(), (float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (int)5);
            world.m_7106_((ParticleOptions)data, x + 0.5, y + 0.2, z + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public BlockState m_52289_(int age) {
        return age == MAX_AGE ? this.FLOWER_BLOCK.m_49966_() : super.m_52289_(age);
    }

    public void m_213898_(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (randomSource.m_188503_(MAX_AGE + 1) != 0) {
            super.m_213898_(blockState, level, pos, randomSource);
        }
    }
}

