/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.placementcondition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.RandomStateAccessor;
import dev.worldgen.lithostitched.worldgen.placementcondition.PlacementCondition;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public record SampleDensityPlacementCondition(Holder<DensityFunction> densityFunction, Optional<Double> minInclusive, Optional<Double> maxInclusive) implements PlacementCondition
{
    public static final MapCodec<SampleDensityPlacementCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208217_.fieldOf("density_function").forGetter(SampleDensityPlacementCondition::densityFunction), (App)Codec.DOUBLE.optionalFieldOf("min_inclusive").forGetter(SampleDensityPlacementCondition::minInclusive), (App)Codec.DOUBLE.optionalFieldOf("max_inclusive").forGetter(SampleDensityPlacementCondition::maxInclusive)).apply((Applicative)instance, SampleDensityPlacementCondition::new));

    @Override
    public boolean test(PlacementCondition.Context context, BlockPos pos) {
        ChunkGenerator chunkGenerator = context.generator();
        if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) {
            return false;
        }
        NoiseBasedChunkGenerator chunkGenerator2 = (NoiseBasedChunkGenerator)chunkGenerator;
        DensityFunction df = ((DensityFunction)this.densityFunction.m_203334_()).m_207456_((DensityFunction.Visitor)new NoiseWiringHelper(context.seed(), ((NoiseGeneratorSettings)chunkGenerator2.f_64318_.m_203334_()).f_209354_(), context.randomState(), ((RandomStateAccessor)context.randomState()).getRandom()));
        double density = df.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        boolean min = this.minInclusive.isEmpty() || density >= this.minInclusive.get();
        boolean max = this.maxInclusive.isEmpty() || density <= this.maxInclusive.get();
        return min && max;
    }

    @Override
    public MapCodec<? extends PlacementCondition> codec() {
        return CODEC;
    }

    private static class NoiseWiringHelper
    implements DensityFunction.Visitor {
        private final Map<DensityFunction, DensityFunction> wrapped = new HashMap<DensityFunction, DensityFunction>();
        private final boolean useLegacySource;
        private final long seed;
        final RandomState randomState;
        final PositionalRandomFactory random;

        private RandomSource newLegacyInstance(long noiseSeed) {
            return new LegacyRandomSource(this.seed + noiseSeed);
        }

        NoiseWiringHelper(long seed, boolean useLegacySource, RandomState randomState, PositionalRandomFactory random) {
            this.seed = seed;
            this.useLegacySource = useLegacySource;
            this.randomState = randomState;
            this.random = random;
        }

        public DensityFunction.NoiseHolder m_213918_(DensityFunction.NoiseHolder noiseHolder) {
            Holder noiseData = noiseHolder.f_223997_();
            if (this.useLegacySource) {
                if (noiseData.m_203565_(Noises.f_189269_)) {
                    NormalNoise noise = NormalNoise.m_230508_((RandomSource)this.newLegacyInstance(0L), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-7, 1.0, new double[]{1.0}));
                    return new DensityFunction.NoiseHolder(noiseData, noise);
                }
                if (noiseData.m_203565_(Noises.f_189278_)) {
                    NormalNoise noise = NormalNoise.m_230508_((RandomSource)this.newLegacyInstance(1L), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-7, 1.0, new double[]{1.0}));
                    return new DensityFunction.NoiseHolder(noiseData, noise);
                }
                if (noiseData.m_203565_(Noises.f_189286_)) {
                    NormalNoise noise = NormalNoise.m_230511_((RandomSource)this.random.m_224540_(Noises.f_189286_.m_135782_()), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(0, 0.0, new double[0]));
                    return new DensityFunction.NoiseHolder(noiseData, noise);
                }
            }
            NormalNoise noise = this.randomState.m_224560_((ResourceKey)noiseData.m_203543_().orElseThrow());
            return new DensityFunction.NoiseHolder(noiseData, noise);
        }

        private DensityFunction wrapNew(DensityFunction densityFunction) {
            if (densityFunction instanceof BlendedNoise) {
                BlendedNoise $$1 = (BlendedNoise)densityFunction;
                RandomSource $$2x = this.useLegacySource ? this.newLegacyInstance(0L) : this.random.m_224540_(new ResourceLocation("terrain"));
                return $$1.m_230483_($$2x);
            }
            return densityFunction instanceof DensityFunctions.EndIslandDensityFunction ? new DensityFunctions.EndIslandDensityFunction(this.seed) : densityFunction;
        }

        public DensityFunction m_214017_(DensityFunction densityFunction) {
            return this.wrapped.computeIfAbsent(densityFunction, this::wrapNew);
        }
    }
}

