/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.creeperhost.polylib.containers.ModularGuiContainerMenu;
import net.creeperhost.polylib.containers.slots.PolySlot;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class SlotGroup {
    public final int zone;
    public final List<Integer> quickMoveTo;
    private final ModularGuiContainerMenu containerMenu;
    private final List<PolySlot> slots = new ArrayList<PolySlot>();

    public SlotGroup(ModularGuiContainerMenu containerMenu, int zone, int ... quickMoveTo) {
        this.zone = zone;
        this.containerMenu = containerMenu;
        this.quickMoveTo = Arrays.stream(quickMoveTo).boxed().toList();
    }

    public PolySlot addSlot(PolySlot slot) {
        this.slots.add(slot);
        this.containerMenu.m_38897_(slot);
        this.containerMenu.mapSlot(slot, this);
        return slot;
    }

    public void addSlots(int slotCount, int startIndex, Function<Integer, PolySlot> makeSlot) {
        for (int index = startIndex; index < startIndex + slotCount; ++index) {
            this.addSlot(makeSlot.apply(index));
        }
    }

    public void addAllSlots(Container container) {
        this.addAllSlots(container, PolySlot::new);
    }

    public void addAllSlots(Container container, BiFunction<Container, Integer, PolySlot> makeSlot) {
        for (int index = 0; index < container.m_6643_(); ++index) {
            this.addSlot(makeSlot.apply(container, index));
        }
    }

    public void addPlayerMain(Inventory inventory) {
        this.addSlots(27, 9, index -> new PolySlot((Container)inventory, (int)index));
    }

    public void addPlayerBar(Inventory inventory) {
        this.addSlots(9, 0, index -> new PolySlot((Container)inventory, (int)index));
    }

    public void addPlayerArmor(Inventory inventory) {
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot slot = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)(3 - i));
            this.addSlot(new PolySlot((Container)inventory, 39 - i).onSetByPlayer((oldStack, newStack) -> SlotGroup.onEquipItem(inventory, slot, newStack, oldStack)).setStackLimit(stack -> 1).setValidator(stack -> slot == Mob.m_147233_((ItemStack)stack)).setCanRemove((player, stack) -> stack.m_41619_() || player.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)stack)));
        }
    }

    public void addPlayerOffhand(Inventory inventory) {
        this.addSlot(new PolySlot((Container)inventory, 40).onSetByPlayer((oldStack, newStack) -> SlotGroup.onEquipItem(inventory, EquipmentSlot.OFFHAND, newStack, oldStack)));
    }

    static void onEquipItem(Inventory inventory, EquipmentSlot slot, ItemStack newStack, ItemStack oldStack) {
        Equipable equipable = Equipable.m_269088_((ItemStack)newStack);
        if (equipable != null) {
            inventory.f_35978_.m_238392_(slot, oldStack, newStack);
        }
    }

    public int size() {
        return this.slots.size();
    }

    public PolySlot getSlot(int index) {
        return this.slots.get(index);
    }

    public int indexOf(Slot slot) {
        return this.slots.indexOf(slot);
    }

    public List<PolySlot> slots() {
        return Collections.unmodifiableList(this.slots);
    }
}

