/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.structureessentials.StructureEssentials;
import com.structureessentials.Timings;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.Music;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.Structure;

public class Command {
    public static Map<Holder<Biome>, List<Object2DoubleMap.Entry<Holder<Biome>>>> biomeScoreCache = new HashMap<Holder<Biome>, List<Object2DoubleMap.Entry<Holder<Biome>>>>();

    public LiteralArgumentBuilder<CommandSourceStack> build(CommandBuildContext buildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"structureessentials").then(Commands.m_82127_((String)"getBiomeTags").then(Commands.m_82129_((String)"biome", (ArgumentType)ResourceOrTagArgument.m_247455_((CommandBuildContext)buildContext, (ResourceKey)Registries.f_256952_)).executes(context -> {
            ResourceKey biome = ((Holder.Reference)ResourceOrTagArgument.m_245464_((CommandContext)context, (String)"biome", (ResourceKey)Registries.f_256952_).m_245347_().left().get()).m_205785_();
            List biomeTags = ((Holder.Reference)((Registry)((CommandSourceStack)context.getSource()).m_5894_().m_6632_(Registries.f_256952_).get()).m_203636_(biome).get()).m_203616_().collect(Collectors.toList());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Biome tags for: " + biome.m_135782_())).m_130940_(ChatFormatting.GOLD));
            for (TagKey biomeTag : biomeTags) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("#" + biomeTag.f_203868_())));
            }
            return 1;
        })))).then(Commands.m_82127_((String)"showGenerationTimes").executes(context -> {
            int count = 0;
            ArrayList<Map.Entry<ResourceLocation, Long>> sortedFeatures = new ArrayList<Map.Entry<ResourceLocation, Long>>(Timings.featureTimings.entrySet());
            sortedFeatures.sort(Comparator.comparingLong(e -> (Long)((Map.Entry)e).getValue()).reversed());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"Features timings:").m_130940_(ChatFormatting.GOLD));
            StructureEssentials.LOGGER.warn("Placed Feature timings in ms:");
            for (Map.Entry entry : sortedFeatures) {
                if (++count < 5) {
                    ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("#:" + count + " id: " + entry.getKey() + " time: " + (Long)entry.getValue() / 1000000L)).m_130940_(ChatFormatting.WHITE));
                }
                StructureEssentials.LOGGER.warn("#:" + count + " id: " + entry.getKey() + " time: " + (Long)entry.getValue() / 100000L);
            }
            count = 0;
            ArrayList<Map.Entry<ResourceLocation, Long>> sortedStructures = new ArrayList<Map.Entry<ResourceLocation, Long>>(Timings.structureTimings.entrySet());
            sortedStructures.sort(Comparator.comparingLong(e -> (Long)((Map.Entry)e).getValue()).reversed());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"Structure timings:").m_130940_(ChatFormatting.GOLD));
            StructureEssentials.LOGGER.warn("Structure timings in ms:");
            for (Map.Entry entry : sortedStructures) {
                if (++count < 5) {
                    ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("#:" + count + " id: " + entry.getKey() + " time: " + (Long)entry.getValue() / 1000000L)).m_130940_(ChatFormatting.WHITE));
                }
                StructureEssentials.LOGGER.warn("#:" + count + " id: " + entry.getKey() + " time: " + (Long)entry.getValue() / 100000L);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"getBiomesForTag").then(Commands.m_82129_((String)"biome", (ArgumentType)ResourceOrTagArgument.m_247455_((CommandBuildContext)buildContext, (ResourceKey)Registries.f_256952_)).executes(context -> {
            TagKey biomeTag = ((HolderSet.Named)ResourceOrTagArgument.m_245464_((CommandContext)context, (String)"biome", (ResourceKey)Registries.f_256952_).m_245347_().right().get()).m_205839_();
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Biomes for tag: " + biomeTag.f_203868_())).m_130940_(ChatFormatting.GOLD));
            for (Holder biomeHolder : ((Registry)((CommandSourceStack)context.getSource()).m_5894_().m_6632_(Registries.f_256952_).get()).m_206115_()) {
                if (!biomeHolder.m_203656_(biomeTag)) continue;
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Biome: " + ((ResourceKey)biomeHolder.m_203543_().get()).m_135782_())));
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"getStructuresNearby").requires(stack -> stack.m_6761_(2))).executes(context -> {
            ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
            HashMap<Structure, LongSet> structures = new HashMap<Structure, LongSet>();
            ChunkPos start = new ChunkPos(BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_()));
            for (int x = -5; x < 5; ++x) {
                for (int z = -5; z < 5; ++z) {
                    for (Map.Entry entry : world.m_215010_().m_220522_(new BlockPos(start.f_45578_ + x << 4, 0, start.f_45579_ + z << 4)).entrySet()) {
                        structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
                    }
                }
            }
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"Structures nearby: ").m_130940_(ChatFormatting.GOLD));
            HashMap structurePositions = new HashMap();
            for (Map.Entry structureEntry : structures.entrySet()) {
                world.m_215010_().m_220480_((Structure)structureEntry.getKey(), (LongSet)structureEntry.getValue(), structureStart -> structurePositions.put(structureStart.m_73601_().m_162394_(), ((Registry)((CommandSourceStack)context.getSource()).m_5894_().m_6632_(Registries.f_256944_).get()).m_7981_((Object)((Structure)structureEntry.getKey())).toString()));
            }
            ArrayList sortedStructures = new ArrayList(structurePositions.entrySet());
            sortedStructures.sort(Comparator.comparingDouble(p -> ((BlockPos)p.getKey()).m_123331_((Vec3i)BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_()))));
            for (Map.Entry structureEntry : sortedStructures) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)((String)structureEntry.getValue())).m_7220_((Component)Component.m_237113_((String)(" " + structureEntry.getKey())).m_130940_(ChatFormatting.YELLOW).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + ((BlockPos)structureEntry.getKey()).m_123341_() + " " + ((BlockPos)structureEntry.getKey()).m_123342_() + " " + ((BlockPos)structureEntry.getKey()).m_123343_())))));
            }
            return 1;
        }))).then(Commands.m_82127_((String)"getSimilarForBiome").then(Commands.m_82129_((String)"biome", (ArgumentType)ResourceOrTagArgument.m_247455_((CommandBuildContext)buildContext, (ResourceKey)Registries.f_256952_)).executes(context -> {
            biomeScoreCache.clear();
            ResourceKey biome = ((Holder.Reference)ResourceOrTagArgument.m_245464_((CommandContext)context, (String)"biome", (ResourceKey)Registries.f_256952_).m_245347_().left().get()).m_205785_();
            Holder holder = (Holder)((Registry)((CommandSourceStack)context.getSource()).m_5894_().m_6632_(Registries.f_256952_).get()).m_203636_(biome).get();
            List<Object2DoubleMap.Entry<Holder<Biome>>> sortedBiomeHolders = Command.getSimilarBiomesFor((Holder<Biome>)holder, ((CommandSourceStack)context.getSource()).m_5894_());
            List<Map.Entry<TagKey<Biome>, Double>> sortedBiomeTagKeys = Command.getSimilarTagsFor((Holder<Biome>)holder, ((CommandSourceStack)context.getSource()).m_5894_());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Similar biome tags for: " + biome.m_135782_())).m_130940_(ChatFormatting.GOLD));
            for (int i = 0; i < sortedBiomeHolders.size() && i < 7; ++i) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Weight:" + sortedBiomeHolders.get(i).getValue() + " Biome: " + ((ResourceKey)((Holder)sortedBiomeHolders.get(i).getKey()).m_203439_().left().get()).m_135782_())));
            }
            int count = 0;
            for (Map.Entry<TagKey<Biome>, Double> tag : sortedBiomeTagKeys) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Weight:" + Math.round(tag.getValue()) + " Tag: #" + tag.getKey().f_203868_())));
                if (++count < 7) continue;
                break;
            }
            for (int i = 0; i < sortedBiomeHolders.size(); ++i) {
                StructureEssentials.LOGGER.info("Weight:" + sortedBiomeHolders.get(i).getValue() + " Biome: " + ((ResourceKey)((Holder)sortedBiomeHolders.get(i).getKey()).m_203439_().left().get()).m_135782_());
            }
            for (Map.Entry<TagKey<Biome>, Double> tag : sortedBiomeTagKeys) {
                StructureEssentials.LOGGER.info("Weight:" + Math.round(tag.getValue()) + " Tag: #" + tag.getKey().f_203868_());
            }
            return 1;
        })));
    }

    public static List<Object2DoubleMap.Entry<Holder<Biome>>> getSimilarBiomesFor(Holder<Biome> biomeHolder, RegistryAccess registryAccess) {
        float f;
        List<Object2DoubleMap.Entry<Holder<Biome>>> result = biomeScoreCache.get(biomeHolder);
        if (result != null) {
            return result;
        }
        HashSet<Object> similarBiomes = new HashSet<Object>();
        Set biomeTags = biomeHolder.m_203616_().collect(Collectors.toSet());
        for (Object currentBiome : ((Registry)registryAccess.m_6632_(Registries.f_256952_).get()).m_206115_()) {
            for (TagKey tag : biomeTags) {
                if (!currentBiome.m_203656_(tag)) continue;
                similarBiomes.add(currentBiome);
            }
        }
        Object2DoubleOpenHashMap countMap = new Object2DoubleOpenHashMap();
        for (Holder holder : similarBiomes) {
            if (holder.equals(biomeHolder)) continue;
            int matching = 0;
            for (TagKey similarBiomeTagKey : holder.m_203616_().toList()) {
                if (!biomeTags.contains(similarBiomeTagKey)) continue;
                ++matching;
            }
            double matchPct = (double)matching / (double)biomeTags.size();
            matchPct = 0.7 + 0.3 * matchPct;
            countMap.put((Object)holder, matchPct);
        }
        float orgTemperature = Command.getAdjustedTemp(biomeHolder);
        float f2 = f = ((Biome)biomeHolder.m_203334_()).m_264473_() ? ((Biome)biomeHolder.m_203334_()).getModifiedClimateSettings().f_47683_() : 0.0f;
        Biome.Precipitation orgPrecipitation = !((Biome)biomeHolder.m_203334_()).m_264473_() ? Biome.Precipitation.NONE : (orgTemperature >= 0.15f ? Biome.Precipitation.RAIN : Biome.Precipitation.SNOW);
        String orgName = ((ResourceKey)biomeHolder.m_203543_().get()).m_135782_().m_135815_().toString();
        Optional orgMusic = ((Biome)biomeHolder.m_203334_()).getModifiedSpecialEffects().m_48002_();
        int orgSkyColor = ((Biome)biomeHolder.m_203334_()).getModifiedSpecialEffects().m_47978_();
        HashSet<Holder> orgFeatures = new HashSet<Holder>();
        for (HolderSet featureSet : ((Biome)biomeHolder.m_203334_()).m_47536_().m_47818_()) {
            for (Holder feature : featureSet) {
                orgFeatures.add(feature);
            }
        }
        List orgFlowerFeatures = ((Biome)biomeHolder.m_203334_()).m_47536_().m_47815_();
        MobSpawnSettings orgMobSettings = ((Biome)biomeHolder.m_203334_()).m_47518_();
        for (Object2DoubleMap.Entry ratedHolderEntry : countMap.object2DoubleEntrySet()) {
            Biome.Precipitation precipitation;
            if (((Holder)ratedHolderEntry.getKey()).equals(biomeHolder)) continue;
            Holder ratedBiomeHolder = (Holder)ratedHolderEntry.getKey();
            double modifier = 1.0;
            float temp = Command.getAdjustedTemp((Holder<Biome>)ratedBiomeHolder);
            Biome.Precipitation precipitation2 = !((Biome)ratedBiomeHolder.m_203334_()).m_264473_() ? Biome.Precipitation.NONE : (precipitation = temp >= 0.15f ? Biome.Precipitation.RAIN : Biome.Precipitation.SNOW);
            if (orgPrecipitation != precipitation) {
                modifier *= 0.7;
            } else {
                float downFallDiff = Math.abs(f - (((Biome)ratedBiomeHolder.m_203334_()).m_264473_() ? ((Biome)biomeHolder.m_203334_()).getModifiedClimateSettings().f_47683_() : 0.0f));
                modifier *= 1.0 - 0.1 * (double)downFallDiff;
                float tempDiff = Math.abs(orgTemperature - Command.getAdjustedTemp((Holder<Biome>)ratedBiomeHolder));
                modifier *= 1.0 - Math.min(0.1, (double)tempDiff * 0.1);
            }
            if (ratedBiomeHolder.toString().contains(orgName)) {
                modifier *= 1.2;
            }
            if (orgMusic.isPresent()) {
                modifier = ((Biome)ratedBiomeHolder.m_203334_()).getModifiedSpecialEffects().m_48002_().isPresent() && ((Music)((Biome)ratedBiomeHolder.m_203334_()).getModifiedSpecialEffects().m_48002_().get()).m_263193_().equals(((Music)orgMusic.get()).m_263193_()) ? (modifier *= 1.2) : (modifier *= 0.9);
            }
            if (((Biome)ratedBiomeHolder.m_203334_()).getModifiedSpecialEffects().m_47978_() != orgSkyColor) {
                modifier *= 0.9;
            }
            int matchingFeatures = 0;
            int totalFeatures = 0;
            for (HolderSet featureSet : ((Biome)ratedBiomeHolder.m_203334_()).m_47536_().m_47818_()) {
                for (Holder feature : featureSet) {
                    ++totalFeatures;
                    if (!orgFeatures.contains(feature)) continue;
                    ++matchingFeatures;
                }
            }
            int missingFeatures = orgFeatures.size() - matchingFeatures;
            int additionalFeatures = totalFeatures - missingFeatures;
            modifier *= 1.0 - Math.min(0.1, 0.1 * ((double)(missingFeatures * 3) / (double)Math.max(1, orgFeatures.size())));
            modifier *= 1.0 - 0.05 * ((double)additionalFeatures / (double)Math.max(10, orgFeatures.size()));
            if (!orgFlowerFeatures.isEmpty()) {
                int missingFlowerFeatures = 0;
                for (ConfiguredFeature feature : orgFlowerFeatures) {
                    boolean foundFlowerFeature = false;
                    for (ConfiguredFeature existing : ((Biome)ratedBiomeHolder.m_203334_()).m_47536_().m_47815_()) {
                        if (!existing.equals((Object)feature)) continue;
                        foundFlowerFeature = true;
                        break;
                    }
                    if (foundFlowerFeature) continue;
                    ++missingFlowerFeatures;
                }
                modifier *= 1.0 - 0.1 * ((double)missingFlowerFeatures / (double)orgFlowerFeatures.size());
            }
            if (!orgMobSettings.getEntityTypes().isEmpty()) {
                int missingMobs = 0;
                for (EntityType type : orgMobSettings.getEntityTypes()) {
                    if (((Biome)ratedBiomeHolder.m_203334_()).m_47518_().getEntityTypes().contains(type)) continue;
                    ++missingMobs;
                }
                modifier *= 1.0 - 0.2 * ((double)missingMobs / (double)orgMobSettings.getEntityTypes().size());
            }
            if ((double)Math.abs(orgMobSettings.m_48344_() - ((Biome)ratedBiomeHolder.m_203334_()).m_47518_().m_48344_()) > 0.1) {
                modifier *= 0.9;
            }
            ratedHolderEntry.setValue(ratedHolderEntry.getDoubleValue() * modifier);
        }
        ArrayList<Object2DoubleMap.Entry<Holder<Biome>>> sortedBiomeHolders = new ArrayList<Object2DoubleMap.Entry<Holder<Biome>>>((Collection<Object2DoubleMap.Entry<Holder<Biome>>>)countMap.object2DoubleEntrySet());
        sortedBiomeHolders.sort(Comparator.comparingDouble(e -> ((Object2DoubleMap.Entry)e).getDoubleValue()).reversed());
        biomeScoreCache.put(biomeHolder, sortedBiomeHolders);
        return sortedBiomeHolders;
    }

    public static List<Map.Entry<TagKey<Biome>, Double>> getSimilarTagsFor(Holder<Biome> biomeHolder, RegistryAccess registryAccess) {
        List biomeTags = biomeHolder.m_203616_().collect(Collectors.toList());
        List<Object2DoubleMap.Entry<Holder<Biome>>> sortedBiomeHolders = Command.getSimilarBiomesFor(biomeHolder, registryAccess);
        HashMap<TagKey, Double> tagCountMap = new HashMap<TagKey, Double>();
        int biomeCount = sortedBiomeHolders.size();
        for (int i = 0; i < sortedBiomeHolders.size(); ++i) {
            double weight = ((double)biomeCount / 6.0 - (double)i) / ((double)biomeCount / 6.0);
            if ((double)i > (double)biomeCount / 6.0) {
                weight = -((double)i - (double)biomeCount * 0.16666666666666666) / ((double)biomeCount * 0.8333333333333334);
            }
            Map.Entry biomeHolderEntry = (Map.Entry)sortedBiomeHolders.get(i);
            for (TagKey biomeHolderEntryTag : ((Holder)biomeHolderEntry.getKey()).m_203616_().toList()) {
                if (!biomeTags.contains(biomeHolderEntryTag)) continue;
                tagCountMap.put(biomeHolderEntryTag, tagCountMap.getOrDefault(biomeHolderEntryTag, 0.0) + 1.0 * weight);
            }
        }
        ArrayList<Map.Entry<TagKey<Biome>, Double>> sortedBiomeTagKeys = new ArrayList<Map.Entry<TagKey<Biome>, Double>>(tagCountMap.entrySet());
        sortedBiomeTagKeys.sort(Comparator.comparingDouble(e -> (Double)((Map.Entry)e).getValue()).reversed());
        return sortedBiomeTagKeys;
    }

    public static float getAdjustedTemp(Holder<Biome> holder) {
        Biome biome = (Biome)holder.m_203334_();
        float temp = biome.m_47554_();
        if (temp == 0.5f || temp == 0.8f) {
            String biomeString = ((ResourceKey)holder.m_203543_().get()).m_135782_().toString();
            if (biomeString.contains("hot") || biomeString.contains("warm") || biomeString.contains("desert")) {
                return 0.95f;
            }
            if (biomeString.contains("snowy") || biomeString.contains("cold") || biomeString.contains("frozen") || biomeString.contains("ice")) {
                return 0.0f;
            }
            return temp;
        }
        return temp;
    }

    private static class CustomEntry
    implements Object2IntMap.Entry<Holder<Biome>> {
        final Holder<Biome> holder;
        final int value;

        private CustomEntry(Holder<Biome> holder, int value) {
            this.holder = holder;
            this.value = value;
        }

        public int getIntValue() {
            return this.value;
        }

        public int setValue(int value) {
            throw new RuntimeException("Not Allowed to set value");
        }

        public Holder<Biome> getKey() {
            return this.holder;
        }
    }
}

