/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl.resources;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.api.resources.ITipSerializer;
import net.darkhax.tipsmod.impl.Constants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class TipManager
extends SimpleJsonResourceReloadListener {
    private final Map<ResourceLocation, ITip> loadedTips = new HashMap<ResourceLocation, ITip>();
    private final List<ITip> randomAccess = new ArrayList<ITip>();
    private final List<ITip> immutableAccess = Collections.unmodifiableList(this.randomAccess);

    public TipManager() {
        super(new Gson(), "tips");
    }

    public List<ITip> getTips() {
        return this.immutableAccess;
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.loadedTips.clear();
        this.randomAccess.clear();
        long startTime = System.nanoTime();
        map.forEach((tipId, tipData) -> {
            try {
                if (tipData instanceof JsonObject) {
                    JsonObject json = (JsonObject)tipData;
                    ResourceLocation serializerID = (ResourceLocation)Serializers.RESOURCE_LOCATION.fromJSON(json, "type", (Object)TipsAPI.DEFAULT_SERIALIZER);
                    ITipSerializer<?> serializer = TipsAPI.getTipSerializer(serializerID);
                    if (serializer == null) {
                        throw new JsonParseException("Serializer " + serializerID + " is unknown!");
                    }
                    Object tipEntry = serializer.fromJSON((ResourceLocation)tipId, json);
                    if (tipEntry == null) {
                        throw new JsonParseException("Serializer " + serializerID + " produced a null result!");
                    }
                    this.loadedTips.put((ResourceLocation)tipId, (ITip)tipEntry);
                    this.randomAccess.add((ITip)tipEntry);
                }
            }
            catch (Exception e) {
                Constants.LOG.error("Failed to load tip {}!", tipId, (Object)e);
            }
        });
        Collections.shuffle(this.randomAccess);
        Constants.LOG.debug("Loaded {} tips. Took {}ms.", (Object)this.loadedTips.size(), (Object)((double)(System.nanoTime() - startTime) / 1000000.0));
    }
}

