/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LighthingBoltPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class GenericTooltipUtils {
    private static final ChatFormatting TEXT_STYLE = ChatFormatting.GOLD;
    private static final ChatFormatting PARAM_STYLE = ChatFormatting.AQUA;

    public static @Unmodifiable @NotNull ITooltipNode getMissingFunction(IServerUtils utils, LootItemFunction function) {
        return RegistriesTooltipUtils.getFunctionTypeTooltip(utils, "ali.util.advanced_loot_info.missing", function.m_7162_());
    }

    public static @Unmodifiable @NotNull ITooltipNode getMissingCondition(IServerUtils utils, LootItemCondition condition) {
        return RegistriesTooltipUtils.getConditionTypeTooltip(utils, "ali.util.advanced_loot_info.missing", condition.m_7940_());
    }

    @NotNull
    public static List<ITooltipNode> getConditionListTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        return conditions.stream().map(condition -> utils.getConditionTooltip(utils, condition)).toList();
    }

    @NotNull
    public static List<ITooltipNode> getConditionsTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        if (!conditions.isEmpty()) {
            ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.util.advanced_loot_info.delimiter.conditions", new Object[0])));
            tooltip.addAll(GenericTooltipUtils.getConditionListTooltip(utils, conditions));
            return tooltip;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static ITooltipNode getSubConditionsTooltip(IServerUtils utils, List<LootItemCondition> conditions) {
        if (!conditions.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.property.branch.conditions", new Object[0]));
            for (ITooltipNode node : GenericTooltipUtils.getConditionListTooltip(utils, conditions)) {
                tooltip.add(node);
            }
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static List<ITooltipNode> getFunctionListTooltip(IServerUtils utils, List<LootItemFunction> functions) {
        return functions.stream().map(function -> utils.getFunctionTooltip(utils, function)).toList();
    }

    @NotNull
    public static List<ITooltipNode> getFunctionsTooltip(IServerUtils utils, List<LootItemFunction> functions) {
        if (!functions.isEmpty()) {
            ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.util.advanced_loot_info.delimiter.functions", new Object[0])));
            tooltip.addAll(GenericTooltipUtils.getFunctionListTooltip(utils, functions));
            return tooltip;
        }
        return Collections.emptyList();
    }

    public static @Unmodifiable @NotNull ITooltipNode getFormulaTooltip(IServerUtils utils, String key, ApplyBonusCount.Formula formula) {
        ITooltipNode tooltip = GenericTooltipUtils.getResourceLocationTooltip(utils, key, formula.m_5713_());
        if (formula instanceof ApplyBonusCount.BinomialWithBonusCount) {
            ApplyBonusCount.BinomialWithBonusCount binomialWithBonusCount = (ApplyBonusCount.BinomialWithBonusCount)formula;
            tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.extra_rounds", binomialWithBonusCount.f_79948_));
            tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.probability", Float.valueOf(binomialWithBonusCount.f_79949_)));
        } else if (formula instanceof ApplyBonusCount.UniformBonusCount) {
            ApplyBonusCount.UniformBonusCount uniformBonusCount = (ApplyBonusCount.UniformBonusCount)formula;
            tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.bonus_multiplier", uniformBonusCount.f_80013_));
        }
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getPropertyTooltip(IServerUtils utils, String key, Property<?> property) {
        return GenericTooltipUtils.getStringTooltip(utils, key, property.m_61708_());
    }

    @NotNull
    public static ITooltipNode getModifierTooltip(IServerUtils utils, String key, SetAttributesFunction.Modifier modifier) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.name", modifier.f_80847_));
        tooltip.add(RegistriesTooltipUtils.getAttributeTooltip(utils, "ali.property.value.attribute", modifier.f_80848_));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.operation", modifier.f_80849_));
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.amount", modifier.f_80850_));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.uuid", modifier.f_80851_, GenericTooltipUtils::getUUIDTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.equipment_slots", "ali.property.value.null", List.of(modifier.f_80852_), GenericTooltipUtils::getEnumTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getUUIDTooltip(IServerUtils utils, String key, UUID uuid) {
        return new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.uuid", GenericTooltipUtils.value(uuid)));
    }

    @NotNull
    public static ITooltipNode getBannerPatternsTooltip(IServerUtils utils, String key, Pair<Holder<BannerPattern>, DyeColor> pair) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, key, (Holder)pair.getFirst(), RegistriesTooltipUtils::getBannerPatternTooltip);
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.color", (Enum)pair.getSecond()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getStatePropertiesPredicateTooltip(IServerUtils utils, String key, StatePropertiesPredicate propertiesPredicate) {
        return GenericTooltipUtils.getCollectionTooltip(utils, key, propertiesPredicate.f_67659_, GenericTooltipUtils::getPropertyMatcherTooltip);
    }

    @NotNull
    public static ITooltipNode getPropertyMatcherTooltip(IServerUtils ignoredUtils, StatePropertiesPredicate.PropertyMatcher propertyMatcher) {
        if (propertyMatcher instanceof StatePropertiesPredicate.ExactPropertyMatcher) {
            StatePropertiesPredicate.ExactPropertyMatcher matcher = (StatePropertiesPredicate.ExactPropertyMatcher)propertyMatcher;
            return new TooltipNode(GenericTooltipUtils.keyValue(matcher.f_67715_, matcher.f_67707_));
        }
        if (propertyMatcher instanceof StatePropertiesPredicate.RangedPropertyMatcher) {
            StatePropertiesPredicate.RangedPropertyMatcher matcher = (StatePropertiesPredicate.RangedPropertyMatcher)propertyMatcher;
            String min = matcher.f_67727_;
            String max = matcher.f_67728_;
            if (min != null) {
                if (max != null) {
                    return new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_both", matcher.f_67715_, min, max)));
                }
                return new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_gte", matcher.f_67715_, min)));
            }
            if (max != null) {
                return new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_lte", matcher.f_67715_, max)));
            }
            return new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_any", matcher.f_67715_)));
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getDamageSourcePredicateTooltip(IServerUtils utils, String key, DamageSourcePredicate damagePredicate) {
        if (damagePredicate != DamageSourcePredicate.f_25420_) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.tags", "ali.property.value.null", damagePredicate.f_268608_, GenericTooltipUtils::getTagPredicateTooltip));
            tooltip.add(GenericTooltipUtils.getEntityPredicateTooltip(utils, "ali.property.branch.direct_entity", damagePredicate.f_25429_));
            tooltip.add(GenericTooltipUtils.getEntityPredicateTooltip(utils, "ali.property.branch.source_entity", damagePredicate.f_25430_));
            return tooltip;
        }
        return new TooltipNode();
    }

    public static <T> @Unmodifiable @NotNull ITooltipNode getTagPredicateTooltip(IServerUtils utils, String key, TagPredicate<T> tagPredicate) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.keyValue(tagPredicate.f_268479_.f_203868_().toString(), tagPredicate.f_268414_)));
    }

    @NotNull
    public static ITooltipNode getEntityPredicateTooltip(IServerUtils utils, String key, EntityPredicate entityPredicate) {
        if (entityPredicate != EntityPredicate.f_36550_) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            tooltip.add(GenericTooltipUtils.getEntityTypePredicateTooltip(utils, "ali.property.value.entity_type", entityPredicate.f_36551_));
            tooltip.add(GenericTooltipUtils.getDistancePredicateTooltip(utils, "ali.property.branch.distance_to_player", entityPredicate.f_36552_));
            tooltip.add(GenericTooltipUtils.getLocationPredicateTooltip(utils, "ali.property.branch.location", entityPredicate.f_36553_));
            tooltip.add(GenericTooltipUtils.getLocationPredicateTooltip(utils, "ali.property.branch.stepping_on_location", entityPredicate.f_150285_));
            tooltip.add(GenericTooltipUtils.getMobEffectPredicateTooltip(utils, "ali.property.branch.mob_effects", entityPredicate.f_36554_));
            tooltip.add(GenericTooltipUtils.getNbtPredicateTooltip(utils, "ali.property.value.nbt", entityPredicate.f_36555_));
            tooltip.add(GenericTooltipUtils.getEntityFlagsPredicateTooltip(utils, "ali.property.branch.entity_flags", entityPredicate.f_36556_));
            tooltip.add(GenericTooltipUtils.getEntityEquipmentPredicateTooltip(utils, "ali.property.branch.entity_equipment", entityPredicate.f_36557_));
            tooltip.add(GenericTooltipUtils.getEntitySubPredicateTooltip(utils, "ali.property.branch.entity_sub_predicate", entityPredicate.f_218773_));
            tooltip.add(GenericTooltipUtils.getEntityPredicateTooltip(utils, "ali.property.branch.vehicle", entityPredicate.f_36560_));
            tooltip.add(GenericTooltipUtils.getEntityPredicateTooltip(utils, "ali.property.branch.passenger", entityPredicate.f_150287_));
            tooltip.add(GenericTooltipUtils.getEntityPredicateTooltip(utils, "ali.property.branch.targeted_entity", entityPredicate.f_36561_));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.team", entityPredicate.f_36562_, GenericTooltipUtils::getStringTooltip));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getEntityTypePredicateTooltip(IServerUtils utils, String key, EntityTypePredicate entityTypePredicate) {
        if (entityTypePredicate != EntityTypePredicate.f_37636_) {
            if (entityTypePredicate instanceof EntityTypePredicate.TypePredicate) {
                EntityTypePredicate.TypePredicate typePredicate = (EntityTypePredicate.TypePredicate)entityTypePredicate;
                return RegistriesTooltipUtils.getEntityTypeTooltip(utils, key, typePredicate.f_37659_);
            }
            if (entityTypePredicate instanceof EntityTypePredicate.TagPredicate) {
                EntityTypePredicate.TagPredicate tagPredicate = (EntityTypePredicate.TagPredicate)entityTypePredicate;
                return GenericTooltipUtils.getTagKeyTooltip(utils, key, tagPredicate.f_37653_);
            }
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getDistancePredicateTooltip(IServerUtils utils, String key, DistancePredicate distancePredicate) {
        if (distancePredicate != DistancePredicate.f_26241_) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.x", distancePredicate.f_26242_));
            tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.y", distancePredicate.f_26243_));
            tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.z", distancePredicate.f_26244_));
            tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.horizontal", distancePredicate.f_26245_));
            tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.absolute", distancePredicate.f_26246_));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getLocationPredicateTooltip(IServerUtils utils, String key, LocationPredicate locationPredicate) {
        if (locationPredicate != LocationPredicate.f_52592_) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.x", locationPredicate.f_52594_));
            tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.y", locationPredicate.f_52595_));
            tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.z", locationPredicate.f_52596_));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.biome", locationPredicate.f_52597_, GenericTooltipUtils::getResourceKeyTooltip));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.structure", locationPredicate.f_220588_, GenericTooltipUtils::getResourceKeyTooltip));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.dimension", locationPredicate.f_52599_, GenericTooltipUtils::getResourceKeyTooltip));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.smokey", locationPredicate.f_52600_, GenericTooltipUtils::getBooleanTooltip));
            tooltip.add(GenericTooltipUtils.getLightPredicateTooltip(utils, "ali.property.value.light", locationPredicate.f_52601_));
            tooltip.add(GenericTooltipUtils.getBlockPredicateTooltip(utils, "ali.property.branch.block_predicate", locationPredicate.f_52602_));
            tooltip.add(GenericTooltipUtils.getFluidPredicateTooltip(utils, "ali.property.branch.fluid_predicate", locationPredicate.f_52603_));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getLightPredicateTooltip(IServerUtils utils, String key, LightPredicate lightPredicate) {
        if (lightPredicate != LightPredicate.f_51335_) {
            return GenericTooltipUtils.getMinMaxBoundsTooltip(utils, key, lightPredicate.f_51336_);
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getBlockPredicateTooltip(IServerUtils utils, String key, BlockPredicate blockPredicate) {
        if (blockPredicate != BlockPredicate.f_17902_) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.tag", blockPredicate.f_17903_, GenericTooltipUtils::getTagKeyTooltip));
            tooltip.add(GenericTooltipUtils.getOptionalCollectionTooltip(utils, "ali.property.branch.blocks", "ali.property.value.null", blockPredicate.f_146710_, RegistriesTooltipUtils::getBlockTooltip));
            tooltip.add(GenericTooltipUtils.getStatePropertiesPredicateTooltip(utils, "ali.property.branch.properties", blockPredicate.f_17905_));
            tooltip.add(GenericTooltipUtils.getNbtPredicateTooltip(utils, "ali.property.value.nbt", blockPredicate.f_17906_));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getNbtPredicateTooltip(IServerUtils utils, String key, NbtPredicate nbtPredicate) {
        if (nbtPredicate != NbtPredicate.f_57471_) {
            return GenericTooltipUtils.getOptionalTooltip(utils, key, nbtPredicate.f_57472_, GenericTooltipUtils::getCompoundTagTooltip);
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getFluidPredicateTooltip(IServerUtils utils, String key, FluidPredicate fluidPredicate) {
        if (fluidPredicate != FluidPredicate.f_41094_) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.tag", fluidPredicate.f_41095_, GenericTooltipUtils::getTagKeyTooltip));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.fluid", fluidPredicate.f_41096_, RegistriesTooltipUtils::getFluidTooltip));
            tooltip.add(GenericTooltipUtils.getStatePropertiesPredicateTooltip(utils, "ali.property.branch.properties", fluidPredicate.f_41097_));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getMobEffectPredicateTooltip(IServerUtils utils, String key, MobEffectsPredicate mobEffectsPredicate) {
        if (mobEffectsPredicate != MobEffectsPredicate.f_56547_) {
            return GenericTooltipUtils.getMapTooltip(utils, key, mobEffectsPredicate.f_56548_, GenericTooltipUtils::getMobEffectPredicateEntryTooltip);
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getEntityFlagsPredicateTooltip(IServerUtils utils, String key, EntityFlagsPredicate predicate) {
        if (predicate != EntityFlagsPredicate.f_33682_) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_on_fire", predicate.f_33683_, GenericTooltipUtils::getBooleanTooltip));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_baby", predicate.f_33687_, GenericTooltipUtils::getBooleanTooltip));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_crouching", predicate.f_33684_, GenericTooltipUtils::getBooleanTooltip));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_sprinting", predicate.f_33685_, GenericTooltipUtils::getBooleanTooltip));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_swimming", predicate.f_33686_, GenericTooltipUtils::getBooleanTooltip));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getEntityEquipmentPredicateTooltip(IServerUtils utils, String key, EntityEquipmentPredicate predicate) {
        if (predicate != EntityEquipmentPredicate.f_32176_) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            tooltip.add(GenericTooltipUtils.getItemPredicateTooltip(utils, "ali.property.branch.head", predicate.f_32178_));
            tooltip.add(GenericTooltipUtils.getItemPredicateTooltip(utils, "ali.property.branch.chest", predicate.f_32179_));
            tooltip.add(GenericTooltipUtils.getItemPredicateTooltip(utils, "ali.property.branch.legs", predicate.f_32180_));
            tooltip.add(GenericTooltipUtils.getItemPredicateTooltip(utils, "ali.property.branch.feet", predicate.f_32181_));
            tooltip.add(GenericTooltipUtils.getItemPredicateTooltip(utils, "ali.property.branch.mainhand", predicate.f_32182_));
            tooltip.add(GenericTooltipUtils.getItemPredicateTooltip(utils, "ali.property.branch.offhand", predicate.f_32183_));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getItemPredicateTooltip(IServerUtils utils, String key, ItemPredicate itemPredicate) {
        if (itemPredicate != ItemPredicate.f_45028_) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.tag", itemPredicate.f_45029_, GenericTooltipUtils::getTagKeyTooltip));
            tooltip.add(GenericTooltipUtils.getOptionalCollectionTooltip(utils, "ali.property.branch.items", "ali.property.value.null", itemPredicate.f_151427_, RegistriesTooltipUtils::getItemTooltip));
            tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.count", itemPredicate.f_45031_));
            tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.durability", itemPredicate.f_45032_));
            tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.enchantments", "ali.property.value.null", List.of(itemPredicate.f_45033_), GenericTooltipUtils::getEnchantmentPredicateTooltip));
            tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.stored_enchantments", "ali.property.value.null", List.of(itemPredicate.f_45034_), GenericTooltipUtils::getEnchantmentPredicateTooltip));
            tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.potion", itemPredicate.f_45035_, RegistriesTooltipUtils::getPotionTooltip));
            tooltip.add(GenericTooltipUtils.getNbtPredicateTooltip(utils, "ali.property.value.nbt", itemPredicate.f_45036_));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getEnchantmentPredicateTooltip(IServerUtils utils, String key, EnchantmentPredicate enchantmentPredicate) {
        if (enchantmentPredicate != EnchantmentPredicate.f_30464_) {
            ITooltipNode tooltip = enchantmentPredicate.f_30466_ != null ? GenericTooltipUtils.getOptionalTooltip(utils, key, enchantmentPredicate.f_30466_, RegistriesTooltipUtils::getEnchantmentTooltip) : new TooltipNode();
            tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.level", enchantmentPredicate.f_30467_));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getEntitySubPredicateTooltip(IServerUtils utils, String key, EntitySubPredicate entitySubPredicate) {
        if (entitySubPredicate != EntitySubPredicate.f_218826_) {
            Optional<Map.Entry> optional = EntitySubPredicate.Types.f_218854_.entrySet().stream().filter(p -> p.getValue() == entitySubPredicate.m_213836_()).findFirst();
            return optional.map(entry -> {
                TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, entry.getKey()));
                if (entitySubPredicate instanceof LighthingBoltPredicate) {
                    LighthingBoltPredicate boltPredicate = (LighthingBoltPredicate)entitySubPredicate;
                    tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.blocks_on_fire", boltPredicate.f_153235_));
                    tooltip.add(GenericTooltipUtils.getEntityPredicateTooltip(utils, "ali.property.branch.stuck_entity", boltPredicate.f_153236_));
                } else if (entitySubPredicate instanceof FishingHookPredicate) {
                    FishingHookPredicate fishingHookPredicate = (FishingHookPredicate)entitySubPredicate;
                    tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.in_open_water", fishingHookPredicate.f_39757_));
                } else if (entitySubPredicate instanceof PlayerPredicate) {
                    PlayerPredicate playerPredicate = (PlayerPredicate)entitySubPredicate;
                    tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.level", playerPredicate.f_62245_));
                    tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.game_type", playerPredicate.f_62246_, GenericTooltipUtils::getEnumTooltip));
                    tooltip.add(GenericTooltipUtils.getStatsTooltip(utils, "ali.property.branch.stats", playerPredicate.f_62247_));
                    tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.recipes", playerPredicate.f_62248_, GenericTooltipUtils::getRecipeEntryTooltip));
                    tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.advancements", playerPredicate.f_62249_, GenericTooltipUtils::getAdvancementEntryTooltip));
                    tooltip.add(GenericTooltipUtils.getEntityPredicateTooltip(utils, "ali.property.branch.looking_at", playerPredicate.f_156744_));
                } else if (entitySubPredicate instanceof SlimePredicate) {
                    SlimePredicate slimePredicate = (SlimePredicate)entitySubPredicate;
                    tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.size", slimePredicate.f_223418_));
                } else {
                    JsonObject jsonObject = entitySubPredicate.m_213616_();
                    if (jsonObject.has("variant")) {
                        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.variant", jsonObject.getAsJsonPrimitive("variant").getAsString()));
                    } else {
                        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.variant", jsonObject.getAsString()));
                    }
                }
                return tooltip;
            }).orElse(new TooltipNode());
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getStatsTooltip(IServerUtils utils, String key, Map<Stat<?>, MinMaxBounds.Ints> statIntsMap) {
        if (!statIntsMap.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            statIntsMap.forEach((stat, ints) -> {
                Object value = stat.m_12867_();
                if (value instanceof Item) {
                    Item item = (Item)value;
                    ITooltipNode itemTooltip = RegistriesTooltipUtils.getItemTooltip(utils, "ali.property.value.item", item);
                    itemTooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(stat.m_12859_().m_12905_(), GenericTooltipUtils.toString(ints))));
                    tooltip.add(itemTooltip);
                } else if (value instanceof Block) {
                    Block block = (Block)value;
                    ITooltipNode blockTooltip = RegistriesTooltipUtils.getBlockTooltip(utils, "ali.property.value.block", block);
                    blockTooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(stat.m_12859_().m_12905_(), GenericTooltipUtils.toString(ints))));
                    tooltip.add(blockTooltip);
                } else if (value instanceof EntityType) {
                    EntityType entityType = (EntityType)value;
                    ITooltipNode entityTooltip = RegistriesTooltipUtils.getEntityTypeTooltip(utils, "ali.property.value.entity_type", entityType);
                    entityTooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(stat.m_12859_().m_12905_(), GenericTooltipUtils.toString(ints))));
                    tooltip.add(entityTooltip);
                } else if (value instanceof ResourceLocation) {
                    ResourceLocation resourceLocation = (ResourceLocation)value;
                    ITooltipNode locationTooltip = GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.property.value.id", resourceLocation);
                    locationTooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(GenericTooltipUtils.translatable(GenericTooltipUtils.getTranslationKey(resourceLocation), new Object[0]), GenericTooltipUtils.toString(ints))));
                    tooltip.add(locationTooltip);
                }
            });
            return tooltip;
        }
        return new TooltipNode();
    }

    public static @Unmodifiable @NotNull ITooltipNode getBlockPosTooltip(IServerUtils ignoredUtils, String key, BlockPos pos) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(pos.m_123341_()), GenericTooltipUtils.value(pos.m_123342_()), GenericTooltipUtils.value(pos.m_123343_())));
    }

    @NotNull
    public static ITooltipNode getCopyOperationTooltip(IServerUtils utils, String key, CopyNbtFunction.CopyOperation copyOperation) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.source", copyOperation.f_80288_));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.target", copyOperation.f_80290_));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.merge_strategy", copyOperation.f_80292_));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getCompoundTagTooltip(IServerUtils ignoredUtils, String key, CompoundTag tag) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(tag.toString())));
    }

    @NotNull
    public static ITooltipNode getAdvancementPredicateTooltip(IServerUtils utils, String key, PlayerPredicate.AdvancementPredicate predicate) {
        if (predicate instanceof PlayerPredicate.AdvancementDonePredicate) {
            PlayerPredicate.AdvancementDonePredicate donePredicate = (PlayerPredicate.AdvancementDonePredicate)predicate;
            return new TooltipNode(GenericTooltipUtils.translatable(key, donePredicate.f_62299_));
        }
        if (predicate instanceof PlayerPredicate.AdvancementCriterionsPredicate) {
            PlayerPredicate.AdvancementCriterionsPredicate criterionsPredicate = (PlayerPredicate.AdvancementCriterionsPredicate)predicate;
            return GenericTooltipUtils.getMapTooltip(utils, criterionsPredicate.f_62291_, GenericTooltipUtils::getCriterionEntryTooltip);
        }
        return new TooltipNode();
    }

    public static @Unmodifiable @NotNull ITooltipNode getItemStackTooltip(IServerUtils utils, String key, ItemStack item) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(RegistriesTooltipUtils.getItemTooltip(utils, "ali.property.value.item", item.m_41720_()));
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.count", item.m_41613_()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.tag", item.m_41783_(), GenericTooltipUtils::getCompoundTagTooltip));
        return tooltip;
    }

    @NotNull
    public static Component translatable(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])Arrays.stream(args).map(GenericTooltipUtils::convertObject).toArray()).m_130940_(TEXT_STYLE);
    }

    @NotNull
    public static Component value(Object value) {
        return GenericTooltipUtils.convertObject(value).m_130944_(new ChatFormatting[]{PARAM_STYLE, ChatFormatting.BOLD});
    }

    @NotNull
    public static Component value(Object value, String unit) {
        return Component.m_237110_((String)"ali.util.advanced_loot_info.two_values", (Object[])new Object[]{GenericTooltipUtils.convertObject(value), unit}).m_130944_(new ChatFormatting[]{PARAM_STYLE, ChatFormatting.BOLD});
    }

    @NotNull
    public static Component pair(Object value1, Object value2) {
        return Component.m_237110_((String)"ali.util.advanced_loot_info.two_values_with_space", (Object[])new Object[]{GenericTooltipUtils.convertObject(value1), GenericTooltipUtils.convertObject(value2)});
    }

    @NotNull
    public static Component pad(int count, Object arg) {
        if (count > 0) {
            return GenericTooltipUtils.pair(Component.m_237115_((String)("ali.util.advanced_loot_info.pad." + count)), GenericTooltipUtils.convertObject(arg));
        }
        return GenericTooltipUtils.convertObject(arg);
    }

    @NotNull
    public static Component keyValue(Object key, Object value) {
        return GenericTooltipUtils.translatable("ali.util.advanced_loot_info.key_value", GenericTooltipUtils.convertObject(key), GenericTooltipUtils.value(value));
    }

    public static @Unmodifiable @NotNull ITooltipNode getNumberProviderTooltip(IServerUtils utils, String key, NumberProvider value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(utils.convertNumber(utils, value))));
    }

    public static @Unmodifiable @NotNull ITooltipNode getIntRangeTooltip(IServerUtils utils, String key, IntRange range) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(RangeValue.rangeToString(utils.convertNumber(utils, range.f_165001_), utils.convertNumber(utils, range.f_165002_)))));
    }

    public static @Unmodifiable @NotNull ITooltipNode getBooleanTooltip(IServerUtils utils, String key, Boolean value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getIntegerTooltip(IServerUtils ignoredUtils, String key, int value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getLongTooltip(IServerUtils ignoredUtils, String key, Long value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getStringTooltip(IServerUtils utils, String key, String value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getFloatTooltip(IServerUtils ignoredUtils, String key, Float value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getDoubleTooltip(IServerUtils ignoredUtils, String key, Double value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getEnumTooltip(IServerUtils ignoredUtils, String key, Enum<?> value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value.name())));
    }

    public static @Unmodifiable @NotNull ITooltipNode getResourceLocationTooltip(IServerUtils ignoredUtils, String key, ResourceLocation value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static <T> @Unmodifiable @NotNull ITooltipNode getBuiltInRegistryTooltip(IServerUtils utils, String key, Registry<T> registry, T value) {
        return GenericTooltipUtils.getOptionalTooltip(utils, key, registry.m_7981_(value), GenericTooltipUtils::getResourceLocationTooltip);
    }

    public static <T> @Unmodifiable @NotNull ITooltipNode getResourceKeyTooltip(IServerUtils utils, String key, ResourceKey<T> value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value.m_135782_())));
    }

    public static @Unmodifiable @NotNull ITooltipNode getTagKeyTooltip(IServerUtils utils, String key, TagKey<?> value) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, key, value.f_203868_());
    }

    public static @Unmodifiable @NotNull ITooltipNode getComponentTooltip(IServerUtils ignoredUtils, String key, Component component) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(component.m_6881_())));
    }

    @NotNull
    public static ITooltipNode getMinMaxBoundsTooltip(IServerUtils ignoredUtils, String key, MinMaxBounds.Ints ints) {
        if (ints != MinMaxBounds.Ints.f_55364_) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(GenericTooltipUtils.toString(ints))));
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getMinMaxBoundsTooltip(IServerUtils ignoredUtils, String key, MinMaxBounds.Doubles doubles) {
        if (doubles != MinMaxBounds.Doubles.f_154779_) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(GenericTooltipUtils.toString(doubles))));
        }
        return new TooltipNode();
    }

    @NotNull
    public static <T> ITooltipNode getOptionalTooltip(IServerUtils utils, String key, @Nullable T optional, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        if (optional != null) {
            return (ITooltipNode)mapper.apply((Object)utils, (Object)key, optional);
        }
        return new TooltipNode();
    }

    @NotNull
    public static <T> ITooltipNode getHolderTooltip(IServerUtils utils, String key, Holder<T> holder, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        return (ITooltipNode)mapper.apply((Object)utils, (Object)key, holder.m_203334_());
    }

    @NotNull
    public static <T> ITooltipNode getCollectionTooltip(IServerUtils utils, String key, Collection<T> values, BiFunction<IServerUtils, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            values.forEach(value -> tooltip.add((ITooltipNode)mapper.apply(utils, value)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <T> ITooltipNode getCollectionTooltip(IServerUtils utils, String key, String value, Collection<T> values, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            values.forEach(v -> tooltip.add((ITooltipNode)mapper.apply((Object)utils, (Object)value, v)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <T> ITooltipNode getOptionalCollectionTooltip(IServerUtils utils, String key, String value, @Nullable Collection<T> values, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        if (values != null && !values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            values.forEach(v -> tooltip.add((ITooltipNode)mapper.apply((Object)utils, (Object)value, v)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <K, V> ITooltipNode getMapTooltip(IServerUtils utils, Map<K, V> values, BiFunction<IServerUtils, Map.Entry<K, V>, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode();
            values.entrySet().forEach(e -> tooltip.add((ITooltipNode)mapper.apply(utils, (Map.Entry)e)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <K, V> ITooltipNode getMapTooltip(IServerUtils utils, String key, Map<K, V> values, BiFunction<IServerUtils, Map.Entry<K, V>, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            values.entrySet().forEach(e -> tooltip.add((ITooltipNode)mapper.apply(utils, (Map.Entry)e)));
            return tooltip;
        }
        return new TooltipNode();
    }

    public static @Unmodifiable @NotNull ITooltipNode getRecipeEntryTooltip(IServerUtils ignoredUtils, Map.Entry<ResourceLocation, Boolean> entry) {
        return new TooltipNode(GenericTooltipUtils.keyValue(entry.getKey(), entry.getValue()));
    }

    public static @Unmodifiable @NotNull ITooltipNode getCriterionEntryTooltip(IServerUtils ignoredUtils, Map.Entry<String, Boolean> entry) {
        return new TooltipNode(GenericTooltipUtils.keyValue(entry.getKey(), entry.getValue()));
    }

    @NotNull
    public static ITooltipNode getIntRangeEntryTooltip(IServerUtils utils, Map.Entry<String, IntRange> entry) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.value(entry.getKey()));
        tooltip.add(GenericTooltipUtils.getIntRangeTooltip(utils, "ali.property.value.limit", entry.getValue()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMobEffectPredicateEntryTooltip(IServerUtils utils, Map.Entry<MobEffect, MobEffectsPredicate.MobEffectInstancePredicate> entry) {
        ITooltipNode tooltip = RegistriesTooltipUtils.getMobEffectTooltip(utils, "ali.property.value.null", entry.getKey());
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.amplifier", entry.getValue().f_56566_));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.duration", entry.getValue().f_56567_));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_ambient", entry.getValue().f_56568_, GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_visible", entry.getValue().f_56569_, GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEnchantmentLevelsEntryTooltip(IServerUtils utils, Map.Entry<Enchantment, NumberProvider> entry) {
        ITooltipNode tooltip = RegistriesTooltipUtils.getEnchantmentTooltip(utils, "ali.property.value.null", entry.getKey());
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.levels", entry.getValue()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMobEffectDurationEntryTooltip(IServerUtils utils, Map.Entry<MobEffect, NumberProvider> entry) {
        ITooltipNode tooltip = RegistriesTooltipUtils.getMobEffectTooltip(utils, "ali.property.value.null", entry.getKey());
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.duration", entry.getValue()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getAdvancementEntryTooltip(IServerUtils utils, Map.Entry<ResourceLocation, PlayerPredicate.AdvancementPredicate> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.property.value.null", entry.getKey());
        tooltip.add(GenericTooltipUtils.getAdvancementPredicateTooltip(utils, "ali.property.value.done", entry.getValue()));
        return tooltip;
    }

    @NotNull
    private static String toString(MinMaxBounds.Doubles doubles) {
        Double min = (Double)doubles.m_55305_();
        Double max = (Double)doubles.m_55326_();
        if (min != null) {
            if (max != null) {
                if (!Objects.equals(min, max)) {
                    return String.format("%.1f-%.1f", min, max);
                }
                return String.format("=%.1f", min);
            }
            return String.format("\u2265%.1f", min);
        }
        if (max != null) {
            return String.format("\u2264%.1f", max);
        }
        return "???";
    }

    @NotNull
    private static String toString(MinMaxBounds.Ints ints) {
        Integer min = (Integer)ints.m_55305_();
        Integer max = (Integer)ints.m_55326_();
        if (min != null) {
            if (max != null) {
                if (!Objects.equals(min, max)) {
                    return String.format("%d-%d", min, max);
                }
                return String.format("=%d", min);
            }
            return String.format("\u2265%d", min);
        }
        if (max != null) {
            return String.format("\u2264%d", max);
        }
        return "???";
    }

    @NotNull
    private static MutableComponent convertObject(@Nullable Object object) {
        if (object instanceof MutableComponent) {
            MutableComponent component = (MutableComponent)object;
            return component;
        }
        if (object != null) {
            return Component.m_237113_((String)object.toString());
        }
        return Component.m_237113_((String)"null");
    }

    @NotNull
    private static String getTranslationKey(ResourceLocation location) {
        return "stat." + location.toString().replace(':', '.');
    }
}

