/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

public final class ItemStackCondition
implements Operation<ItemStack, Boolean> {
    private final Optional<HolderSet<Item>> optItemEntries;
    private final Optional<NbtPredicate> optNbt;

    private ItemStackCondition(Optional<HolderSet<Item>> optItemEntries, Optional<NbtPredicate> optNbt) {
        this.optItemEntries = optItemEntries;
        this.optNbt = optNbt;
    }

    public static void register() {
        BuiltinPrototypes.ITEM_STACK.registerOperation(SkillsMod.createIdentifier("test"), BuiltinPrototypes.BOOLEAN, ItemStackCondition::parse);
    }

    public static Result<ItemStackCondition, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(ItemStackCondition::parse, context));
    }

    public static Result<ItemStackCondition, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<HolderSet<Item>> optItem = rootObject.get("item").getSuccess().flatMap(itemElement -> BuiltinJson.parseItemOrItemTag(itemElement).ifFailure(problems::add).getSuccess());
        Optional<NbtPredicate> optNbt = rootObject.get("nbt").getSuccess().flatMap(stateElement -> BuiltinJson.parseNbtPredicate(stateElement).ifFailure(problems::add).getSuccess());
        if (problems.isEmpty()) {
            return Result.success(new ItemStackCondition(optItem, optNbt));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public Optional<Boolean> apply(ItemStack itemStack) {
        return Optional.of(this.optItemEntries.map(itemEntries -> itemEntries.m_203333_(itemStack.m_220173_())).orElse(true) != false && this.optNbt.map(nbt -> nbt.m_57479_(itemStack)).orElse(true) != false);
    }
}

