/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.utils.animation;

public interface Easing {
    public static final Easing easeInSine = t -> 1.0 - Math.cos(t * Math.PI / 2.0);
    public static final Easing easeOutSine = t -> Math.sin(t * Math.PI / 2.0);
    public static final Easing easeInOutSine = t -> -(Math.cos(Math.PI * t) - 1.0) / 2.0;
    public static final Easing easeInQuad = t -> t * t;
    public static final Easing easeOutQuad = t -> 1.0 - (1.0 - t) * (1.0 - t);
    public static final Easing easeInOutQuad = t -> t < 0.5 ? 2.0 * t * t : 1.0 - (-2.0 * t + 2.0) * (-2.0 * t + 2.0) / 2.0;
    public static final Easing easeInCubic = t -> t * t * t;
    public static final Easing easeOutCubic = t -> 1.0 - Math.pow(1.0 - t, 3.0);
    public static final Easing easeInOutCubic = t -> t < 0.5 ? 4.0 * t * t * t : 1.0 - Math.pow(-2.0 * t + 2.0, 3.0) / 2.0;
    public static final Easing easeInQuart = t -> t * t * t * t;
    public static final Easing easeOutQuart = t -> 1.0 - Math.pow(1.0 - t, 4.0);
    public static final Easing easeInOutQuart = t -> t < 0.5 ? 8.0 * t * t * t * t : 1.0 - Math.pow(-2.0 * t + 2.0, 4.0) / 2.0;
    public static final Easing easeInQuint = t -> t * t * t * t * t;
    public static final Easing easeOutQuint = t -> 1.0 - Math.pow(1.0 - t, 5.0);
    public static final Easing easeInOutQuint = t -> t < 0.5 ? 16.0 * t * t * t * t * t : 1.0 - Math.pow(-2.0 * t + 2.0, 5.0) / 2.0;
    public static final Easing easeInExpo = t -> t == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * (t - 1.0));
    public static final Easing easeOutExpo = t -> t == 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * t);
    public static final Easing easeInOutExpo = t -> t == 0.0 ? 0.0 : (t == 1.0 ? 1.0 : (t < 0.5 ? Math.pow(2.0, 20.0 * t - 10.0) / 2.0 : (2.0 - Math.pow(2.0, -20.0 * t + 10.0)) / 2.0));
    public static final Easing easeInCirc = t -> 1.0 - Math.sqrt(1.0 - t * t);
    public static final Easing easeOutCirc = t -> Math.sqrt(1.0 - Math.pow(t - 1.0, 2.0));
    public static final Easing easeInOutCirc = t -> t < 0.5 ? (1.0 - Math.sqrt(1.0 - 4.0 * t * t)) / 2.0 : (Math.sqrt(1.0 - -4.0 * t * t) + 1.0) / 2.0;
    public static final Easing easeInBack = t -> {
        double c1 = 1.70158;
        double c3 = c1 + 1.0;
        return c3 * t * t * t - c1 * t * t;
    };
    public static final Easing easeOutBack = t -> {
        double c1 = 1.70158;
        double c3 = c1 + 1.0;
        return 1.0 + c3 * (t - 1.0) * (t - 1.0) * (t - 1.0) - c1 * (t - 1.0) * (t - 1.0);
    };
    public static final Easing easeInOutBack = t -> {
        double c1 = 1.70158;
        double c2 = c1 * 1.525;
        return t < 0.5 ? Math.pow(2.0 * t, 2.0) * ((c2 + 1.0) * 2.0 * t - c2) / 2.0 : (Math.pow(2.0 * t - 2.0, 2.0) * ((c2 + 1.0) * (t * 2.0 - 2.0) + c2) + 2.0) / 2.0;
    };
    public static final Easing easeInElastic = t -> {
        double c4 = 2.0943951023931953;
        return t == 0.0 ? 0.0 : (t == 1.0 ? 1.0 : -Math.pow(2.0, 10.0 * t - 10.0) * Math.sin((t * 10.0 - 10.75) * c4));
    };
    public static final Easing easeOutElastic = t -> {
        double c4 = 2.0943951023931953;
        return t == 0.0 ? 0.0 : (t == 1.0 ? 1.0 : Math.pow(2.0, -10.0 * t) * Math.sin((t * 10.0 - 0.75) * c4) + 1.0);
    };
    public static final Easing easeInOutElastic = t -> {
        double c5 = 1.3962634015954636;
        return t == 0.0 ? 0.0 : (t == 1.0 ? 1.0 : (t < 0.5 ? -(Math.pow(2.0, 20.0 * t - 10.0) * Math.sin((20.0 * t - 11.125) * c5)) / 2.0 : Math.pow(2.0, -20.0 * t + 10.0) * Math.sin((20.0 * t - 11.125) * c5) / 2.0 + 1.0));
    };
    public static final Easing easeOutBounce = t -> {
        double n1 = 7.5625;
        double d1 = 2.75;
        if (t < 1.0 / d1) {
            return n1 * t * t;
        }
        if (t < 2.0 / d1) {
            return n1 * (t -= 1.5 / d1) * t + 0.75;
        }
        if (t < 2.5 / d1) {
            return n1 * (t -= 2.25 / d1) * t + 0.9375;
        }
        return n1 * (t -= 2.625 / d1) * t + 0.984375;
    };
    public static final Easing easeInBounce = t -> 1.0 - easeOutBounce.ease(1.0 - t);
    public static final Easing easeInOutBounce = t -> t < 0.5 ? (1.0 - easeOutBounce.ease(1.0 - 2.0 * t)) / 2.0 : (1.0 + easeOutBounce.ease(2.0 * t - 1.0)) / 2.0;

    public double ease(double var1);
}

