/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.forge.platform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.pandamods.pandalib.platform.services.RegistrationHelper;
import me.pandamods.pandalib.registry.DeferredObject;
import net.minecraft.client.Minecraft;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.registries.RegisterEvent;

public class RegistrationHelperImpl
implements RegistrationHelper {
    private final Map<ResourceKey<? extends Registry<?>>, PendingRegistries<?>> pendingRegistries = new HashMap();
    private final List<Registry<?>> pendingRegistryTypes = new ArrayList();
    private final List<PreparableReloadListener> serverDataReloadListeners = new ArrayList<PreparableReloadListener>();

    @Override
    public <T> void register(DeferredObject<? extends T> deferredObject, Supplier<? extends T> supplier) {
        PendingRegistries pending = this.pendingRegistries.computeIfAbsent(deferredObject.getRegistryKey(), k -> new PendingRegistries(deferredObject.getRegistryKey()));
        pending.add(deferredObject, supplier);
    }

    @Override
    public <T> void registerNewRegistry(Registry<T> registry) {
        this.pendingRegistryTypes.add(registry);
    }

    @Override
    public void registerReloadListener(PackType packType, PreparableReloadListener listener, ResourceLocation id, List<ResourceLocation> dependencies) {
        if (packType == PackType.SERVER_DATA) {
            this.serverDataReloadListeners.add(listener);
        } else {
            ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_(listener);
        }
    }

    public void registerEvent(RegisterEvent event) {
        this.pendingRegistries.values().forEach(pending -> pending.register(event));
    }

    public void registerNewRegistries() {
        Object rootRegistry;
        Registry registry = BuiltInRegistries.f_257047_;
        if (registry instanceof MappedRegistry) {
            rootRegistry = (MappedRegistry)registry;
            rootRegistry.unfreeze();
        }
        for (Registry registry2 : this.pendingRegistryTypes) {
            ((WritableRegistry)BuiltInRegistries.f_257047_).m_255290_(registry2.m_123023_(), (Object)registry2, registry2.m_203658_());
        }
        Registry registry3 = BuiltInRegistries.f_257047_;
        if (registry3 instanceof MappedRegistry) {
            rootRegistry = (MappedRegistry)registry3;
            rootRegistry.m_203521_();
        }
    }

    public void addReloadListenerEvent(AddReloadListenerEvent event) {
        this.serverDataReloadListeners.forEach(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
    }

    private static class PendingRegistries<T> {
        private final ResourceKey<? extends Registry<T>> registryKey;
        private final Map<DeferredObject<? extends T>, Supplier<? extends T>> entries = new HashMap<DeferredObject<? extends T>, Supplier<? extends T>>();

        public PendingRegistries(ResourceKey<? extends Registry<T>> registryKey) {
            this.registryKey = registryKey;
        }

        public void add(DeferredObject<? extends T> deferredObject, Supplier<? extends T> objectSupplier) {
            this.entries.put(deferredObject, objectSupplier);
        }

        public void register(RegisterEvent event) {
            this.entries.forEach((deferredObject, supplier) -> {
                event.register(this.registryKey, deferredObject.getId(), ((Supplier)supplier)::get);
                deferredObject.bind(false);
            });
        }
    }
}

