/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstoragecreateintegration.storage;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageData;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.ITintable;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.IMaterialHolder;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderBase;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderTierUpgradeHandler;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderToolHandler;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.PaintbrushItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageTierUpgradeItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.common.MountedLimitedBarrelContainerMenu;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.common.MountedStorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.init.ModContent;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.storage.MountedStorageHolder;

public class MountedSophisticatedStorage
extends MountedStorageBase {
    public static final Codec<MountedSophisticatedStorage> CODEC = ItemStack.f_41582_.xmap(MountedSophisticatedStorage::new, MountedStorageBase::getStorageStack);
    protected static final Multimap<Class<? extends Item>, String> NBT_TO_TRANSFER = LinkedListMultimap.create();
    private final MountedStorageHolder storageHolder = new MountedStorageHolder(() -> ((MountedSophisticatedStorage)this).getStorageStack(), this::setStorageStack);

    public static void registerNbtToTransfer(Class<? extends Item> itemClass, String tagName) {
        NBT_TO_TRANSFER.put(itemClass, (Object)tagName);
    }

    public MountedSophisticatedStorage(ItemStack storageStack) {
        super((MountedItemStorageType)ModContent.SOPHISTICATED_MOUNTED_STORAGE_TYPE.get(), storageStack);
    }

    public void setStorageStack(ItemStack stack) {
        super.setStorageStack(stack);
        if (this.storageHolder.getEntity() != null && !this.storageHolder.getEntity().m_9236_().m_5776_()) {
            this.storageHolder.setDirty();
        }
    }

    public static MountedSophisticatedStorage from(Level level, StorageBlockEntity storage) {
        ChestBlockEntity chestBlock;
        BlockState blockState;
        ChestBlockEntity chestBe;
        boolean rightChestPart = storage instanceof ChestBlockEntity && !(chestBe = (ChestBlockEntity)storage).isMainChest();
        storage.removeFromController();
        StorageWrapper storageWrapper = storage.getStorageWrapper();
        ItemStack storageItem = storageWrapper.getWrappedStorageStack();
        Item item = storageItem.m_41720_();
        if (item instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            if (storageWrapper.getMainColor() != -1) {
                tintableBlockItem.setMainColor(storageItem, storageWrapper.getMainColor());
            }
            if (storageWrapper.getAccentColor() != -1) {
                tintableBlockItem.setAccentColor(storageItem, storageWrapper.getAccentColor());
            }
        }
        ((ItemDisplaySettingsCategory)storage.getStorageWrapper().getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
        CompoundTag fullBeNbt = storage.m_187482_();
        CompoundTag contentsNbt = new CompoundTag();
        CompoundTag storageWrapperNbt = fullBeNbt.m_128469_("storageWrapper");
        contentsNbt.m_128365_("contents", (Tag)storageWrapperNbt.m_128469_("contents"));
        contentsNbt.m_128365_("settings", (Tag)storageWrapperNbt.m_128469_("settings"));
        MountedSophisticatedStorage.transferNbtIfPresent(storageWrapperNbt, "renderInfo", () -> ((ItemStack)storageItem).m_41784_());
        MountedSophisticatedStorage.transferNbtIfPresent(storageWrapperNbt, "sortBy", () -> ((ItemStack)storageItem).m_41784_());
        MountedSophisticatedStorage.transferNbtIfPresent(storageWrapperNbt, "numberOfInventorySlots", () -> ((ItemStack)storageItem).m_41784_());
        MountedSophisticatedStorage.transferNbtIfPresent(storageWrapperNbt, "numberOfUpgradeSlots", () -> ((ItemStack)storageItem).m_41784_());
        if (!rightChestPart) {
            UUID id = UUID.randomUUID();
            storageItem.m_41784_().m_128362_("uuid", id);
            MountedStorageData.get((UUID)id).setContents(contentsNbt);
            StorageBlockItem.setNumberOfInventorySlots((ItemStack)storageItem, (int)storageWrapper.getInventoryHandler().getSlots());
            StorageBlockItem.setNumberOfUpgradeSlots((ItemStack)storageItem, (int)storageWrapper.getUpgradeHandler().getSlots());
        }
        for (Map.Entry entry : NBT_TO_TRANSFER.entries()) {
            String tagName;
            if (!((Class)entry.getKey()).isInstance(storageItem.m_41720_()) || !fullBeNbt.m_128441_(tagName = (String)entry.getValue())) continue;
            storageItem.m_41784_().m_128365_(tagName, fullBeNbt.m_128423_(tagName));
        }
        if (storage instanceof ChestBlockEntity && (blockState = (chestBlock = (ChestBlockEntity)storage).m_58900_()).m_61143_((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
            ChestBlockItem.setDoubleChest((ItemStack)storageItem, (boolean)true);
            chestBlock.removeDoubleMainPos();
        }
        MountedSophisticatedStorage mountedStorage = new MountedSophisticatedStorage(storageItem);
        if (!level.m_5776_()) {
            mountedStorage.getStorageHolder().setDirty();
        }
        return mountedStorage;
    }

    private static void transferNbtIfPresent(@Nullable CompoundTag sourceNbt, String tagName, Supplier<CompoundTag> getTargetTag) {
        if (sourceNbt != null && sourceNbt.m_128441_(tagName)) {
            getTargetTag.get().m_128365_(tagName, sourceNbt.m_128423_(tagName));
        }
    }

    protected void afterInitialSync() {
        this.storageHolder.onStackChanged();
        this.storageHolder.updateClientBlockRender();
    }

    public void updateWithSyncedStorageStack(ItemStack storageStack, boolean refreshBlockRender) {
        Entity entity;
        this.storageHolder.setStorageItem(storageStack);
        this.storageHolder.refreshRenderBlockEntity();
        if (refreshBlockRender && (entity = this.storageHolder.getEntity()) instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
            contraptionEntity.getContraption().deferInvalidate = true;
        }
    }

    public IStorageWrapper getStorageWrapper() {
        return this.storageHolder.getStorageWrapper();
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        NBTHelper.getUniqueId((ItemStack)this.getStorageStack(), (String)"uuid").ifPresent(storageUuid -> {
            if (!(be instanceof StorageBlockEntity)) return;
            StorageBlockEntity storageBe = (StorageBlockEntity)be;
            MountedStorageData mountedStorageData = MountedStorageData.get((UUID)storageUuid);
            CompoundTag fullBeNbt = new CompoundTag();
            CompoundTag contentNbt = mountedStorageData.getContents();
            MountedSophisticatedStorage.transferNbtIfPresent(this.getStorageStack().m_41783_(), "renderInfo", () -> contentNbt);
            MountedSophisticatedStorage.transferNbtIfPresent(this.getStorageStack().m_41783_(), "sortBy", () -> contentNbt);
            MountedSophisticatedStorage.transferNbtIfPresent(this.getStorageStack().m_41783_(), "numberOfInventorySlots", () -> contentNbt);
            MountedSophisticatedStorage.transferNbtIfPresent(this.getStorageStack().m_41783_(), "numberOfUpgradeSlots", () -> contentNbt);
            fullBeNbt.m_128365_("storageWrapper", (Tag)contentNbt);
            for (Map.Entry entry : NBT_TO_TRANSFER.entries()) {
                if (!((Class)entry.getKey()).isInstance(this.getStorageStack().m_41720_())) continue;
                MountedSophisticatedStorage.transferNbtIfPresent(this.getStorageStack().m_41783_(), (String)entry.getValue(), () -> fullBeNbt);
            }
            if (state.m_60734_() instanceof ChestBlock && state.m_61143_((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
                storageBe.setBeingUpgraded(true);
            }
            storageBe.m_142466_(fullBeNbt);
            Item patt9943$temp = this.getStorageStack().m_41720_();
            if (patt9943$temp instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)patt9943$temp;
                storageBe.getStorageWrapper().setColors(tintableBlockItem.getMainColor(this.getStorageStack()).orElse(-1).intValue(), tintableBlockItem.getAccentColor(this.getStorageStack()).orElse(-1).intValue());
            }
            mountedStorageData.removeStorageContents();
            if (storageBe instanceof ChestBlockEntity) {
                ChestBlockEntity chestBe = (ChestBlockEntity)storageBe;
                if (state.m_61143_((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
                    BlockState inWorldState = level.m_8055_(pos);
                    ChestType chestType = (ChestType)state.m_61143_((Property)ChestBlock.TYPE);
                    level.m_7731_(pos, (BlockState)inWorldState.m_61124_((Property)ChestBlock.TYPE, (Comparable)chestType), 3);
                    Direction facing = (Direction)inWorldState.m_61143_((Property)ChestBlock.FACING);
                    BlockPos connectedPos = pos.m_121945_(chestType == ChestType.LEFT ? facing.m_122427_() : facing.m_122428_());
                    WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)connectedPos, ChestBlockEntity.class).ifPresent(otherHalfBe -> {
                        ChestBlockEntity mainBe = chestType == ChestType.LEFT ? otherHalfBe : chestBe;
                        ChestBlockEntity attachedBe = chestType == ChestType.LEFT ? chestBe : otherHalfBe;
                        mainBe.setBeingUpgraded(false);
                        attachedBe.setBeingUpgraded(false);
                        attachedBe.setMainPos(mainBe.m_58899_());
                        mainBe.getStorageWrapper().onInit();
                        mainBe.tryToAddToController();
                    });
                    return;
                }
            }
            storageBe.getStorageWrapper().onInit();
            storageBe.tryToAddToController();
        });
    }

    public MountedStorageContainerMenuBase createMenu(int id, Player pl, int contraptionEntityId, BlockPos localPos) {
        if (MovingStorageWrapper.isLimitedBarrel((ItemStack)this.getStorageStack())) {
            return new MountedLimitedBarrelContainerMenu(id, pl, contraptionEntityId, localPos);
        }
        return new MountedStorageContainerMenu(id, pl, contraptionEntityId, localPos);
    }

    public boolean handleInteraction(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        if (WoodStorageBlockItem.isPacked((ItemStack)this.getStorageStack())) {
            return false;
        }
        ServerLevel level = player.m_284548_();
        BlockPos localPos = info.f_74675_();
        if (info.f_74676_().m_60734_() instanceof ChestBlock && info.f_74676_().m_61143_((Property)ChestBlock.TYPE) == ChestType.LEFT) {
            localPos = info.f_74675_().m_121945_(ChestBlock.getConnectedDirection((BlockState)info.f_74676_()));
        }
        int contraptionEntityId = contraption.entity.m_19879_();
        ItemStack itemInHand = player.m_21205_();
        Item item = itemInHand.m_41720_();
        if (item instanceof StorageTierUpgradeItem) {
            StorageTierUpgradeItem tierUpgradeItem = (StorageTierUpgradeItem)item;
            InteractionResult result = this.tryStorageTierUpgrade(player, itemInHand, tierUpgradeItem);
            if (result != InteractionResult.PASS) {
                return result == InteractionResult.SUCCESS;
            }
        } else {
            if (itemInHand.m_41720_() instanceof StorageToolItem && this.tryToolInteraction(itemInHand)) {
                return true;
            }
            if (itemInHand.m_41720_() instanceof UpgradeItemBase && this.tryAddStorageUpgrade((Player)player, itemInHand)) {
                return true;
            }
            if (itemInHand.m_41720_() == ModItems.PAINTBRUSH.get() && this.tryPaintStorage((Player)player, itemInHand)) {
                return true;
            }
        }
        Vec3 localPosVec = Vec3.m_82512_((Vec3i)localPos);
        this.openMenu(player, contraptionEntityId, localPos);
        Vec3 globalPos = contraption.entity.toGlobalVector(localPosVec, 0.0f);
        this.onOpen(level, globalPos);
        return true;
    }

    private boolean tryToolInteraction(ItemStack itemInHand) {
        boolean result;
        boolean bl = result = StorageHolderToolHandler.tryStorageToolInteract((ItemStack)itemInHand, (StorageHolderBase)this.getStorageHolder()) == InteractionResult.SUCCESS;
        if (result && StorageToolItem.getMode((ItemStack)itemInHand) == StorageToolItem.Mode.LOCK) {
            this.storageHolder.updateClientBlockRender();
            this.storageHolder.sendStorageUpdatePayload();
        }
        return result;
    }

    private boolean tryAddStorageUpgrade(Player player, ItemStack itemInHand) {
        return StorageBlockBase.tryAddSingleUpgrade((Player)player, (InteractionHand)InteractionHand.MAIN_HAND, (ItemStack)itemInHand, (IStorageWrapper)this.getStorageWrapper());
    }

    private boolean tryPaintStorage(Player player, ItemStack paintbrush) {
        Item item = this.getStorageStack().m_41720_();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState state = blockItem.m_40614_().m_49966_();
        SoundEvent placeSound = state.m_60827_().m_56777_();
        boolean painted = PaintbrushItem.paint((Player)player, (ItemStack)paintbrush, (IMaterialHolder)this.getStorageHolder(), (ITintable)this.getStorageWrapper(), (Vec3)this.getStorageHolder().getPosition(), (Direction)Direction.UP, (SoundEvent)placeSound);
        if (painted) {
            this.storageHolder.updateClientBlockRender();
            this.storageHolder.sendStorageUpdatePayload();
        }
        return painted;
    }

    private InteractionResult tryStorageTierUpgrade(ServerPlayer player, ItemStack itemInHand, StorageTierUpgradeItem tierUpgradeItem) {
        InteractionResult result = StorageHolderTierUpgradeHandler.upgrade((Player)player, (StorageHolderBase)this.getStorageHolder(), (ItemStack)itemInHand, (StorageTierUpgradeItem)tierUpgradeItem);
        if (result == InteractionResult.SUCCESS) {
            if (this.getStorageStack().m_41720_() instanceof ChestBlockItem && ChestBlockItem.isDoubleChest((ItemStack)this.getStorageStack())) {
                StorageHolderBase storageHolderBase = this.storageHolder.getMainStorageHolder();
                if (storageHolderBase instanceof MountedStorageHolder) {
                    MountedStorageHolder mainStorageHolder = (MountedStorageHolder)storageHolderBase;
                    mainStorageHolder.updateState();
                }
                this.storageHolder.getAuxiliaryStorageHolder().filter(MountedStorageHolder.class::isInstance).map(MountedStorageHolder.class::cast).ifPresent(MountedStorageHolder::updateState);
            } else {
                this.storageHolder.updateState();
            }
            return InteractionResult.SUCCESS;
        }
        return result;
    }

    public MountedStorageHolder getStorageHolder() {
        return this.storageHolder;
    }

    void initEntityLevelAndPositions(MovementContext context) {
        this.getStorageHolder().initEntityLevelAndPositions(context);
    }

    public void tick(Entity entity) {
        this.getStorageHolder().tick(entity);
    }

    public void clearNbt() {
        this.getStorageHolder().clearNbt();
    }

    protected IItemHandlerModifiable getExternalItemHandler() {
        return this.getStorageHolder().getMainStorageWrapper().getInventoryForInputOutput();
    }

    public void openMenu(ServerPlayer player, int contraptionEntityId, BlockPos localPos) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> this.createMenu(w, pl, contraptionEntityId, localPos), this.getStorageStack().m_41786_()), buffer -> {
            buffer.writeInt(contraptionEntityId);
            buffer.m_130064_(localPos);
        });
    }

    public void setShouldBeOpen(boolean b) {
        this.storageHolder.setShouldBeOpen(b);
    }

    static {
        MountedSophisticatedStorage.registerNbtToTransfer(StorageBlockItem.class, "displayName");
        MountedSophisticatedStorage.registerNbtToTransfer(StorageBlockItem.class, "locked");
        MountedSophisticatedStorage.registerNbtToTransfer(StorageBlockItem.class, "showLock");
        MountedSophisticatedStorage.registerNbtToTransfer(StorageBlockItem.class, "showTier");
        MountedSophisticatedStorage.registerNbtToTransfer(StorageBlockItem.class, "showUpgrades");
        MountedSophisticatedStorage.registerNbtToTransfer(BarrelBlockItem.class, "showCounts");
        MountedSophisticatedStorage.registerNbtToTransfer(BarrelBlockItem.class, "showFillLevels");
        MountedSophisticatedStorage.registerNbtToTransfer(BarrelBlockItem.class, "slotColors");
        MountedSophisticatedStorage.registerNbtToTransfer(WoodStorageBlockItem.class, "woodType");
        MountedSophisticatedStorage.registerNbtToTransfer(WoodStorageBlockItem.class, "packed");
        MountedSophisticatedStorage.registerNbtToTransfer(BarrelBlockItem.class, "materials");
    }
}

