/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.multipart.api.part.CapabilityProviderPart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.capability.ChainedProvider;
import java.util.Collection;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class TCapabilityTile
extends TileMultipart {
    private static final Direction[] N_SIDES = (Direction[])Util.m_137469_((Object)new Direction[7], arr -> {
        arr[0] = null;
        System.arraycopy(Direction.values(), 0, arr, 1, 6);
    });
    private ChainedProvider[] providers = new ChainedProvider[7];

    public TCapabilityTile(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        ChainedProvider p = this.providers[TCapabilityTile.ordinal(side)];
        if (p != null) {
            return p.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void copyFrom(TileMultipart that) {
        super.copyFrom(that);
        if (that instanceof TCapabilityTile) {
            TCapabilityTile thatCapTile = (TCapabilityTile)that;
            this.providers = thatCapTile.providers;
        }
    }

    @Override
    public void bindPart(MultiPart _part) {
        super.bindPart(_part);
        if (!(_part instanceof CapabilityProviderPart)) {
            return;
        }
        CapabilityProviderPart part = (CapabilityProviderPart)_part;
        for (Direction side : N_SIDES) {
            if (!part.hasCapabilities(side)) continue;
            int s = TCapabilityTile.ordinal(side);
            if (this.providers[s] == null) {
                this.providers[s] = new ChainedProvider(part);
                continue;
            }
            if (side != null && this.getSlottedPart(s) == part) {
                this.providers[s].invalidateAll();
                this.providers[s] = new ChainedProvider(part, this.providers[s]);
                continue;
            }
            this.providers[s].append(part);
        }
    }

    @Override
    public void partRemoved(MultiPart _part, int p) {
        super.partRemoved(_part, p);
        if (!(_part instanceof CapabilityProviderPart)) {
            return;
        }
        CapabilityProviderPart part = (CapabilityProviderPart)_part;
        for (Direction side : N_SIDES) {
            int s = TCapabilityTile.ordinal(side);
            if (this.providers[s] == null) continue;
            this.providers[s] = this.providers[s].remove(part);
        }
    }

    @Override
    public void clearParts() {
        super.clearParts();
        this.invalidateAll();
        for (Direction side : N_SIDES) {
            int s = TCapabilityTile.ordinal(side);
            this.providers[s] = null;
        }
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        this.invalidateAll();
    }

    @Override
    public void internalPartChange(@Nullable MultiPart part) {
        super.internalPartChange(part);
        if (!(part instanceof CapabilityProviderPart)) {
            return;
        }
        this.invalidateFor((CapabilityProviderPart)part);
    }

    @Override
    public void multiPartChange(Collection<MultiPart> parts) {
        super.multiPartChange(parts);
        for (MultiPart part : parts) {
            if (!(part instanceof CapabilityProviderPart)) continue;
            this.invalidateFor((CapabilityProviderPart)part);
        }
    }

    private void invalidateFor(CapabilityProviderPart part) {
        for (Direction side : N_SIDES) {
            int s = TCapabilityTile.ordinal(side);
            if (this.providers[s] == null) continue;
            this.providers[s].invalidateFor(part);
        }
    }

    private void invalidateAll() {
        for (Direction side : N_SIDES) {
            int s = TCapabilityTile.ordinal(side);
            if (this.providers[s] == null) continue;
            this.providers[s].invalidateAll();
        }
    }

    private static int ordinal(@Nullable Direction side) {
        return side == null ? 6 : side.ordinal();
    }
}

