/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.util;

import codechicken.lib.vec.Cuboid6;
import codechicken.microblock.part.IMicroShrinkRender;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.util.PartMap;

public class MicroOcclusionHelper {
    public static void shrink(Cuboid6 renderBounds, Cuboid6 b, int side) {
        switch (side) {
            case 0: {
                if (!(renderBounds.min.y < b.max.y)) break;
                renderBounds.min.y = b.max.y;
                break;
            }
            case 1: {
                if (!(renderBounds.max.y > b.min.y)) break;
                renderBounds.max.y = b.min.y;
                break;
            }
            case 2: {
                if (!(renderBounds.min.z < b.max.z)) break;
                renderBounds.min.z = b.max.z;
                break;
            }
            case 3: {
                if (!(renderBounds.max.z > b.min.z)) break;
                renderBounds.max.z = b.min.z;
                break;
            }
            case 4: {
                if (!(renderBounds.min.x < b.max.x)) break;
                renderBounds.min.x = b.max.x;
                break;
            }
            case 5: {
                if (!(renderBounds.max.x > b.min.x)) break;
                renderBounds.max.x = b.min.x;
            }
        }
    }

    public static int shrinkFrom(IMicroShrinkRender p, IMicroShrinkRender other, Cuboid6 renderBounds) {
        if (MicroOcclusionHelper.shrinkTest(p, other)) {
            MicroOcclusionHelper.shrink(renderBounds, other.getBounds(), MicroOcclusionHelper.shrinkSide(p.getSlot(), other.getSlot()));
        } else if (other.getSlot() < 6 && !other.isTransparent()) {
            boolean flag = switch (other.getSlot()) {
                case 0 -> {
                    if (renderBounds.min.y <= 0.0) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (renderBounds.max.y >= 1.0) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (renderBounds.min.z <= 0.0) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (renderBounds.max.z >= 1.0) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> {
                    if (renderBounds.min.x <= 0.0) {
                        yield true;
                    }
                    yield false;
                }
                case 5 -> {
                    if (renderBounds.max.x >= 1.0) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new IllegalArgumentException("Switch Falloff");
            };
            if (flag) {
                return 1 << other.getSlot();
            }
        }
        return 0;
    }

    public static int shrink(IMicroShrinkRender p, Cuboid6 renderBounds, int m) {
        int renderMask = 0;
        TileMultipart tile = p.tile();
        for (int i = 0; i < m; ++i) {
            MultiPart multiPart;
            if (i == p.getSlot() || !((multiPart = tile.getSlottedPart(i)) instanceof IMicroShrinkRender)) continue;
            IMicroShrinkRender other = (IMicroShrinkRender)multiPart;
            renderMask |= MicroOcclusionHelper.shrinkFrom(p, other, renderBounds);
        }
        return renderMask;
    }

    public static int shrinkSide(int s1, int s2) {
        if (s2 < 6) {
            return s2;
        }
        if (s1 < 15) {
            int c1 = s1 - 7;
            int c2 = s2 - 7;
            return switch (c1 ^ c2) {
                case 1 -> c2 & 1;
                case 2 -> 2 | (c2 & 2) >> 1;
                case 4 -> 4 | (c2 & 4) >> 2;
                default -> -1;
            };
        }
        if (s2 < 15) {
            int e1 = s1 - 15;
            int c2 = s2 - 7;
            int ebits = PartMap.unpackEdgeBits(e1);
            if ((c2 & PartMap.edgeAxisMask(e1)) != ebits) {
                return -1;
            }
            return (e1 & 0xC) >> 1 | (c2 & ~ebits) >> (e1 >> 2);
        }
        int e1 = s1 - 15;
        int e2 = s2 - 15;
        int e1bits = PartMap.unpackEdgeBits(e1);
        int e2bits = PartMap.unpackEdgeBits(e2);
        if ((e1 & 0xC) == (e2 & 0xC)) {
            return switch (e1bits ^ e2bits) {
                case 1 -> {
                    if ((e2bits & 1) == 0) {
                        yield 0;
                    }
                    yield 1;
                }
                case 2 -> {
                    if ((e2bits & 2) == 0) {
                        yield 2;
                    }
                    yield 3;
                }
                case 4 -> {
                    if ((e2bits & 4) == 0) {
                        yield 4;
                    }
                    yield 5;
                }
                default -> -1;
            };
        }
        int mask = PartMap.edgeAxisMask(e1) & PartMap.edgeAxisMask(e2);
        if ((e1bits & mask) != (e2bits & mask)) {
            return -1;
        }
        return switch (e1 >> 2) {
            case 0 -> {
                if ((e2bits & 1) == 0) {
                    yield 0;
                }
                yield 1;
            }
            case 1 -> {
                if ((e2bits & 2) == 0) {
                    yield 2;
                }
                yield 3;
            }
            case 2 -> {
                if ((e2bits & 4) == 0) {
                    yield 4;
                }
                yield 5;
            }
            default -> throw new IllegalArgumentException("Switch Falloff");
        };
    }

    public static int recalcBounds(IMicroShrinkRender p, Cuboid6 renderBounds) {
        if (p.getSlot() < 6) {
            return MicroOcclusionHelper.shrink(p, renderBounds, 6);
        }
        if (p.getSlot() < 15) {
            return MicroOcclusionHelper.shrink(p, renderBounds, 15);
        }
        return MicroOcclusionHelper.shrink(p, renderBounds, 27);
    }

    public static int shapePriority(int slot) {
        if (slot < 6) {
            return 2;
        }
        if (slot < 15) {
            return 1;
        }
        return 0;
    }

    public static boolean shrinkTest(IMicroShrinkRender a, IMicroShrinkRender b) {
        int shape2;
        if (a.getPriorityClass() != b.getPriorityClass()) {
            return a.getPriorityClass() < b.getPriorityClass();
        }
        int shape1 = MicroOcclusionHelper.shapePriority(a.getSlot());
        if (shape1 != (shape2 = MicroOcclusionHelper.shapePriority(b.getSlot()))) {
            return shape1 < shape2;
        }
        if (a.getSlot() < 6) {
            if (a.isTransparent() != b.isTransparent()) {
                return a.isTransparent();
            }
            if (a.getSize() != b.getSize()) {
                return a.getSize() < b.getSize();
            }
        } else {
            if (a.getSize() != b.getSize()) {
                return a.getSize() < b.getSize();
            }
            if (a.isTransparent() != b.isTransparent()) {
                return a.isTransparent();
            }
        }
        return a.getSlot() < b.getSlot();
    }
}

