/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder.data;

import com.teamabnormals.blueprint.common.remolder.data.DataAccessor;
import com.teamabnormals.blueprint.common.remolder.data.DataType;
import com.teamabnormals.blueprint.common.remolder.data.Molding;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class DataExpressionParser {
    private static final HashMap<String, FunctionParser> FUNCTIONS = new HashMap();

    public static synchronized void registerFunction(String name, FunctionParser parser) {
        FUNCTIONS.put(name, parser);
    }

    public static void registerSingleParameterInstanceFunction(String name, FunctionParser parser) {
        DataExpressionParser.registerFunction(name, (instance, tokens, index) -> {
            if (instance == null) {
                throw new ParseException("Must have instance to invoke " + name + "()", tokens[index.get() - 1].startIndex() + 1);
            }
            DataExpressionParser.checkTokenExists(TokenType.RIGHT_PARENTHESIS, index, tokens);
            return parser.parse(instance, tokens, index);
        });
    }

    public static void registerSingleParameterFunction(String name, Function<DataAccessor, DataAccessor> function) {
        DataExpressionParser.registerFunction(name, (instance, tokens, index) -> {
            int i = index.get();
            if (instance != null) {
                throw new ParseException("Cannot invoke " + name + "() on an instance", tokens[i - 1].startIndex() + 1);
            }
            int tokensLength = tokens.length;
            if (i == tokensLength - 1 && tokens[i].type() == TokenType.RIGHT_PARENTHESIS || i + 1 > tokensLength) {
                throw new ParseException("Missing parameter", tokens[i - 1].startIndex() + 1);
            }
            return (DataAccessor)function.apply(DataExpressionParser.parseTokens(tokens, index, TokenType.RIGHT_PARENTHESIS));
        });
    }

    public static Token[] tokenize(String expression) throws ParseException {
        int initialLength = expression.length();
        if (initialLength == 0) {
            return new Token[0];
        }
        TokenType[] tokenTypes = TokenType.values();
        int tokenTypesCount = tokenTypes.length;
        ArrayList<Token> tokens = new ArrayList<Token>();
        int i = 0;
        while (i < tokenTypesCount) {
            TokenType type = tokenTypes[i];
            Matcher matcher = type.pattern.matcher(expression);
            if (matcher.find() && matcher.start() == 0) {
                i = 0;
                int end = matcher.end();
                String tokenContents = expression.substring(0, end);
                tokens.add(new Token(type, tokenContents, initialLength - expression.length()));
                if (!(expression = expression.substring(end)).isEmpty()) continue;
                return (Token[])tokens.toArray(Token[]::new);
            }
            ++i;
        }
        throw new ParseException("Unknown token(s) for remaining characters: " + expression, initialLength - expression.length());
    }

    public static DataAccessor parse(String expression) throws ParseException {
        AtomicInteger index = new AtomicInteger();
        Token[] tokens = DataExpressionParser.tokenize(expression);
        try {
            return DataExpressionParser.parseTokens(tokens, index, null);
        }
        catch (ParseException exception) {
            throw exception;
        }
        catch (Exception exception) {
            Token recentToken = tokens[index.get() - 1];
            throw new ParseException("Syntax unrelated exception: " + exception, recentToken.startIndex() + recentToken.contents().length());
        }
    }

    public static DataAccessor parseTokens(Token[] tokens, AtomicInteger index, @Nullable TokenType closerType) throws ParseException {
        int localStartingIndex;
        int i;
        DataAccessor dataAccessor = DataAccessor.ROOT;
        int tokensLength = tokens.length;
        block18: for (i = localStartingIndex = index.get(); i < tokensLength; ++i) {
            Token token = tokens[i];
            switch (token.type()) {
                case NUMBER: {
                    String contents = token.contents();
                    if (contents.contains(".")) {
                        dataAccessor = DataAccessor.doubleValue(Double.parseDouble(contents));
                        continue block18;
                    }
                    long longValue = Long.parseLong(contents);
                    dataAccessor = longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE ? DataAccessor.longValue(longValue) : DataAccessor.intValue((int)longValue);
                    continue block18;
                }
                case STRING: {
                    String string = token.contents();
                    string = token.contents().substring(1, string.length() - 1);
                    dataAccessor = DataAccessor.string(DataExpressionParser.cleanEscapedCharacters(string));
                    continue block18;
                }
                case NAME: {
                    int nextIndex;
                    String tokenContents = token.contents();
                    String name = DataExpressionParser.cleanEscapedCharacters(tokenContents);
                    if (i == localStartingIndex) {
                        switch (name) {
                            case "@": {
                                dataAccessor = DataAccessor.VARIABLES;
                                continue block18;
                            }
                            case "meta": {
                                dataAccessor = DataAccessor.META;
                                continue block18;
                            }
                            case "this": {
                                continue block18;
                            }
                        }
                    }
                    if ((nextIndex = i + 1) < tokensLength && tokens[nextIndex].type() == TokenType.LEFT_PARENTHESIS) {
                        FunctionParser functionParser = FUNCTIONS.get(name);
                        if (functionParser == null) {
                            throw new ParseException("Unknown function: " + name, token.startIndex() + tokenContents.length());
                        }
                        DataAccessor instance = null;
                        int previousIndex = i - 1;
                        if (previousIndex >= 1 && tokens[previousIndex].type() == TokenType.DOT) {
                            instance = dataAccessor;
                        }
                        index.set(nextIndex + 1);
                        dataAccessor = functionParser.parse(instance, tokens, index);
                        DataExpressionParser.checkTokenExists(TokenType.RIGHT_PARENTHESIS, index, tokens);
                        i = index.get();
                        continue block18;
                    }
                    dataAccessor = DataAccessor.objectElement(dataAccessor, DataAccessor.string(name));
                    continue block18;
                }
                case LEFT_BRACKET: {
                    int indexAfterLeftBracket = i + 1;
                    if (indexAfterLeftBracket < tokensLength && tokens[indexAfterLeftBracket].type() == TokenType.RIGHT_BRACKET) {
                        dataAccessor = DataAccessor.lastArrayElement(dataAccessor);
                        i = indexAfterLeftBracket;
                        continue block18;
                    }
                    index.set(indexAfterLeftBracket);
                    DataAccessor indexAccessor = DataExpressionParser.parseTokens(tokens, index, TokenType.RIGHT_BRACKET);
                    DataExpressionParser.checkTokenExists(TokenType.RIGHT_BRACKET, index, tokens);
                    i = index.get();
                    dataAccessor = DataAccessor.arrayElement(dataAccessor, indexAccessor);
                    continue block18;
                }
                case LEFT_PARENTHESIS: {
                    int indexAfterLeftParenthesis = i + 1;
                    if (indexAfterLeftParenthesis >= tokensLength) {
                        throw new ParseException("Missing contents to right of left parenthesis", token.startIndex() + 1);
                    }
                    if (tokens[indexAfterLeftParenthesis].type() == TokenType.RIGHT_PARENTHESIS) {
                        throw new ParseException("Missing contents inside parentheses", tokens[i].startIndex() + 1);
                    }
                    index.set(indexAfterLeftParenthesis);
                    dataAccessor = DataExpressionParser.parseTokens(tokens, index, TokenType.RIGHT_PARENTHESIS);
                    i = index.get();
                    DataExpressionParser.checkTokenExists(TokenType.RIGHT_PARENTHESIS, index, tokens);
                    continue block18;
                }
                case DOT: {
                    if (i <= 0 || dataAccessor.getDataType().elementType() == DataType.ElementType.NONE) {
                        throw new ParseException("Cannot perform instance operation on non-elemental type", token.startIndex() + 1);
                    }
                    int nextIndex = i + 1;
                    if (nextIndex < tokensLength && tokens[nextIndex].type() == TokenType.NAME) continue block18;
                    throw new ParseException("Expected to find name after dot", token.startIndex() + 1);
                }
                default: {
                    TokenType type = token.type();
                    if (type != closerType) {
                        throw new ParseException("Found dangling token of type " + type, token.startIndex() + 1);
                    }
                    index.set(i);
                    return dataAccessor;
                }
            }
        }
        index.set(i);
        return dataAccessor;
    }

    private static void checkTokenExists(TokenType type, AtomicInteger index, Token[] tokens) throws ParseException {
        int tokensLength;
        int i = index.get();
        if (i >= (tokensLength = tokens.length) || tokens[i].type() != type) {
            Token tokenBefore = tokens[Math.min(i - 1, tokensLength - 1)];
            throw new ParseException("Expected token: " + type.name(), tokenBefore.startIndex() + tokenBefore.contents().length());
        }
    }

    private static String cleanEscapedCharacters(String string) {
        StringBuilder result = new StringBuilder();
        boolean isEscaping = false;
        for (int i = 0; i < string.length(); ++i) {
            char character = string.charAt(i);
            if (isEscaping) {
                result.append(character);
                isEscaping = false;
                continue;
            }
            if (character == '\\') {
                isEscaping = true;
                continue;
            }
            result.append(character);
        }
        if (isEscaping) {
            throw new IllegalArgumentException("Unmatched backslash at end of input");
        }
        return result.toString();
    }

    public static String formatParseException(String parsedString, ParseException parseException) {
        StringBuilder builder = new StringBuilder();
        builder.append(parseException);
        builder.append(":\n");
        int cursor = Math.min(parsedString.length(), parseException.getErrorOffset());
        if (cursor > 10) {
            builder.append("...");
        }
        builder.append(parsedString, Math.max(0, cursor - 10), cursor);
        builder.append("<--[HERE]");
        return builder.toString();
    }

    static {
        DataExpressionParser.registerFunction("get", (instance, tokens, index) -> {
            int tokensLength;
            if (instance == null) {
                throw new ParseException("Must have instance to get field value from", tokens[index.get() - 1].startIndex() + 1);
            }
            int i = index.get();
            if (i == (tokensLength = tokens.length) - 1 && tokens[i].type() == TokenType.RIGHT_PARENTHESIS || i + 1 > tokensLength) {
                throw new ParseException("Missing parameter", tokens[i - 1].startIndex() + 1);
            }
            return DataAccessor.objectElement(instance, DataExpressionParser.parseTokens(tokens, index, TokenType.RIGHT_PARENTHESIS));
        });
        DataExpressionParser.registerSingleParameterInstanceFunction("size", (instance, tokens, index) -> DataAccessor.map(instance, DataType.INT, Molding::size));
        DataExpressionParser.registerSingleParameterInstanceFunction("length", (instance, tokens, index) -> {
            BiConsumer<Molding<?>, MethodVisitor> visitor;
            DataType dataType = instance.getDataType();
            if (dataType.elementType() != DataType.ElementType.NONE) {
                visitor = Molding::arrayLength;
            } else {
                Type type = dataType.getTrueType(null);
                if (!type.equals((Object)DataType.STRING_TYPE)) {
                    throw new ParseException(".length() not supported for type: " + type, tokens[index.get() - 1].startIndex() + 1);
                }
                visitor = (molding, method) -> DataAccessor.stringLength(method);
            }
            return DataAccessor.map(instance, DataType.INT, visitor);
        });
        DataExpressionParser.registerSingleParameterInstanceFunction("mapSize", (instance, tokens, index) -> DataAccessor.map(instance, DataType.INT, Molding::mapSize));
        DataExpressionParser.registerSingleParameterInstanceFunction("clone", (instance, tokens, index) -> DataAccessor.map(instance, instance.getDataType(), Molding::clone));
        DataExpressionParser.registerSingleParameterFunction("data", DataAccessor::data);
        DataExpressionParser.registerSingleParameterFunction("str", DataAccessor::str);
        DataExpressionParser.registerSingleParameterFunction("boolean", DataAccessor::convertToBoolean);
        DataExpressionParser.registerSingleParameterFunction("Boolean", DataAccessor::convertToBooleanWrapper);
        DataExpressionParser.registerSingleParameterFunction("char", DataAccessor::convertToChar);
        DataExpressionParser.registerSingleParameterFunction("Character", DataAccessor::convertToCharWrapper);
        DataExpressionParser.registerSingleParameterFunction("byte", DataAccessor::convertToByte);
        DataExpressionParser.registerSingleParameterFunction("Byte", DataAccessor::convertToByteWrapper);
        DataExpressionParser.registerSingleParameterFunction("short", DataAccessor::convertToShort);
        DataExpressionParser.registerSingleParameterFunction("Short", DataAccessor::convertToShortWrapper);
        DataExpressionParser.registerSingleParameterFunction("int", DataAccessor::convertToInt);
        DataExpressionParser.registerSingleParameterFunction("Integer", DataAccessor::convertToIntWrapper);
        DataExpressionParser.registerSingleParameterFunction("long", DataAccessor::convertToLong);
        DataExpressionParser.registerSingleParameterFunction("Long", DataAccessor::convertToLongWrapper);
        DataExpressionParser.registerSingleParameterFunction("float", DataAccessor::convertToFloat);
        DataExpressionParser.registerSingleParameterFunction("Float", DataAccessor::convertToFloatWrapper);
        DataExpressionParser.registerSingleParameterFunction("double", DataAccessor::convertToDouble);
        DataExpressionParser.registerSingleParameterFunction("Double", DataAccessor::convertToDoubleWrapper);
    }

    public static interface FunctionParser {
        public DataAccessor parse(@Nullable DataAccessor var1, Token[] var2, AtomicInteger var3) throws ParseException;
    }

    public record Token(TokenType type, String contents, int startIndex) {
    }

    public static enum TokenType {
        NAME("([a-zA-Z_@][a-zA-Z_0-9]*|\\\\.)+"),
        NUMBER("[+-]?\\d+(\\.\\d+)?"),
        STRING("\"([^\"\\\\]|\\\\.)*\""),
        LEFT_BRACKET("(?<!\\\\)\\["),
        RIGHT_BRACKET("(?<!\\\\)\\]"),
        LEFT_PARENTHESIS("(?<!\\\\)\\("),
        RIGHT_PARENTHESIS("(?<!\\\\)\\)"),
        DOT("(?<!\\\\)\\.");

        private final Pattern pattern;

        private TokenType(String regex) {
            this.pattern = Pattern.compile(regex);
        }
    }
}

