/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.teamabnormals.blueprint.common.remolder.Remolder;
import com.teamabnormals.blueprint.common.remolder.RemolderTypes;
import com.teamabnormals.blueprint.common.remolder.data.MoldingTypes;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public record RemolderEntry(ConditionedResourceSelector pathSelector, @Nullable Set<String> packs, MoldingTypes.MoldingType<?> molding, Remolder remolder) {
    public static final RemolderEntry NOOP = new RemolderEntry(ConditionedResourceSelector.EMPTY, null, MoldingTypes.JSON, RemolderTypes.noop());
    public static final Codec<RemolderEntry> CODEC = new Codec<RemolderEntry>(){
        private final Codec<Set<String>> packsCodec = Codec.STRING.listOf().xmap(strings -> new HashSet(strings), ArrayList::new).optionalFieldOf("packs", null).codec();
        private final Codec<MoldingTypes.MoldingType<?>> moldingCodec = MoldingTypes.TYPE_CODEC.fieldOf("molding").codec();
        private final Codec<Remolder> remolderCodec = Remolder.CODEC.fieldOf("remolder").codec();

        public <T> DataResult<Pair<RemolderEntry, T>> decode(DynamicOps<T> dynamicOps, T prefix) {
            return ConditionedResourceSelector.CODEC.decode(dynamicOps, prefix).flatMap(pair -> {
                ConditionedResourceSelector pathSelector = (ConditionedResourceSelector)pair.getFirst();
                if (pathSelector == ConditionedResourceSelector.EMPTY) {
                    return DataResult.success((Object)Pair.of((Object)NOOP, (Object)prefix));
                }
                DataResult packsDecodeDataResult = this.packsCodec.decode(dynamicOps, prefix);
                Optional packsDecodeError = packsDecodeDataResult.error();
                if (packsDecodeError.isPresent()) {
                    String message = ((DataResult.PartialResult)packsDecodeError.get()).message();
                    return DataResult.error(() -> message);
                }
                DataResult moldingDecodeDataResult = this.moldingCodec.decode(dynamicOps, prefix);
                Optional moldingDecodeError = moldingDecodeDataResult.error();
                if (moldingDecodeError.isPresent()) {
                    String message = ((DataResult.PartialResult)moldingDecodeError.get()).message();
                    return DataResult.error(() -> message);
                }
                DataResult remolderDecodeDataResult = this.remolderCodec.decode(dynamicOps, prefix);
                Optional remolderDecodeError = remolderDecodeDataResult.error();
                if (remolderDecodeError.isPresent()) {
                    String message = ((DataResult.PartialResult)remolderDecodeError.get()).message();
                    return DataResult.error(() -> message);
                }
                return DataResult.success((Object)Pair.of((Object)new RemolderEntry(pathSelector, (Set)((Pair)packsDecodeDataResult.result().get()).getFirst(), (MoldingTypes.MoldingType)((Pair)moldingDecodeDataResult.result().get()).getFirst(), (Remolder)((Pair)remolderDecodeDataResult.result().get()).getFirst()), (Object)prefix));
            });
        }

        public <T> DataResult<T> encode(RemolderEntry remolderEntry, DynamicOps<T> dynamicOps, T prefix) {
            return ConditionedResourceSelector.CODEC.encode((Object)remolderEntry.pathSelector(), dynamicOps, prefix).flatMap(newPrefix -> this.packsCodec.encode(remolderEntry.packs(), dynamicOps, newPrefix).flatMap(newerPrefix -> this.moldingCodec.encode(remolderEntry.molding(), dynamicOps, newerPrefix).flatMap(newestPrefix -> this.remolderCodec.encode((Object)remolderEntry.remolder(), dynamicOps, newestPrefix))));
        }
    };
}

