/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.teamabnormals.blueprint.common.remolder.Remold;
import com.teamabnormals.blueprint.common.remolder.RemolderTypes;
import com.teamabnormals.blueprint.common.remolder.SequenceRemolder;
import java.util.List;
import java.util.function.Function;

public interface Remolder {
    public static final Codec<Remolder> VERBOSE_CODEC = RemolderTypes.REGISTRY.dispatchStable(Remolder::codec, Function.identity());
    public static final Codec<Remolder> CODEC = new Codec<Remolder>(){
        private final Codec<Remolder> sequenceCodec = this.listOf().xmap(SequenceRemolder::new, remolder -> {
            List<Remolder> list;
            if (remolder instanceof SequenceRemolder) {
                SequenceRemolder sequenceRemolder = (SequenceRemolder)remolder;
                list = sequenceRemolder.remolders();
            } else {
                list = List.of(remolder);
            }
            return list;
        });

        public <T> DataResult<Pair<Remolder, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getMapValues(input).result().isPresent() ? VERBOSE_CODEC.decode(ops, input) : this.sequenceCodec.decode(ops, input);
        }

        public <T> DataResult<T> encode(Remolder input, DynamicOps<T> ops, T prefix) {
            return input instanceof SequenceRemolder ? this.sequenceCodec.encode((Object)input, ops, prefix) : VERBOSE_CODEC.encode((Object)input, ops, prefix);
        }
    };

    public Remold remold() throws Exception;

    public Codec<? extends Remolder> codec();
}

