/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render.modifiers;

import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;
import io.github.mortuusars.exposure.util.HUSLColorConverter;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;

public class AgedHSLUVPixelModifier
implements IPixelModifier {
    public final int tintColor;
    public final double[] tintColorHsluv;
    public final float tintOpacity;
    public final int blackPoint;
    public final int whitePoint;

    public AgedHSLUVPixelModifier(int tintColor, float tintOpacity, int blackPoint, int whitePoint) {
        this.tintColor = tintColor;
        String hexStr = StringUtils.leftPad((String)Integer.toHexString(tintColor & 0xFFFFFF), (int)6, (String)"0");
        this.tintColorHsluv = HUSLColorConverter.hexToHsluv("#" + hexStr);
        this.tintOpacity = tintOpacity;
        this.blackPoint = blackPoint & 0xFF;
        this.whitePoint = whitePoint & 0xFF;
    }

    @Override
    public String getIdSuffix() {
        return "_sepia";
    }

    @Override
    public int modifyPixel(int ABGR) {
        int alpha = FastColor.ABGR32.m_266503_((int)ABGR);
        int blue = FastColor.ABGR32.m_266247_((int)ABGR);
        int green = FastColor.ABGR32.m_266446_((int)ABGR);
        int red = FastColor.ABGR32.m_266313_((int)ABGR);
        blue = (int)Mth.m_184637_((float)blue, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        green = (int)Mth.m_184637_((float)green, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        red = (int)Mth.m_184637_((float)red, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        double[] hsluv = HUSLColorConverter.rgbToHsluv(new double[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f});
        hsluv[0] = this.tintColorHsluv[0];
        hsluv[1] = this.tintColorHsluv[1];
        double[] rgb = HUSLColorConverter.hsluvToRgb(hsluv);
        int newBlue = Mth.m_14045_((int)((int)Mth.m_14139_((double)this.tintOpacity, (double)blue, (double)(rgb[2] * 255.0))), (int)0, (int)255);
        int newGreen = Mth.m_14045_((int)((int)Mth.m_14139_((double)this.tintOpacity, (double)green, (double)(rgb[1] * 255.0))), (int)0, (int)255);
        int newRed = Mth.m_14045_((int)((int)Mth.m_14139_((double)this.tintOpacity, (double)red, (double)(rgb[0] * 255.0))), (int)0, (int)255);
        return FastColor.ABGR32.m_266248_((int)alpha, (int)newBlue, (int)newGreen, (int)newRed);
    }

    public String toString() {
        return "AgedHSLUVPixelModifier{tintColor=#" + Integer.toHexString(this.tintColor) + ", tintOpacity=" + this.tintOpacity + ", blackPoint=" + this.blackPoint + ", whitePoint=" + this.whitePoint + "}";
    }
}

