/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture;

import io.github.mortuusars.exposure.camera.capture.Capture;
import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.annotations.Nullable;

public class CaptureManager {
    private static final Queue<Capture> captureQueue = new LinkedList<Capture>();
    @Nullable
    private static Capture currentCapture;

    public static void enqueue(Capture capture) {
        captureQueue.add(capture);
    }

    public static void onRenderTickEnd() {
        if (currentCapture == null) {
            currentCapture = captureQueue.poll();
            if (currentCapture != null) {
                currentCapture.initialize();
            } else {
                return;
            }
        }
        if (currentCapture.isDone()) {
            currentCapture = null;
        } else {
            currentCapture.tick();
        }
    }
}

