/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.registry;

import com.berksire.furniture.block.entity.CabinetBlockEntity;
import com.berksire.furniture.block.entity.ChimneyBlockEntity;
import com.berksire.furniture.block.entity.ClockBlockEntity;
import com.berksire.furniture.block.entity.CofferBlockEntity;
import com.berksire.furniture.block.entity.DisplayBlockEntity;
import com.berksire.furniture.block.entity.DresserBlockEntity;
import com.berksire.furniture.block.entity.FishTankBlockEntity;
import com.berksire.furniture.block.entity.GramophoneBlockEntity;
import com.berksire.furniture.block.entity.GrandfatherClockBlockEntity;
import com.berksire.furniture.client.entity.CanvasEntity;
import com.berksire.furniture.client.entity.ChairEntity;
import com.berksire.furniture.client.entity.FakeFishTankEntity;
import com.berksire.furniture.client.entity.PellsEntity;
import com.berksire.furniture.registry.ObjectRegistry;
import com.berksire.furniture.util.FurnitureIdentifier;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public final class EntityTypeRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"furniture", (ResourceKey)Registries.f_256939_);
    private static final Registrar<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"furniture", (ResourceKey)Registries.f_256922_).getRegistrar();
    public static final RegistrySupplier<BlockEntityType<GrandfatherClockBlockEntity>> GRANDFATHER_CLOCK_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("grandfather_clock", () -> BlockEntityType.Builder.m_155273_(GrandfatherClockBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("oak").get(), (Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("birch").get(), (Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("acacia").get(), (Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("cherry").get(), (Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("dark_oak").get(), (Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("jungle").get(), (Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("mangrove").get(), (Block)ObjectRegistry.GRANDFATHER_CLOCKS.get("spruce").get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<ClockBlockEntity>> CLOCK_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("clock", () -> BlockEntityType.Builder.m_155273_(ClockBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CLOCKS.get("oak").get(), (Block)ObjectRegistry.CLOCKS.get("birch").get(), (Block)ObjectRegistry.CLOCKS.get("acacia").get(), (Block)ObjectRegistry.CLOCKS.get("cherry").get(), (Block)ObjectRegistry.CLOCKS.get("dark_oak").get(), (Block)ObjectRegistry.CLOCKS.get("jungle").get(), (Block)ObjectRegistry.CLOCKS.get("mangrove").get(), (Block)ObjectRegistry.CLOCKS.get("spruce").get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CofferBlockEntity>> COFFER_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("coffer", () -> BlockEntityType.Builder.m_155273_(CofferBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COFFER.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cabinet", () -> BlockEntityType.Builder.m_155273_(CabinetBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CABINETS.get("oak").get(), (Block)ObjectRegistry.CABINETS.get("birch").get(), (Block)ObjectRegistry.CABINETS.get("acacia").get(), (Block)ObjectRegistry.CABINETS.get("cherry").get(), (Block)ObjectRegistry.CABINETS.get("dark_oak").get(), (Block)ObjectRegistry.CABINETS.get("jungle").get(), (Block)ObjectRegistry.CABINETS.get("mangrove").get(), (Block)ObjectRegistry.CABINETS.get("spruce").get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<FishTankBlockEntity>> FISH_TANK_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("fish_tank", () -> BlockEntityType.Builder.m_155273_(FishTankBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COPPER_FISH_TANK.get(), (Block)ObjectRegistry.IRON_FISH_TANK.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<GramophoneBlockEntity>> GRAMOPHONE_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("gramophone", () -> BlockEntityType.Builder.m_155273_(GramophoneBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.GRAMOPHONE.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<ChimneyBlockEntity>> CHIMNEY_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("chimney", () -> BlockEntityType.Builder.m_155273_(ChimneyBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COPPER_CHIMNEY.get(), (Block)ObjectRegistry.STONE_BRICKS_CHIMNEY.get(), (Block)ObjectRegistry.BRICK_CHIMNEY.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<DresserBlockEntity>> DRESSER_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("dresser", () -> BlockEntityType.Builder.m_155273_(DresserBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.DRESSER.get("oak").get(), (Block)ObjectRegistry.DRESSER.get("birch").get(), (Block)ObjectRegistry.DRESSER.get("acacia").get(), (Block)ObjectRegistry.DRESSER.get("cherry").get(), (Block)ObjectRegistry.DRESSER.get("dark_oak").get(), (Block)ObjectRegistry.DRESSER.get("jungle").get(), (Block)ObjectRegistry.DRESSER.get("mangrove").get(), (Block)ObjectRegistry.DRESSER.get("spruce").get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<DisplayBlockEntity>> DISPLAY_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("display", () -> BlockEntityType.Builder.m_155273_(DisplayBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.DISPLAY.get()}).m_58966_(null));
    public static final RegistrySupplier<EntityType<ChairEntity>> CHAIR = EntityTypeRegistry.registerEntity("chair", () -> EntityType.Builder.m_20704_(ChairEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.001f, 0.001f).m_20712_(new FurnitureIdentifier("chair").toString()));
    public static final RegistrySupplier<EntityType<CanvasEntity>> CANVAS = EntityTypeRegistry.registerEntity("canvas", () -> EntityType.Builder.m_20704_(CanvasEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 2.0f).m_20712_(new FurnitureIdentifier("canvas").toString()));
    public static final RegistrySupplier<EntityType<FakeFishTankEntity>> FAKE_FISH_TANK = EntityTypeRegistry.registerEntity("fake_fish_tank", () -> EntityType.Builder.m_20704_(FakeFishTankEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(1000).m_20712_(new FurnitureIdentifier("fake_fish_tank").toString()));
    public static final RegistrySupplier<EntityType<PellsEntity>> PELLS = EntityTypeRegistry.registerEntity("pells", () -> EntityType.Builder.m_20704_(PellsEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 2.0f).m_20712_(new FurnitureIdentifier("pells").toString()));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register((ResourceLocation)new FurnitureIdentifier(path), type);
    }

    private static <T extends EntityType<?>> RegistrySupplier<T> registerEntity(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(path, type);
    }

    public static void registerAttributes() {
        EntityAttributeRegistry.register(PELLS, PellsEntity::createMobAttributes);
    }

    static {
        ENTITY_TYPES.register();
        EntityTypeRegistry.registerAttributes();
    }
}

