/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.block.ClockBlock;
import com.berksire.furniture.block.entity.ClockBlockEntity;
import com.berksire.furniture.client.model.ClockModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class ClockRenderer
implements BlockEntityRenderer<ClockBlockEntity> {
    private static final Map<ClockBlock.WoodType, ResourceLocation> TEXTURES = new EnumMap<ClockBlock.WoodType, ResourceLocation>(ClockBlock.WoodType.class);
    private final ClockModel<Entity> model;

    public ClockRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.m_173582_(ClockModel.LAYER_LOCATION);
        this.model = new ClockModel(root);
    }

    public void render(ClockBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        long gameTime = Objects.requireNonNull(blockEntity.m_58904_()).m_46468_() % 24000L;
        int hours = (int)((gameTime / 1000L + 6L) % 24L);
        int minutes = (int)(gameTime % 1000L * 60L / 1000L);
        this.model.minutes.f_104205_ = (float)((double)minutes * Math.PI / 30.0);
        this.model.hours.f_104205_ = (float)((double)hours * Math.PI / 6.0);
        BlockState blockstate = blockEntity.m_58900_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(180.0)));
        Direction direction = (Direction)blockstate.m_61143_((Property)BlockStateProperties.f_61374_);
        float rotation = direction.m_122424_().m_122435_();
        poseStack.m_252781_(new Quaternionf().rotateYXZ((float)Math.toRadians(rotation), 0.0f, 0.0f));
        ClockBlock block = (ClockBlock)blockEntity.m_58900_().m_60734_();
        ClockBlock.WoodType woodType = block.getWoodType();
        ResourceLocation texture = TEXTURES.get((Object)woodType);
        this.renderModel(poseStack, bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)texture)), combinedLight, combinedOverlay);
        poseStack.m_85849_();
    }

    private void renderModel(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay) {
        this.model.m_7695_(poseStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    static {
        TEXTURES.put(ClockBlock.WoodType.OAK, new ResourceLocation("furniture", "textures/entity/oak_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.SPRUCE, new ResourceLocation("furniture", "textures/entity/spruce_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.BIRCH, new ResourceLocation("furniture", "textures/entity/birch_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.JUNGLE, new ResourceLocation("furniture", "textures/entity/jungle_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.ACACIA, new ResourceLocation("furniture", "textures/entity/acacia_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.DARK_OAK, new ResourceLocation("furniture", "textures/entity/dark_oak_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.MANGROVE, new ResourceLocation("furniture", "textures/entity/mangrove_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.CHERRY, new ResourceLocation("furniture", "textures/entity/cherry_clock.png"));
    }
}

