/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LampBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<FurnitureUtil.VerticalConnectingType> TYPE = FurnitureUtil.VerticalConnectingType.VERTICAL_CONNECTING_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    private static final Map<FurnitureUtil.VerticalConnectingType, Supplier<VoxelShape>> SHAPES_SUPPLIERS = new HashMap<FurnitureUtil.VerticalConnectingType, Supplier<VoxelShape>>();
    private static final Map<FurnitureUtil.VerticalConnectingType, VoxelShape> SHAPES = new HashMap<FurnitureUtil.VerticalConnectingType, VoxelShape>();
    private final DyeColor color;

    public LampBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE, (Comparable)((Object)FurnitureUtil.VerticalConnectingType.NONE))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public DyeColor getColor() {
        return this.color;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, WATERLOGGED, LIT});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos clickedPos = context.m_8083_();
        Level world = context.m_43725_();
        BlockPos belowPos = clickedPos.m_7495_();
        BlockPos abovePos = clickedPos.m_7494_();
        BlockState belowState = world.m_8055_(belowPos);
        BlockState aboveState = world.m_8055_(abovePos);
        BlockState blockState = this.m_49966_();
        blockState = (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(aboveState, belowState)));
        blockState = (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(clickedPos).m_76152_() == Fluids.f_76193_));
        return blockState;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.f_46443_) {
            return;
        }
        FurnitureUtil.VerticalConnectingType type = this.getType(world.m_8055_(pos.m_7494_()), world.m_8055_(pos.m_7495_()));
        if (state.m_61143_(TYPE) != type) {
            world.m_7731_(pos, (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type)), 3);
        }
    }

    public FurnitureUtil.VerticalConnectingType getType(BlockState above, BlockState below) {
        boolean shapeAboveSame = above.m_60734_() instanceof LampBlock;
        boolean shapeBelowSame = below.m_60734_() instanceof LampBlock;
        if (shapeAboveSame && shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.MIDDLE;
        }
        if (shapeAboveSame) {
            return FurnitureUtil.VerticalConnectingType.BOTTOM;
        }
        if (shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.TOP;
        }
        return FurnitureUtil.VerticalConnectingType.NONE;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_(TYPE));
    }

    private static VoxelShape makeTopShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.5, (double)0.125, (double)0.875, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeBottomShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.75, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeSingleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.375, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.375, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.5, (double)0.125, (double)0.875, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeMiddleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6144_() && (state.m_61143_(TYPE) == FurnitureUtil.VerticalConnectingType.NONE || state.m_61143_(TYPE) == FurnitureUtil.VerticalConnectingType.TOP)) {
            boolean lit = (Boolean)state.m_61143_((Property)LIT) == false;
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit)), 3);
            world.m_5594_(null, pos, SoundEvents.f_12637_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    static {
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.NONE, LampBlock::makeSingleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.MIDDLE, LampBlock::makeMiddleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.TOP, LampBlock::makeTopShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.BOTTOM, LampBlock::makeBottomShape);
        for (Map.Entry<FurnitureUtil.VerticalConnectingType, Supplier<VoxelShape>> entry : SHAPES_SUPPLIERS.entrySet()) {
            SHAPES.put(entry.getKey(), entry.getValue().get());
        }
    }
}

