/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.block;

import com.berksire.furniture.block.LineConnectingBlock;
import com.berksire.furniture.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BenchBlock
extends LineConnectingBlock {
    public static final Map<Direction, VoxelShape> SHAPE;
    public static final Map<Direction, VoxelShape> MIDDLE_SHAPE;
    public static final Map<Direction, VoxelShape> LEFT_SHAPE;
    public static final Map<Direction, VoxelShape> RIGHT_SHAPE;
    public static final Map<Direction, VoxelShape> NONE_REST_SHAPE;
    public static final Map<Direction, VoxelShape> LEFT_REST_SHAPE;
    public static final Map<Direction, VoxelShape> RIGHT_REST_SHAPE;
    public static final BooleanProperty REST;
    private static final Supplier<VoxelShape> noneShapeSupplier;
    private static final Supplier<VoxelShape> noneRestShapeSupplier;
    private static final Supplier<VoxelShape> middleShapeSupplier;
    private static final Supplier<VoxelShape> leftShapeSupplier;
    private static final Supplier<VoxelShape> leftRestShapeSupplier;
    private static final Supplier<VoxelShape> rightShapeSupplier;
    private static final Supplier<VoxelShape> rightRestShapeSupplier;

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean rest = (Boolean)state.m_61143_((Property)REST);
        return (switch ((FurnitureUtil.LineConnectingType)((Object)state.m_61143_((Property)TYPE))) {
            case FurnitureUtil.LineConnectingType.MIDDLE -> MIDDLE_SHAPE;
            case FurnitureUtil.LineConnectingType.LEFT -> rest ? LEFT_REST_SHAPE : LEFT_SHAPE;
            case FurnitureUtil.LineConnectingType.RIGHT -> rest ? RIGHT_REST_SHAPE : RIGHT_SHAPE;
            default -> rest ? NONE_REST_SHAPE : SHAPE;
        }).get(state.m_61143_((Property)FACING));
    }

    public BenchBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)REST, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{REST, FACING, TYPE});
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6144_()) {
            return this.toggleRest(state, world, pos);
        }
        return FurnitureUtil.onUse(world, player, hand, hit, -0.1);
    }

    @NotNull
    public InteractionResult toggleRest(BlockState state, Level world, BlockPos pos) {
        boolean newRestState = (Boolean)state.m_61143_((Property)REST) == false;
        this.updateConnectedBlocks(state, world, pos, newRestState);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    @Override
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        FurnitureUtil.LineConnectingType type = this.getType(state, world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122427_())), world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122428_())));
        if (state.m_61143_((Property)TYPE) != type) {
            state = (BlockState)state.m_61124_((Property)TYPE, (Comparable)((Object)type));
            world.m_7731_(pos, state, 3);
        }
    }

    @Override
    public FurnitureUtil.LineConnectingType getType(BlockState state, BlockState clockwise, BlockState counterClockwise) {
        boolean shape_counterClockwise_same;
        boolean shape_clockwise_same = clockwise.m_60734_() == state.m_60734_() && clockwise.m_61143_((Property)FACING) == state.m_61143_((Property)FACING) && clockwise.m_61143_((Property)REST) == state.m_61143_((Property)REST);
        boolean bl = shape_counterClockwise_same = counterClockwise.m_60734_() == state.m_60734_() && counterClockwise.m_61143_((Property)FACING) == state.m_61143_((Property)FACING) && counterClockwise.m_61143_((Property)REST) == state.m_61143_((Property)REST);
        if (shape_clockwise_same && !shape_counterClockwise_same) {
            return FurnitureUtil.LineConnectingType.RIGHT;
        }
        if (!shape_clockwise_same && shape_counterClockwise_same) {
            return FurnitureUtil.LineConnectingType.LEFT;
        }
        if (shape_clockwise_same) {
            return FurnitureUtil.LineConnectingType.MIDDLE;
        }
        return FurnitureUtil.LineConnectingType.NONE;
    }

    private void updateConnectedBlocks(BlockState state, Level world, BlockPos pos, boolean newRestState) {
        Direction[] directions;
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)REST, (Comparable)Boolean.valueOf(newRestState)), 3);
        for (Direction direction : directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos neighborPos = pos.m_121945_(direction);
            while (world.m_8055_(neighborPos).m_60734_() instanceof BenchBlock) {
                world.m_7731_(neighborPos, (BlockState)world.m_8055_(neighborPos).m_61124_((Property)REST, (Comparable)Boolean.valueOf(newRestState)), 3);
                neighborPos = neighborPos.m_121945_(direction);
            }
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        FurnitureUtil.onStateReplaced(world, pos);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    static {
        REST = BooleanProperty.m_61465_((String)"rest");
        noneShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        noneRestShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.375, (double)0.8125, (double)0.9375, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.375, (double)0.8125, (double)0.1875, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        middleShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.0625, (double)1.0, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        leftShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.25, (double)0.0625, (double)1.0, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        leftRestShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.375, (double)0.8125, (double)0.1875, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.25, (double)0.0625, (double)1.0, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        rightShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        rightRestShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.375, (double)0.8125, (double)0.9375, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, noneShapeSupplier.get()));
            }
        });
        MIDDLE_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, middleShapeSupplier.get()));
            }
        });
        LEFT_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            map.put(Direction.NORTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.NORTH, rightShapeSupplier.get()));
            map.put(Direction.SOUTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.SOUTH, rightShapeSupplier.get()));
            map.put(Direction.EAST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.EAST, rightShapeSupplier.get()));
            map.put(Direction.WEST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.WEST, rightShapeSupplier.get()));
        });
        RIGHT_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            map.put(Direction.NORTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.NORTH, leftShapeSupplier.get()));
            map.put(Direction.SOUTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.SOUTH, leftShapeSupplier.get()));
            map.put(Direction.EAST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.EAST, leftShapeSupplier.get()));
            map.put(Direction.WEST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.WEST, leftShapeSupplier.get()));
        });
        NONE_REST_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, noneRestShapeSupplier.get()));
            }
        });
        LEFT_REST_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            map.put(Direction.NORTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.NORTH, rightRestShapeSupplier.get()));
            map.put(Direction.SOUTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.SOUTH, rightRestShapeSupplier.get()));
            map.put(Direction.EAST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.EAST, rightRestShapeSupplier.get()));
            map.put(Direction.WEST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.WEST, rightRestShapeSupplier.get()));
        });
        RIGHT_REST_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            map.put(Direction.NORTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.NORTH, leftRestShapeSupplier.get()));
            map.put(Direction.SOUTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.SOUTH, leftRestShapeSupplier.get()));
            map.put(Direction.EAST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.EAST, leftRestShapeSupplier.get()));
            map.put(Direction.WEST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.WEST, leftRestShapeSupplier.get()));
        });
    }
}

