/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block.entity.rope;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.block.entity.rope.IRopeEntity;
import net.satisfy.brewery.registry.EntityRegistry;
import net.satisfy.brewery.registry.ObjectRegistry;
import net.satisfy.brewery.util.rope.RopeConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RopeKnotEntity
extends HangingEntity
implements IRopeEntity {
    private static final int MAX_RANGE = 32;
    private static final byte GRACE_PERIOD = 100;
    private final Set<RopeConnection> connections = new HashSet<RopeConnection>();
    private final ObjectList<Tag> incompleteConnections = new ObjectArrayList();
    private int checkTimer = 0;
    private byte graceTicks = (byte)100;

    public RopeKnotEntity(EntityType<? extends RopeKnotEntity> entityType, Level world) {
        super(entityType, world);
    }

    private RopeKnotEntity(Level level, BlockPos blockPos) {
        super((EntityType)EntityRegistry.ROPE_KNOT.get(), level, blockPos);
        this.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public static RopeKnotEntity create(@NotNull Level level, @NotNull BlockPos blockPos) {
        return new RopeKnotEntity(level, blockPos);
    }

    public static boolean canAttachTo(BlockState blockState) {
        return blockState != null && (blockState.m_204336_(BlockTags.f_13039_) || blockState.m_60713_(Blocks.f_50266_));
    }

    public static List<RopeConnection> getHeldRopesInRange(Player player, Vec3 target) {
        AABB searchBox = AABB.m_165882_((Vec3)target, (double)64.0, (double)64.0, (double)64.0);
        List otherKnots = player.m_9236_().m_45976_(RopeKnotEntity.class, searchBox);
        ArrayList<RopeConnection> attachableRopes = new ArrayList<RopeConnection>();
        for (RopeKnotEntity source : otherKnots) {
            for (RopeConnection connection : source.getConnections()) {
                if (connection.to() != player) continue;
                attachableRopes.add(connection);
            }
        }
        return attachableRopes;
    }

    @Nullable
    public static RopeKnotEntity getHopRopeKnotEntity(Level level, BlockPos pos) {
        List results = level.m_45976_(RopeKnotEntity.class, AABB.m_165882_((Vec3)Vec3.m_82528_((Vec3i)pos), (double)2.0, (double)2.0, (double)2.0));
        for (RopeKnotEntity current : results) {
            if (!new BlockPos((Vec3i)current.f_31698_).equals((Object)pos)) continue;
            return current;
        }
        return null;
    }

    public Set<RopeConnection> getConnections() {
        return this.connections;
    }

    public void addConnection(@NotNull RopeConnection connection) {
        if (!connection.from().equals(connection.to())) {
            this.connections.add(connection);
        }
    }

    public boolean sameConnectionExist(@NotNull RopeConnection connection) {
        for (RopeConnection ropeConnection : this.connections) {
            if (!connection.equals(ropeConnection)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand interactionHand) {
        ItemStack handStack = player.m_21120_(interactionHand);
        if (this.m_9236_().m_5776_()) {
            if (handStack.m_150930_((Item)ObjectRegistry.ROPE.get())) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        boolean madeConnection = this.tryAttachHeldRope(player);
        if (madeConnection) {
            this.m_7084_();
            return InteractionResult.CONSUME;
        }
        boolean broke = false;
        for (RopeConnection connection : this.connections) {
            if (connection.to() != player) continue;
            broke = true;
            connection.destroy(true);
        }
        if (broke) {
            return InteractionResult.CONSUME;
        }
        if (handStack.m_150930_((Item)ObjectRegistry.ROPE.get())) {
            this.m_7084_();
            RopeConnection.create(this, (Entity)player);
            if (!player.m_7500_()) {
                handStack.m_41774_(1);
            }
            return InteractionResult.CONSUME;
        }
        if (IRopeEntity.canDestroyWith(handStack)) {
            this.destroyConnections(!player.m_7500_());
            this.graceTicks = 0;
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private boolean tryAttachHeldRope(Player player) {
        boolean hasMadeConnection = false;
        List<RopeConnection> attachableRopes = RopeKnotEntity.getHeldRopesInRange(player, this.m_20182_());
        for (RopeConnection connection : attachableRopes) {
            RopeConnection newConnection;
            if (connection.from() == this || (newConnection = RopeConnection.create(connection.from(), (Entity)this)) == null) continue;
            connection.destroy(false);
            connection.removeSilently = true;
            hasMadeConnection = true;
        }
        return hasMadeConnection;
    }

    public boolean m_7313_(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.m_6469_(this.m_269291_().m_269075_(player), 0.0f);
        } else {
            this.m_5496_(SoundEvents.f_12641_, 0.5f, 1.0f);
        }
        return true;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        InteractionResult result = IRopeEntity.onDamageFrom((Entity)this, damageSource);
        if (result.m_19077_()) {
            this.destroyConnections(result == InteractionResult.SUCCESS);
            return true;
        }
        return false;
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.connections.removeIf(RopeConnection::dead);
            return;
        }
        this.m_146871_();
        boolean anyConverted = this.convertIncompleteConnections();
        this.updateConnections();
        this.removeDeadConnections();
        if (this.graceTicks < 0 || anyConverted && this.incompleteConnections.isEmpty()) {
            this.graceTicks = 0;
        } else if (this.graceTicks > 0) {
            this.graceTicks = (byte)(this.graceTicks - 1);
        }
    }

    private boolean convertIncompleteConnections() {
        if (!this.incompleteConnections.isEmpty()) {
            return this.incompleteConnections.removeIf(this::deserializeChainTag);
        }
        return false;
    }

    private void updateConnections() {
        double squaredMaxRange = 1024.0;
        for (RopeConnection connection : this.connections) {
            if (connection.dead()) continue;
            if (!this.m_6084_()) {
                connection.destroy(true);
                continue;
            }
            if (connection.from() != this || !(connection.getSquaredDistance() > squaredMaxRange)) continue;
            connection.destroy(true);
        }
        if (this.checkTimer++ == 100) {
            this.checkTimer = 0;
            if (!this.m_7088_()) {
                this.destroyConnections(true);
            }
        }
    }

    public boolean m_7088_() {
        BlockState blockState = this.m_9236_().m_8055_(this.m_31748_());
        return RopeKnotEntity.canAttachTo(blockState);
    }

    private void removeDeadConnections() {
        boolean playBreakSound = false;
        for (RopeConnection connection : this.connections) {
            if (connection.needsBeDestroyed()) {
                connection.destroy(true);
            }
            if (!connection.dead() || connection.removeSilently) continue;
            playBreakSound = true;
        }
        if (playBreakSound) {
            this.m_5553_(null);
        }
        this.connections.removeIf(RopeConnection::dead);
        if (this.connections.isEmpty() && this.incompleteConnections.isEmpty() && this.graceTicks <= 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public void destroyConnections(boolean mayDrop) {
        for (RopeConnection connection : this.connections) {
            connection.destroy(mayDrop);
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag connectionTag = new ListTag();
        for (RopeConnection connection : this.connections) {
            if (connection.dead() || connection.from() != this) continue;
            Entity toEntity = connection.to();
            CompoundTag compoundTag = new CompoundTag();
            if (toEntity instanceof Player) {
                UUID uuid = toEntity.m_20148_();
                compoundTag.m_128362_("UUID", uuid);
            } else if (toEntity instanceof RopeKnotEntity) {
                RopeKnotEntity ropeKnotEntity = (RopeKnotEntity)toEntity;
                BlockPos fromPos = this.m_31748_();
                BlockPos toPos = ropeKnotEntity.m_31748_();
                BlockPos relPos = toPos.m_121996_((Vec3i)fromPos);
                Direction inverseFacing = Direction.m_122364_((double)(Direction.SOUTH.m_122435_() - this.m_146908_()));
                relPos = this.getBlockPosAsFacingRelative(relPos, inverseFacing);
                compoundTag.m_128405_("RelX", relPos.m_123341_());
                compoundTag.m_128405_("RelY", relPos.m_123342_());
                compoundTag.m_128405_("RelZ", relPos.m_123343_());
                compoundTag.m_128405_("Active", connection.activeHangingRopes());
            }
            connectionTag.add((Object)compoundTag);
        }
        connectionTag.addAll(this.incompleteConnections);
        if (!connectionTag.isEmpty()) {
            nbt.m_128365_("ropes", (Tag)connectionTag);
        }
    }

    private BlockPos getBlockPosAsFacingRelative(BlockPos relPos, Direction facing) {
        Rotation rotation = Rotation.values()[facing.m_122416_()];
        return relPos.m_7954_(rotation);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("ropes")) {
            this.incompleteConnections.addAll((Collection)nbt.m_128437_("ropes", 10));
        }
    }

    private boolean deserializeChainTag(Tag element) {
        if (element == null || this.m_9236_().m_5776_()) {
            return true;
        }
        if (element instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)element;
            if (tag.m_128441_("UUID")) {
                UUID uuid = tag.m_128342_("UUID");
                Entity toEntity = ((ServerLevel)this.m_9236_()).m_8791_(uuid);
                if (toEntity != null) {
                    RopeConnection.create(this, toEntity);
                    return true;
                }
            } else if (tag.m_128441_("RelX") || tag.m_128441_("RelY") || tag.m_128441_("RelZ")) {
                BlockPos blockPos = new BlockPos(tag.m_128451_("RelX"), tag.m_128451_("RelY"), tag.m_128451_("RelZ"));
                blockPos = this.getBlockPosAsFacingRelative(blockPos, Direction.m_122364_((double)this.m_146908_()));
                RopeKnotEntity entity = RopeKnotEntity.getHopRopeKnotEntity(this.m_9236_(), blockPos.m_121955_((Vec3i)this.m_31748_()));
                if (entity != null) {
                    int activeRopes = tag.m_128441_("Active") ? tag.m_128451_("Active") : 0;
                    RopeConnection.create(this, (Entity)entity, activeRopes);
                    return true;
                }
            } else {
                Brewery.LOGGER.warn("Chain knot NBT is missing UUID or relative position.");
            }
        }
        if (this.graceTicks <= 0) {
            this.m_19998_((ItemLike)ObjectRegistry.ROPE.get());
            this.m_5553_(null);
            return true;
        }
        return false;
    }

    public boolean shouldRenderKnot() {
        return !this.m_9236_().m_8055_(this.f_31698_).m_60795_();
    }

    private double getYOffset(double x, double y, double z) {
        BlockState blockState = this.m_9236_().m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)z));
        return blockState.m_60713_(Blocks.f_50266_) ? 0.375 : 0.625;
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_((double)Mth.m_14107_((double)x) + 0.5, (double)Mth.m_14107_((double)y) + this.getYOffset(x, y, z), (double)Mth.m_14107_((double)z) + 0.5);
    }

    protected void m_6022_(Direction direction) {
    }

    public int m_7076_() {
        return 9;
    }

    public int m_7068_() {
        return 9;
    }

    public void m_5553_(@Nullable Entity entity) {
        this.m_5496_(SoundEvents.f_12033_, 1.0f, 1.0f);
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12087_, 1.0f, 1.0f);
    }

    protected void m_7087_() {
        int x = this.f_31698_.m_123341_();
        int y = this.f_31698_.m_123342_();
        int z = this.f_31698_.m_123343_();
        this.m_20343_((double)x + 0.5, (double)y + this.getYOffset(x, y, z), (double)z + 0.5);
        double w = (double)this.m_6095_().m_20678_() / 2.0;
        double h = this.m_6095_().m_20679_();
        this.m_20011_(new AABB(this.m_20185_() - w, this.m_20186_(), this.m_20189_() - w, this.m_20185_() + w, this.m_20186_() + h, this.m_20189_() + w));
    }

    public float m_6961_(Mirror mirror) {
        if (mirror != Mirror.NONE) {
            for (Tag element : this.incompleteConnections) {
                CompoundTag tag;
                if (!(element instanceof CompoundTag) || !(tag = (CompoundTag)element).m_128441_("RelX")) continue;
                tag.m_128405_("RelX", -tag.m_128451_("RelX"));
            }
        }
        float yaw = Mth.m_14177_((float)this.m_146908_());
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> 180.0f - yaw;
            case Mirror.FRONT_BACK -> -yaw;
            default -> yaw;
        };
    }

    @NotNull
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(((EntityType)EntityRegistry.ROPE_KNOT.get()).m_20679_() / 2.0f), 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public Vec3 m_7398_(float f) {
        return this.m_20318_(f).m_82549_(this.m_7939_());
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return ((EntityType)EntityRegistry.ROPE_KNOT.get()).m_20679_() / 2.0f;
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.BLOCKS;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

