/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.client;

import com.google.common.collect.ImmutableList;
import net.mehvahdjukaar.snowyspirit.common.entity.GingyEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class GingyModel
extends HumanoidModel<GingyEntity> {
    private final ModelPart bodyEaten;
    private final float scale;

    public GingyModel(ModelPart modelPart, float scale) {
        super(modelPart);
        this.bodyEaten = modelPart.m_171324_("body_eaten");
        this.scale = scale;
    }

    public void prepareMobModel(GingyEntity entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_((LivingEntity)entity, limbSwing, limbSwingAmount, partialTick);
        int b = entity.getBodyIntegrity().ordinal();
        this.f_102812_.f_104207_ = b < 1;
        this.f_102811_.f_104207_ = b < 2;
        this.f_102808_.f_104207_ = b < 3;
        this.f_102810_.f_104207_ = b < 4;
        this.bodyEaten.f_104207_ = !this.f_102810_.f_104207_;
    }

    public void setupAnim(GingyEntity entity, float walkAnimation, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float zRot;
        this.f_102808_.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.f_102808_.f_104203_ = headPitch * ((float)Math.PI / 180);
        boolean flyingTicks = entity.m_21256_() > 4;
        float f = 1.0f;
        if (flyingTicks) {
            f = (float)entity.m_20184_().m_82556_();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        float period = 7.853982f * this.scale;
        float angle = walkAnimation * ((float)Math.PI * 2 / period);
        float armSwingPower = 2.0f;
        float cos = Mth.m_14089_((float)angle);
        float walkCycle = cos * limbSwingAmount;
        float walkCycleClamped = cos * Mth.m_14036_((float)limbSwingAmount, (float)0.0f, (float)0.4f);
        this.f_102808_.f_104205_ = walkCycleClamped * 0.3f;
        this.f_102811_.f_104204_ = walkCycleClamped * armSwingPower / f;
        this.f_102812_.f_104204_ = walkCycleClamped * armSwingPower / f;
        float multiplier = 1.6f * Mth.m_14036_((float)(1.0f - limbSwingAmount * 4.0f), (float)0.0f, (float)1.0f);
        this.f_102811_.f_104205_ = zRot = multiplier * (Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f);
        this.f_102812_.f_104205_ = -zRot;
        this.f_102811_.f_104203_ = 0.005f;
        this.f_102812_.f_104203_ = 0.005f;
        this.f_102813_.f_104203_ = walkCycle * 1.4f / f;
        this.f_102814_.f_104203_ = -walkCycle * 1.4f / f;
        this.f_102813_.f_104204_ = 0.005f;
        this.f_102814_.f_104204_ = -0.005f;
        float legZRot = 0.2f;
        this.f_102813_.f_104205_ = 0.005f + legZRot;
        this.f_102814_.f_104205_ = -(0.005f + legZRot);
        if (this.f_102609_ || entity.isOrderedToSit()) {
            this.f_102813_.f_104203_ = -1.5207964f;
            this.f_102813_.f_104204_ = 0.31415927f;
            this.f_102813_.f_104205_ = 0.07853982f;
            this.f_102814_.f_104203_ = -1.5207964f;
            this.f_102814_.f_104204_ = -0.31415927f;
            this.f_102814_.f_104205_ = -0.07853982f;
        }
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_, (Object)this.bodyEaten);
    }

    public static LayerDefinition createBodyLayer() {
        CubeDeformation cubeDeformation = CubeDeformation.f_171458_;
        float hOffset = 11.0f;
        MeshDefinition meshDefinition = HumanoidModel.m_170681_((CubeDeformation)cubeDeformation, (float)hOffset);
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition head = partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -5.0f, -1.5f, 6.0f, 5.0f, 3.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)(0.0f + hOffset), (float)0.0f));
        head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(11, 10).m_171481_(-4.0f, -4.0f, -2.5f, 8.0f, 0.0f, 5.0f), PartPose.f_171404_);
        PartDefinition body = partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-3.0f, 0.0f, -1.0f, 6.0f, 7.0f, 2.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)(0.0f + hOffset), (float)0.0f));
        body.m_171599_("skirt", CubeListBuilder.m_171558_().m_171514_(12, 28).m_171481_(-4.0f, 7.0f, -2.0f, 8.0f, 0.0f, 4.0f), PartPose.f_171404_);
        partDefinition.m_171599_("body_eaten", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-3.0f, 0.0f, -1.0f, 6.0f, 3.0f, 2.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)(4.0f + hOffset), (float)0.0f));
        partDefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f, 0.0f, -0.001f)), PartPose.m_171419_((float)-1.5f, (float)(7.0f + hOffset), (float)0.0f));
        partDefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(10, 17).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f, 0.0f, -0.001f)), PartPose.m_171419_((float)1.5f, (float)(7.0f + hOffset), (float)0.0f));
        partDefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171488_(-4.0f, -1.5f, -1.0f, 4.0f, 3.0f, 2.0f, cubeDeformation), PartPose.m_171419_((float)-3.0f, (float)(1.5f + hOffset), (float)0.0f));
        partDefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(20, 5).m_171488_(0.0f, -1.5f, -1.0f, 4.0f, 3.0f, 2.0f, cubeDeformation), PartPose.m_171419_((float)3.0f, (float)(1.5f + hOffset), (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)32, (int)32);
    }
}

