/*
 * Decompiled with CFR 0.152.
 */
package trofers.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public abstract class JsonHelper {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String FABRIC = "fabric";
    private static final String FABRIC_LOAD_CONDITIONS = new ResourceLocation("fabric", "load_conditions").toString();
    private static final String FABRIC_ALL_MODS_LOADED = new ResourceLocation("fabric", "all_mods_loaded").toString();
    private static final String FORGE_CONDITIONS = "conditions";
    private static final String FORGE_MOD_LOADED = new ResourceLocation("forge", "mod_loaded").toString();

    public static ItemStack deserializeItem(JsonObject object, String memberName) {
        return JsonHelper.getItemStack(GsonHelper.m_13930_((JsonObject)object, (String)memberName), true);
    }

    public static ItemStack getItemStack(JsonObject json, boolean readNBT) {
        String itemName = GsonHelper.m_13906_((JsonObject)json, (String)"item");
        Item item = JsonHelper.getItem(itemName);
        if (readNBT && json.has("nbt")) {
            CompoundTag nbt = JsonHelper.parseNBT(json.get("nbt"));
            CompoundTag itemTag = new CompoundTag();
            if (nbt.m_128441_("ForgeCaps")) {
                itemTag.m_128365_("ForgeCaps", nbt.m_128423_("ForgeCaps"));
                nbt.m_128473_("ForgeCaps");
            }
            itemTag.m_128365_("tag", (Tag)nbt);
            itemTag.m_128359_("id", itemName);
            itemTag.m_128405_("Count", GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1));
            return ItemStack.m_41712_((CompoundTag)itemTag);
        }
        return new ItemStack((ItemLike)item, GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1));
    }

    public static CompoundTag parseNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return TagParser.m_129359_((String)GSON.toJson(element));
            }
            return TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException exception) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + exception);
        }
    }

    public static Item getItem(String id) {
        ResourceLocation key = new ResourceLocation(id);
        if (!BuiltInRegistries.f_257033_.m_7804_(key)) {
            throw new JsonSyntaxException("Unknown item '" + id + "'");
        }
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(key);
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Invalid item: " + id);
        }
        return item;
    }

    public static JsonObject serializeItem(ItemStack item) {
        JsonObject result = new JsonObject();
        result.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_()).toString());
        if (item.m_41613_() != 1) {
            result.addProperty("count", (Number)item.m_41613_());
        }
        if (item.m_41782_()) {
            result.addProperty("nbt", item.m_41783_().toString());
        }
        return result;
    }

    public static CompoundTag deserializeNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return TagParser.m_129359_((String)GSON.toJson(element));
            }
            return TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException exception) {
            throw new JsonSyntaxException(String.format("Invalid NBT Entry: %s", new Object[]{exception}));
        }
    }

    public static float readOptionalFloat(JsonObject object, String memberName, int defaultValue) {
        if (object.has(memberName)) {
            return GsonHelper.m_13915_((JsonObject)object, (String)memberName);
        }
        return defaultValue;
    }

    private static JsonArray getOrCreateList(JsonObject object, String name) {
        if (object.has(name)) {
            return object.getAsJsonArray(name);
        }
        JsonArray conditions = new JsonArray();
        object.add(name, (JsonElement)conditions);
        return conditions;
    }

    private static JsonObject createCondition(JsonObject object, String conditionsName, String conditionName, String conditionValue) {
        JsonArray conditions = JsonHelper.getOrCreateList(object, conditionsName);
        JsonObject condition = new JsonObject();
        conditions.add((JsonElement)condition);
        condition.addProperty(conditionName, conditionValue);
        return condition;
    }

    private static JsonObject createFabricCondition(JsonObject object, String type) {
        return JsonHelper.createCondition(object, FABRIC_LOAD_CONDITIONS, "condition", type);
    }

    private static JsonObject createForgeCondition(JsonObject object, String type) {
        return JsonHelper.createCondition(object, FORGE_CONDITIONS, "type", type);
    }

    public static void addModLoadedConditions(JsonObject object, String ... modIds) {
        if (modIds.length == 0) {
            return;
        }
        JsonHelper.addFabricModLoadedCondition(object, modIds);
        JsonHelper.addForgeModLoadedCondition(object, modIds);
    }

    private static void addFabricModLoadedCondition(JsonObject object, String ... modIds) {
        JsonObject condition = JsonHelper.createFabricCondition(object, FABRIC_ALL_MODS_LOADED);
        JsonArray mods = JsonHelper.getOrCreateList(condition, "values");
        for (String modId : modIds) {
            mods.add(modId);
        }
    }

    private static void addForgeModLoadedCondition(JsonObject object, String ... modIds) {
        for (String modId : modIds) {
            JsonHelper.createForgeCondition(object, FORGE_MOD_LOADED).addProperty("modid", modId);
        }
    }
}

