/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import trofers.util.JsonHelper;

public class EntityInfo {
    private final EntityType<?> type;
    private final CompoundTag nbt;
    private final boolean isAnimated;
    @Nullable
    private Entity entity;

    public EntityInfo(EntityType<?> type, CompoundTag nbt, boolean isAnimated) {
        this.type = type;
        this.nbt = nbt;
        this.isAnimated = isAnimated;
    }

    @Nullable
    public EntityType<?> getType() {
        return this.type;
    }

    public CompoundTag getTag() {
        return this.nbt;
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    @Nullable
    public Entity getOrCreateEntity(Level level) {
        if (this.entity == null || this.entity.m_9236_() != level) {
            this.createEntity(level);
        }
        return this.entity;
    }

    private void createEntity(Level level) {
        if (this.type == null || !this.type.m_245183_().m_247715_(level.m_246046_())) {
            return;
        }
        CompoundTag entityTag = this.nbt.m_6426_();
        entityTag.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_(this.getType()).toString());
        if (!entityTag.m_128403_("UUID")) {
            entityTag.m_128362_("UUID", new UUID(1L, 1L));
        }
        this.entity = EntityType.m_20645_((CompoundTag)entityTag, (Level)level, Function.identity());
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130085_(BuiltInRegistries.f_256780_.m_7981_(this.getType()));
        buffer.m_130079_(this.nbt);
        buffer.writeBoolean(this.isAnimated);
    }

    public static EntityInfo fromNetwork(FriendlyByteBuf buffer) {
        EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(buffer.m_130281_());
        return new EntityInfo(type, buffer.m_130260_(), buffer.readBoolean());
    }

    public static EntityInfo fromJson(JsonObject object) {
        ResourceLocation typeID = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"type"));
        if (!BuiltInRegistries.f_256780_.m_7804_(typeID)) {
            throw new JsonParseException(String.format("Unknown entity type %s", typeID));
        }
        EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(typeID);
        CompoundTag nbt = new CompoundTag();
        if (object.has("nbt")) {
            JsonElement nbtElement = object.get("nbt");
            nbt = JsonHelper.deserializeNBT(nbtElement);
        }
        boolean isAnimated = false;
        if (object.has("animated")) {
            isAnimated = GsonHelper.m_13912_((JsonObject)object, (String)"animated");
        }
        return new EntityInfo(type, nbt, isAnimated);
    }
}

