/*
 * Decompiled with CFR 0.152.
 */
package trofers.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import trofers.Trofers;
import trofers.loot.AbstractLootModifier;
import trofers.trophy.Trophy;
import trofers.trophy.TrophyManager;

public class AddTrophy
extends AbstractLootModifier {
    public static final Supplier<Codec<AddTrophy>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> AddTrophy.codecStart(instance).and((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("trophyBase").forGetter(m -> m.trophyBase)).and((App)ResourceLocation.f_135803_.fieldOf("trophyId").forGetter(m -> m.trophyId)).apply((Applicative)instance, AddTrophy::new)));
    private final Item trophyBase;
    private final ResourceLocation trophyId;

    public AddTrophy(LootItemCondition[] conditions, Item trophyBase, ResourceLocation trophyId) {
        super(conditions);
        this.trophyBase = trophyBase;
        this.trophyId = trophyId;
    }

    @Override
    public Codec<? extends AbstractLootModifier> codec() {
        return CODEC.get();
    }

    @Override
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Trophy trophy = TrophyManager.get(this.trophyId);
        if (trophy == null) {
            Trofers.LOGGER.error("Failed to find trophy with invalid id '{}'", (Object)this.trophyId);
        } else {
            generatedLoot.add((Object)trophy.createItem((ItemLike)this.trophyBase));
        }
        return generatedLoot;
    }
}

