/*
 * Decompiled with CFR 0.152.
 */
package net.ribs.vintagedelight.screen;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.ribs.vintagedelight.block.ModBlocks;
import net.ribs.vintagedelight.block.entity.FermentingJarBlockEntity;
import net.ribs.vintagedelight.item.ModTags;
import net.ribs.vintagedelight.screen.ModMenuTypes;

public class FermentingJarMenu
extends AbstractContainerMenu {
    public final FermentingJarBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 9;

    public FermentingJarMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(8));
    }

    public FermentingJarMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.FERMENTING_MENU.get(), pContainerId);
        FermentingJarMenu.m_38869_((Container)inv, (int)7);
        this.blockEntity = (FermentingJarBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            int inputBaseX = 26;
            int yOffset = 6;
            int firstRowY = 21 + yOffset;
            int secondRowY = firstRowY + 18;
            int inputSpacing = 18;
            int outputOffsetX = 90;
            int secondaryOutputX = outputOffsetX + inputSpacing;
            for (int i = 0; i < 6; ++i) {
                int row = i / 3;
                int col = i % 3;
                int x = inputBaseX + col * inputSpacing;
                int y = row == 0 ? firstRowY : secondRowY;
                this.m_38897_((Slot)new SlotItemHandler(iItemHandler, i, x, y));
            }
            int containerSlotX = inputBaseX + 3 * inputSpacing + 2;
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 6, containerSlotX, firstRowY){

                public boolean m_5857_(ItemStack stack) {
                    return stack.m_204117_(ModTags.CONTAINER_ITEMS);
                }
            });
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 7, inputBaseX + outputOffsetX, secondRowY));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 8, inputBaseX + secondaryOutputX, secondRowY));
        });
        this.m_38884_(data);
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int arrowWidth = 25;
        return maxProgress > 0 ? progress * arrowWidth / maxProgress : 0;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack originalStack = stack.m_41777_();
        int adjustedContainerSlotIndex = 42;
        if (stack.m_204117_(ModTags.CONTAINER_ITEMS) ? !this.m_38903_(stack, adjustedContainerSlotIndex, adjustedContainerSlotIndex + 1, false) && !this.moveToPlayerInventory(stack, index) : (index < 36 ? !this.m_38903_(stack, 36, 45, false) : !this.m_38903_(stack, 0, 36, false))) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() != originalStack.m_41613_()) {
            slot.m_142406_(playerIn, stack);
        }
        return originalStack;
    }

    private boolean moveToPlayerInventory(ItemStack stack, int index) {
        if (index < 36) {
            return this.m_38903_(stack, 36, 45, false);
        }
        return this.m_38903_(stack, 0, 36, false);
    }

    public boolean m_6875_(Player pPlayer) {
        return FermentingJarMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)ModBlocks.FERMENTING_JAR.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

