/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.theme;

import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.theme.SelectorProperties;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class QuestTheme {
    public static QuestTheme instance;
    public static QuestObjectBase currentObject;
    public final List<SelectorProperties> selectors = new ArrayList<SelectorProperties>();
    private final Map<QuestObjectPropertyKey, Object> cache = new HashMap<QuestObjectPropertyKey, Object>();
    private final Map<String, Object> defaultCache = new HashMap<String, Object>();
    public SelectorProperties defaults;

    public void clearCache() {
        this.cache.clear();
        this.defaultCache.clear();
    }

    public <T> T get(ThemeProperty<T> property) {
        Object cachedValue = this.defaultCache.get(property.getName());
        if (cachedValue != null) {
            return (T)cachedValue;
        }
        String value = this.defaults.properties.get(property.getName());
        if (value != null && (cachedValue = property.parse(this.replaceVariables(value, 0))) != null) {
            this.defaultCache.put(property.getName(), cachedValue);
            return (T)cachedValue;
        }
        return property.getDefaultValue();
    }

    public <T> T get(ThemeProperty<T> property, @Nullable QuestObjectBase object) {
        if (object == null) {
            object = currentObject;
        }
        if (object == null) {
            return this.get(property);
        }
        QuestObjectPropertyKey key = new QuestObjectPropertyKey(property.getName(), object.id);
        Object cachedValue = this.cache.get(key);
        if (cachedValue != null) {
            return (T)cachedValue;
        }
        QuestObjectBase o = object;
        do {
            for (SelectorProperties selectorProperties : this.selectors) {
                String value;
                if (!selectorProperties.selector.matches(o) || (value = selectorProperties.properties.get(property.getName())) == null || (cachedValue = property.parse(this.replaceVariables(value, 0))) == null) continue;
                this.cache.put(key, cachedValue);
                return (T)cachedValue;
            }
        } while ((o = o.getQuestFile().getBase(o.getParentID())) != null);
        return this.get(property);
    }

    public String replaceVariables(String value, int iteration) {
        if (iteration >= 30) {
            return value;
        }
        String original = value;
        for (String k : this.defaults.properties.keySet()) {
            value = value.replace("{{" + k + "}}", this.defaults.properties.get(k));
        }
        return original.equals(value) ? value : this.replaceVariables(value, iteration + 1);
    }

    private static class QuestObjectPropertyKey {
        private final String property;
        private final long object;

        private QuestObjectPropertyKey(String p, long o) {
            this.property = p;
            this.object = o;
        }

        public int hashCode() {
            return Long.hashCode((long)this.property.hashCode() * 31L + this.object);
        }

        public boolean equals(Object o) {
            if (o instanceof QuestObjectPropertyKey) {
                QuestObjectPropertyKey key = (QuestObjectPropertyKey)o;
                return this.object == key.object && this.property.equals(key.property);
            }
            return false;
        }
    }
}

