/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.kiulian.downloader.model.search;

import java.util.ArrayList;
import java.util.List;
import org.watermedia.shaded.fastjson.JSONArray;
import org.watermedia.shaded.fastjson.JSONObject;
import org.watermedia.shaded.kiulian.downloader.model.AbstractListVideoDetails;
import org.watermedia.shaded.kiulian.downloader.model.Utils;
import org.watermedia.shaded.kiulian.downloader.model.search.SearchResultItem;
import org.watermedia.shaded.kiulian.downloader.model.search.SearchResultItemType;

public class SearchResultVideoDetails
extends AbstractListVideoDetails
implements SearchResultItem {
    private final boolean isMovie;
    private String description;
    private String viewCountText;
    private long viewCount;
    private long startTime;
    private List<String> badges;
    private List<String> richThumbnails;

    public SearchResultVideoDetails(JSONObject json, boolean isMovie) {
        super(json);
        int i;
        this.isMovie = isMovie;
        if (json.containsKey("lengthText")) {
            String lengthText = json.getJSONObject("lengthText").getString("simpleText");
            this.lengthSeconds = Utils.parseLengthSeconds(lengthText);
        }
        if (isMovie) {
            this.description = Utils.parseRuns(json.getJSONObject("descriptionSnippet"));
        } else if (json.containsKey("detailedMetadataSnippets")) {
            this.description = Utils.parseRuns(json.getJSONArray("detailedMetadataSnippets").getJSONObject(0).getJSONObject("snippetText"));
        }
        if (json.containsKey("upcomingEventData")) {
            String startTimeText = json.getJSONObject("upcomingEventData").getString("startTime");
            this.startTime = Long.parseLong(startTimeText);
            this.viewCount = -1L;
        } else if (json.containsKey("viewCountText")) {
            JSONObject jsonCount = json.getJSONObject("viewCountText");
            if (jsonCount.containsKey("simpleText")) {
                this.viewCountText = jsonCount.getString("simpleText");
                this.viewCount = Utils.parseViewCount(this.viewCountText);
            } else if (jsonCount.containsKey("runs")) {
                this.viewCountText = Utils.parseRuns(jsonCount);
                this.viewCount = -1L;
            }
        }
        if (json.containsKey("badges")) {
            JSONArray jsonBadges = json.getJSONArray("badges");
            this.badges = new ArrayList<String>(jsonBadges.size());
            for (i = 0; i < jsonBadges.size(); ++i) {
                JSONObject jsonBadge = jsonBadges.getJSONObject(i);
                if (!jsonBadge.containsKey("metadataBadgeRenderer")) continue;
                this.badges.add(jsonBadge.getJSONObject("metadataBadgeRenderer").getString("label"));
            }
        }
        if (json.containsKey("richThumbnail")) {
            try {
                JSONArray jsonThumbs = json.getJSONObject("richThumbnail").getJSONObject("movingThumbnailRenderer").getJSONObject("movingThumbnailDetails").getJSONArray("thumbnails");
                this.richThumbnails = new ArrayList<String>(jsonThumbs.size());
                for (i = 0; i < jsonThumbs.size(); ++i) {
                    this.richThumbnails.add(jsonThumbs.getJSONObject(i).getString("url"));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public SearchResultItemType type() {
        return SearchResultItemType.VIDEO;
    }

    @Override
    public SearchResultVideoDetails asVideo() {
        return this;
    }

    public boolean isMovie() {
        return this.isMovie;
    }

    @Override
    public boolean isLive() {
        return this.viewCount == -1L;
    }

    public String viewCountText() {
        return this.viewCountText;
    }

    public long viewCount() {
        return this.viewCount;
    }

    public long startTime() {
        return this.startTime;
    }

    public List<String> badges() {
        return this.badges;
    }

    public List<String> richThumbnails() {
        return this.richThumbnails;
    }

    public String description() {
        return this.description;
    }
}

