/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.render;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryUtil;
import org.watermedia.api.WaterMediaAPI;
import org.watermedia.loaders.ILoader;
import org.watermedia.videolan4j.VideoLan4J;

public class RenderAPI
extends WaterMediaAPI {
    public static final Marker IT = MarkerManager.getMarker((String)RenderAPI.class.getSimpleName());
    public static final int NONE = 0;
    public static final long NULL = 0L;
    public static final boolean ADVANCED_LWJGL = true;

    public static ByteBuffer createByteBuffer(int size) {
        MemoryUtil.MemoryAllocator allocator = MemoryUtil.getAllocator((boolean)false);
        long address = allocator.malloc((long)size);
        if (address == 0L) {
            throw new OutOfMemoryError("Insufficient memory to allocate " + size + " bytes");
        }
        return MemoryUtil.memByteBuffer((long)address, (int)size);
    }

    public static ByteBuffer resizeByteBuffer(ByteBuffer buffer, int newSize) {
        MemoryUtil.MemoryAllocator allocator = MemoryUtil.getAllocator((boolean)false);
        long address = allocator.realloc(MemoryUtil.memAddress0((Buffer)buffer), (long)newSize);
        if (address == 0L) {
            throw new OutOfMemoryError("Insufficient memory to reallocate " + newSize + " bytes");
        }
        return MemoryUtil.memByteBuffer((long)address, (int)newSize);
    }

    public static void freeByteBuffer(ByteBuffer buffer) {
        MemoryUtil.MemoryAllocator allocator = MemoryUtil.getAllocator((boolean)false);
        if (buffer == null) {
            return;
        }
        allocator.free(MemoryUtil.memAddress0((Buffer)buffer));
    }

    public static BufferedImage formatToArgb(BufferedImage originalImage) {
        if (originalImage.getType() == 2) {
            return originalImage;
        }
        BufferedImage newImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 2);
        Graphics g = newImage.getGraphics();
        g.drawImage(originalImage, 0, 0, null);
        g.dispose();
        return newImage;
    }

    public static ByteBuffer[] getImageBuffer(BufferedImage[] images) {
        ByteBuffer[] buffers = new ByteBuffer[images.length];
        for (int i = 0; i < images.length; ++i) {
            buffers[i] = RenderAPI.getImageBuffer(images[i]);
        }
        return buffers;
    }

    public static ByteBuffer getImageBuffer(BufferedImage image) {
        image = RenderAPI.formatToArgb(image);
        int[] pixels = ((DataBufferInt)RenderAPI.formatToArgb(image).getRaster().getDataBuffer()).getData();
        ByteBuffer buffer = RenderAPI.createByteBuffer(image.getWidth() * image.getHeight() * 4);
        buffer.asIntBuffer().put(pixels);
        ((Buffer)buffer).flip();
        return buffer;
    }

    public static int createTexture() {
        int id = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)id);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glBindTexture((int)3553, (int)0);
        return id;
    }

    public static void uploadBuffer(ByteBuffer buffer, int texture, int format, int width, int height, boolean first) {
        GL11.glBindTexture((int)3553, (int)texture);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        if (first) {
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)format, (int)33639, (ByteBuffer)buffer);
        } else {
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)format, (int)33639, (ByteBuffer)buffer);
        }
    }

    public static ByteBuffer downloadBuffer(int texture, int width, int height) {
        ByteBuffer buffer = RenderAPI.createByteBuffer(width * height * 4);
        GL11.glBindTexture((int)3553, (int)texture);
        GL11.glGetTexImage((int)texture, (int)0, (int)32856, (int)33639, (ByteBuffer)buffer);
        return buffer;
    }

    public static void deleteTexture(int texture) {
        GL11.glDeleteTextures((int)texture);
    }

    public static void deleteTexture(int[] textures) {
        GL11.glDeleteTextures((int[])textures);
    }

    public static void bindTexture(int id) {
        GL11.glBindTexture((int)3553, (int)id);
    }

    public static void bindTexture() {
        GL11.glBindTexture((int)3553, (int)0);
    }

    @Override
    public WaterMediaAPI.Priority priority() {
        return WaterMediaAPI.Priority.HIGH;
    }

    @Override
    public boolean prepare(ILoader bootCore) throws Exception {
        return true;
    }

    @Override
    public void start(ILoader bootCore) throws Exception {
        VideoLan4J.setBufferAllocator(RenderAPI::createByteBuffer);
        VideoLan4J.setBufferDeallocator(RenderAPI::freeByteBuffer);
    }

    @Override
    public void release() {
    }
}

