/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.network.patchs;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URI;
import org.watermedia.WaterMedia;
import org.watermedia.api.network.patchs.AbstractPatch;
import org.watermedia.api.network.patchs.kick.KickChannel;
import org.watermedia.api.network.patchs.kick.KickVideo;
import org.watermedia.core.tools.DataTool;
import org.watermedia.core.tools.NetTool;

public class KickPatch
extends AbstractPatch {
    private static final String API_URL = "https://kick.com/api/v2/";
    private static final Gson GSON = new Gson();

    @Override
    public String platform() {
        return "Kick";
    }

    @Override
    public boolean isValid(URI uri) {
        String host = uri.getHost();
        return host != null && (host.endsWith(".kick.com") || host.equals("kick.com"));
    }

    @Override
    public AbstractPatch.Result patch(URI uri, AbstractPatch.Quality prefQuality) throws AbstractPatch.FixingURLException {
        super.patch(uri, prefQuality);
        try {
            if (uri.getPath().contains("/videos/")) {
                String[] split = uri.getPath().split("/");
                String videoID = split[split.length - 1];
                KickVideo video = this.getVideoInfo(videoID);
                return new AbstractPatch.Result(new URI(video.url), true, false);
            }
            String streamerName = uri.getPath().replace("/", "");
            KickChannel channel = this.getChannelInfo(streamerName);
            if (channel.livestream == null || !channel.livestream.isStreaming) {
                throw new ConnectException("Streamer is not online");
            }
            return new AbstractPatch.Result(new URI(channel.url), true, true);
        }
        catch (Exception e) {
            throw new AbstractPatch.FixingURLException(uri.toString(), (Throwable)e);
        }
    }

    public KickChannel getChannelInfo(String channel) throws Exception {
        try (InputStreamReader in = new InputStreamReader(this.getInputStream(new URI("https://kick.com/api/v2/channels/" + channel)));){
            KickChannel kickChannel = (KickChannel)GSON.fromJson((Reader)in, KickChannel.class);
            return kickChannel;
        }
    }

    public KickVideo getVideoInfo(String videoId) throws Exception {
        try (InputStreamReader in = new InputStreamReader(this.getInputStream(new URI("https://kick.com/api/v2/video/" + videoId)));){
            KickVideo kickVideo = (KickVideo)GSON.fromJson((Reader)in, KickVideo.class);
            return kickVideo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(URI url) throws IOException {
        HttpURLConnection conn = NetTool.connectToHTTP(url, "GET");
        conn.setRequestProperty("User-Agent", WaterMedia.USER_AGENT);
        conn.setRequestProperty("Accept", "application/json");
        try {
            if (conn.getResponseCode() != 200) {
                throw new ConnectException(String.format("Server url %s response with status code (%s): %s", url, conn.getResponseCode(), conn.getResponseMessage()));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(DataTool.readAllBytes(conn.getInputStream()));
            return byteArrayInputStream;
        }
        finally {
            conn.disconnect();
        }
    }
}

