/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.constant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import software.bernie.geckolib.GeckoLib;
import software.bernie.geckolib.core.object.DataTicket;
import software.bernie.geckolib.model.data.EntityModelData;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.util.GeckoLibUtil;

public final class DataTickets {
    private static final Map<String, SerializableDataTicket<?>> SERIALIZABLE_TICKETS = new ConcurrentHashMap();
    public static final DataTicket<BlockEntity> BLOCK_ENTITY = new DataTicket<BlockEntity>("block_entity", BlockEntity.class);
    public static final DataTicket<ItemStack> ITEMSTACK = new DataTicket<ItemStack>("itemstack", ItemStack.class);
    public static final DataTicket<Entity> ENTITY = new DataTicket<Entity>("entity", Entity.class);
    public static final DataTicket<EquipmentSlot> EQUIPMENT_SLOT = new DataTicket<EquipmentSlot>("equipment_slot", EquipmentSlot.class);
    public static final DataTicket<EntityModelData> ENTITY_MODEL_DATA = new DataTicket<EntityModelData>("entity_model_data", EntityModelData.class);
    public static final DataTicket<Double> TICK = new DataTicket<Double>("tick", Double.class);
    public static final DataTicket<ItemDisplayContext> ITEM_RENDER_PERSPECTIVE = new DataTicket<ItemDisplayContext>("item_render_perspective", ItemDisplayContext.class);
    public static final SerializableDataTicket<Integer> ANIM_STATE = GeckoLibUtil.addDataTicket(SerializableDataTicket.ofInt(ResourceLocation.fromNamespaceAndPath((String)"geckolib", (String)"anim_state")));
    public static final SerializableDataTicket<String> ANIM = GeckoLibUtil.addDataTicket(SerializableDataTicket.ofString(ResourceLocation.fromNamespaceAndPath((String)"geckolib", (String)"anim")));
    public static final SerializableDataTicket<Integer> USE_TICKS = GeckoLibUtil.addDataTicket(SerializableDataTicket.ofInt(ResourceLocation.fromNamespaceAndPath((String)"geckolib", (String)"use_ticks")));
    public static final SerializableDataTicket<Boolean> ACTIVE = GeckoLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(ResourceLocation.fromNamespaceAndPath((String)"geckolib", (String)"active")));
    public static final SerializableDataTicket<Boolean> OPEN = GeckoLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(ResourceLocation.fromNamespaceAndPath((String)"geckolib", (String)"open")));
    public static final SerializableDataTicket<Boolean> CLOSED = GeckoLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(ResourceLocation.fromNamespaceAndPath((String)"geckolib", (String)"closed")));
    public static final SerializableDataTicket<Direction> DIRECTION = GeckoLibUtil.addDataTicket(SerializableDataTicket.ofEnum(ResourceLocation.fromNamespaceAndPath((String)"geckolib", (String)"direction"), Direction.class));

    @Nullable
    public static SerializableDataTicket<?> byName(String id) {
        return SERIALIZABLE_TICKETS.getOrDefault(id, null);
    }

    public static <D> SerializableDataTicket<D> registerSerializable(SerializableDataTicket<D> ticket) {
        SerializableDataTicket<D> existingTicket = SERIALIZABLE_TICKETS.putIfAbsent(ticket.id(), ticket);
        if (existingTicket != null) {
            GeckoLib.LOGGER.error("Duplicate SerializableDataTicket registered! This will cause issues. Existing: " + existingTicket.id() + ", New: " + ticket.id());
        }
        return ticket;
    }
}

