/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.skillsexpnotifier.client;

import com.github.spacemex.skillsexpnotifier.Config;
import com.github.spacemex.skillsexpnotifier.client.EntryRegistry;
import com.github.spacemex.skillsexpnotifier.client.ToastConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class XpToast
implements Toast {
    private static final ResourceLocation BG = Toast.f_94893_;
    private final ResourceLocation categoryId;
    private int gained;
    private long lastUpdateTime;

    public int getGained() {
        return this.gained;
    }

    public XpToast(ResourceLocation categoryID, int gained) {
        this.categoryId = categoryID;
        this.gained = gained;
        this.lastUpdateTime = Util.m_137550_();
    }

    public void addGained(int delta) {
        this.gained += delta;
        this.lastUpdateTime = Util.m_137550_();
    }

    private boolean useToastControl() {
        return (Boolean)Config.TOAST_CONTROL.get() != false && ToastConfig.isToastControlInstalled();
    }

    @NotNull
    public Toast.Visibility m_7172_(@NotNull GuiGraphics graphics, @NotNull ToastComponent toastGui, long startTime) {
        Minecraft mc = Minecraft.m_91087_();
        long now = Util.m_137550_();
        int bgH = (Integer)Config.BACKGROUD_SIZE_H.get();
        int bgW = (Integer)Config.BACKGROUD_SIZE_W.get();
        if (!((Boolean)Config.DISABLE_BACKGROUND.get()).booleanValue()) {
            if (((Boolean)Config.BACKGROUND_TRANSLUCENT.get()).booleanValue()) {
                float a = (float)((Integer)Config.TITLE_ALPHA.get()).intValue() / 255.0f;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
            }
            graphics.m_280218_(BG, 0, 0, 0, 0, bgW, bgH);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        String path = this.categoryId.m_135815_();
        String title = XpToast.formatCategoryName(path);
        ItemStack iconStack = EntryRegistry.getIconFor(path);
        if (!iconStack.m_41619_()) {
            float iconScale = (float)((Integer)Config.ICON_SIZE.get()).intValue() / 16.0f;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(iconScale, iconScale, 1.0f);
            int x0 = (int)((float)((Integer)Config.ICON_X.get()).intValue() / iconScale);
            int y0 = (int)((float)((Integer)Config.ICON_Y.get()).intValue() / iconScale);
            graphics.m_280480_(iconStack, x0, y0);
            graphics.m_280168_().m_85849_();
        }
        BiConsumer<String, Integer> drawTitle = (text, y) -> {
            graphics.m_280168_().m_85836_();
            float scale = (float)((Integer)Config.TITLE_SIZE.get()).intValue() / 9.0f;
            graphics.m_280168_().m_85841_(scale, scale, 1.0f);
            int x = (int)(30.0f / scale);
            int yy = (int)((float)y.intValue() / scale);
            if (((Boolean)Config.TITLE_DROPSHADOW.get()).booleanValue()) {
                int sdRgb = (Integer)Config.TITLE_DROPSHADOW_COLOR.get() & 0xFFFFFF;
                int sdAlpha = (Boolean)Config.TITLE_TRANSLUCENT.get() != false ? (Integer)Config.TITLE_ALPHA.get() : 255;
                int sdArgb = sdAlpha << 24 | sdRgb;
                graphics.m_280056_(mc.f_91062_, text, x + 1, yy + 1, sdArgb, false);
            }
            int rgb = (Integer)Config.TITLE_COLOR.get() & 0xFFFFFF;
            int alpha = (Boolean)Config.TITLE_TRANSLUCENT.get() != false ? (Integer)Config.TITLE_ALPHA.get() : 255;
            int argb = alpha << 24 | rgb;
            graphics.m_280056_(mc.f_91062_, text, x, yy, argb, false);
            graphics.m_280168_().m_85849_();
        };
        BiConsumer<String, Integer> drawExp = (text, y) -> {
            graphics.m_280168_().m_85836_();
            float scale = (float)((Integer)Config.EXP_SIZE.get()).intValue() / 9.0f;
            graphics.m_280168_().m_85841_(scale, scale, 1.0f);
            int x = (int)(30.0f / scale);
            int yy = (int)((float)y.intValue() / scale);
            if (((Boolean)Config.EXP_DROPSHADOW.get()).booleanValue()) {
                int sdRgb = (Integer)Config.EXP_DROPSHADOW_COLOR.get() & 0xFFFFFF;
                int sdAlpha = (Boolean)Config.EXP_TRANSLUCENT.get() != false ? (Integer)Config.EXP_ALPHA.get() : 255;
                int sdArgb = sdAlpha << 24 | sdRgb;
                graphics.m_280056_(mc.f_91062_, text, x + 1, yy + 1, sdArgb, false);
            }
            int rgb2 = (Integer)Config.EXP_COLOR.get() & 0xFFFFFF;
            int alpha2 = (Boolean)Config.EXP_TRANSLUCENT.get() != false ? (Integer)Config.EXP_ALPHA.get() : 255;
            int argb2 = alpha2 << 24 | rgb2;
            graphics.m_280056_(mc.f_91062_, text, x, yy, argb2, false);
            graphics.m_280168_().m_85849_();
        };
        if (((Boolean)Config.FORCE_INLINE.get()).booleanValue()) {
            String tOv = ((String)Config.TITLE_OVERIDE.get()).replace("%title%", title);
            String xOv = ((String)Config.EXP_OVERIDE.get()).replace("%exp%", String.valueOf(this.gained));
            String combined = tOv + xOv;
            if (((Boolean)Config.BOLD_TITLE.get()).booleanValue() || ((Boolean)Config.BOLD_EXP.get()).booleanValue()) {
                combined = "\u00a7l" + combined;
            }
            int midY = bgH / 2 - (Integer)Config.TITLE_SIZE.get() / 2;
            drawTitle.accept(combined, midY);
        } else {
            String tt = ((Boolean)Config.BOLD_TITLE.get() != false ? "\u00a7l" : "") + title;
            drawTitle.accept(tt, 8);
            String xp = ((Boolean)Config.BOLD_EXP.get() != false ? "\u00a7l" : "") + ((String)Config.EXP_OVERIDE.get()).replace("%exp%", String.valueOf(this.gained));
            drawExp.accept(xp, 18);
        }
        return now - this.lastUpdateTime < (Long)Config.STACK_XP_TIMER.get() ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    @NotNull
    public Object m_7283_() {
        return this.categoryId;
    }

    public static String formatCategoryName(String rawPath) {
        return Arrays.stream(rawPath.split("_")).map(w -> w.isEmpty() ? w : Character.toUpperCase(w.charAt(0)) + w.substring(1)).collect(Collectors.joining(" "));
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }
}

