/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_attributes.compat.irons_spellbooks;

import de.cadentem.additional_attributes.compat.irons_spellbooks.ISAttributes;
import de.cadentem.additional_attributes.config.ServerConfig;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class SpellUtils {
    public static int calculateSpellLevel(@Nullable LivingEntity livingEntity, AbstractSpell spell, int originalLevel) {
        if (livingEntity == null) {
            return originalLevel;
        }
        ResourceLocation spellResource = spell.getSpellResource();
        ResourceLocation schoolResource = spell.getSchoolType().getId();
        Attribute schoolAttribute = schoolResource.m_135827_().equals("irons_spellbooks") ? (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("additional_attributes", "spell_school_" + schoolResource.m_135815_())) : (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("additional_attributes", "school/" + schoolResource.m_135827_() + "/" + schoolResource.m_135815_()));
        Attribute spellAttribute = spellResource.m_135827_().equals("irons_spellbooks") ? (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("additional_attributes", "spell_type_" + spell.getSpellName())) : (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("additional_attributes", "spell/" + spellResource.m_135827_() + "/" + spellResource.m_135815_()));
        ArrayList<AttributeModifier> addition = new ArrayList<AttributeModifier>();
        ArrayList<AttributeModifier> multiplyBase = new ArrayList<AttributeModifier>();
        ArrayList<AttributeModifier> multiplyTotal = new ArrayList<AttributeModifier>();
        SpellUtils.fillModifiers(livingEntity, (Attribute)ISAttributes.SPELL_GENERAL.get(), addition, multiplyBase, multiplyTotal);
        SpellUtils.fillModifiers(livingEntity, schoolAttribute, addition, multiplyBase, multiplyTotal);
        SpellUtils.fillModifiers(livingEntity, spellAttribute, addition, multiplyBase, multiplyTotal);
        double base = originalLevel;
        for (AttributeModifier modifier : addition) {
            base += modifier.m_22218_();
        }
        double result = base;
        for (AttributeModifier modifier : multiplyBase) {
            result += base * modifier.m_22218_();
        }
        for (AttributeModifier modifier : multiplyTotal) {
            result *= 1.0 + modifier.m_22218_();
        }
        if (spell.getMaxLevel() == 1 && result > 1.0 && !((Boolean)ServerConfig.ALLOW_MAX_LEVEL_ONE_INCREASES.get()).booleanValue()) {
            return originalLevel;
        }
        return (int)Mth.m_14008_((double)result, (double)0.0, (double)Math.max(100, originalLevel));
    }

    private static void fillModifiers(LivingEntity livingEntity, Attribute attribute, List<AttributeModifier> addition, List<AttributeModifier> multiplyBase, List<AttributeModifier> multiplyTotal) {
        if (livingEntity == null || attribute == null) {
            return;
        }
        AttributeInstance instance = livingEntity.m_21051_(attribute);
        if (instance == null) {
            return;
        }
        addition.addAll(instance.m_22104_(AttributeModifier.Operation.ADDITION));
        multiplyBase.addAll(instance.m_22104_(AttributeModifier.Operation.MULTIPLY_BASE));
        multiplyTotal.addAll(instance.m_22104_(AttributeModifier.Operation.MULTIPLY_TOTAL));
    }
}

