/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_attributes.compat.apotheosis;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cadentem.additional_attributes.AA;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.AddReloadListenerEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class RarityDefinition
extends SimpleJsonResourceReloadListener {
    private static final Set<Clamp> ENTRIES = new HashSet<Clamp>();
    private final RegistryAccess access;

    public RarityDefinition(RegistryAccess access) {
        super(new Gson(), "additional_attributes/rarity_definitions");
        this.access = access;
    }

    public static Pair<DynamicHolder<LootRarity>, DynamicHolder<LootRarity>> clamp(ItemStack stack, DynamicHolder<LootRarity> min, DynamicHolder<LootRarity> max) {
        for (Clamp clamp : ENTRIES) {
            if (!clamp.items().m_203333_(stack.m_220173_())) continue;
            DynamicHolder clampedMin = clamp.minRarity().orElse(null);
            DynamicHolder clampedMax = clamp.maxRarity().orElse(null);
            if (clampedMax != null && ((LootRarity)clampedMax.get()).ordinal() < ((LootRarity)max.get()).ordinal()) {
                max = clampedMax;
            }
            if (clampedMin != null && ((LootRarity)clampedMin.get()).ordinal() < ((LootRarity)max.get()).ordinal()) {
                min = clampedMin;
            } else if (((LootRarity)min.get()).ordinal() > ((LootRarity)max.get()).ordinal()) {
                min = max;
            }
            return Pair.of((Object)min, (Object)max);
        }
        return Pair.of(min, max);
    }

    public static void register(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new RarityDefinition(event.getRegistryAccess()));
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> data, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        RegistryOps serializer = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.access);
        ENTRIES.clear();
        data.values().forEach(element -> Clamp.CODEC.decode((DynamicOps)serializer, element).resultOrPartial(arg_0 -> ((Logger)AA.LOG).error(arg_0)).ifPresent(result -> {
            Clamp clamp = (Clamp)result.getFirst();
            if (clamp.minRarity().map(minRarity -> clamp.maxRarity().map(maxRarity -> ((LootRarity)minRarity.get()).ordinal() > ((LootRarity)maxRarity.get()).ordinal()).orElse(false)).orElse(false).booleanValue()) {
                AA.LOG.error("Invalid rarity definition for {}: min rarity {} is greater than max rarity {}", new Object[]{clamp.items(), clamp.minRarity().get(), clamp.maxRarity().get()});
            } else {
                ENTRIES.add(clamp);
            }
        }));
    }

    private record Clamp(HolderSet<Item> items, Optional<DynamicHolder<LootRarity>> minRarity, Optional<DynamicHolder<LootRarity>> maxRarity) {
        public static final Codec<Clamp> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256913_).fieldOf("items").forGetter(Clamp::items), (App)RarityRegistry.INSTANCE.holderCodec().optionalFieldOf("min_rarity").forGetter(Clamp::minRarity), (App)RarityRegistry.INSTANCE.holderCodec().optionalFieldOf("max_rarity").forGetter(Clamp::minRarity)).apply((Applicative)instance, Clamp::new));
    }
}

