/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.snowpig;

import com.uraneptus.snowpig.client.entity.render.SnowPigRender;
import com.uraneptus.snowpig.common.capabilities.SPEntityCap;
import com.uraneptus.snowpig.common.entities.SnowPig;
import com.uraneptus.snowpig.core.data.client.SPItemModelProvider;
import com.uraneptus.snowpig.core.data.client.SPLangProvider;
import com.uraneptus.snowpig.core.data.client.SPSoundDefinitionsProvider;
import com.uraneptus.snowpig.core.data.server.SPRecipeProvider;
import com.uraneptus.snowpig.core.data.server.datapack_registries.SPBiomeModifiers;
import com.uraneptus.snowpig.core.data.server.loot.SPLootTableProvider;
import com.uraneptus.snowpig.core.data.server.tags.SPBiomeTagsProvider;
import com.uraneptus.snowpig.core.data.server.tags.SPBlockTagsProvider;
import com.uraneptus.snowpig.core.data.server.tags.SPEntityTagsProvider;
import com.uraneptus.snowpig.core.data.server.tags.SPItemTagsProvider;
import com.uraneptus.snowpig.core.registry.SPEntityTypes;
import com.uraneptus.snowpig.core.registry.SPItems;
import com.uraneptus.snowpig.core.registry.SPLootPoolEntryTypes;
import com.uraneptus.snowpig.core.registry.SPSounds;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="snowpig")
@Mod.EventBusSubscriber(modid="snowpig", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SnowPigMod {
    public static final String MOD_ID = "snowpig";
    private static final RegistrySetBuilder SET_BUILDER = new RegistrySetBuilder().m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, SPBiomeModifiers::create);

    public static ResourceLocation modPrefix(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public SnowPigMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setupClient);
        bus.addListener(this::gatherData);
        SPSounds.SOUNDS.register(bus);
        SPItems.ITEMS.register(bus);
        SPEntityTypes.ENTITY_TYPES.register(bus);
        SPLootPoolEntryTypes.LOOT_ENTRY.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void setupClient(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SPEntityTypes.SNOW_PIG.get(), SnowPigRender::new);
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SPEntityTypes.SNOW_PIG.get(), SnowPig.m_29503_().m_22265_());
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(SPEntityCap.class);
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        boolean includeClient = event.includeClient();
        boolean includeServer = event.includeServer();
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(includeClient, (DataProvider)new SPItemModelProvider(packOutput, fileHelper));
        generator.addProvider(includeClient, (DataProvider)new SPSoundDefinitionsProvider(packOutput, fileHelper));
        generator.addProvider(includeClient, (DataProvider)new SPLangProvider(packOutput));
        SPBlockTagsProvider blockTagProvider = new SPBlockTagsProvider(packOutput, lookupProvider, fileHelper);
        generator.addProvider(includeServer, (DataProvider)blockTagProvider);
        generator.addProvider(includeServer, (DataProvider)new SPItemTagsProvider(packOutput, lookupProvider, blockTagProvider.m_274426_(), fileHelper));
        generator.addProvider(includeServer, (DataProvider)new SPEntityTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(includeServer, (DataProvider)new SPBiomeTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(includeServer, (DataProvider)new SPLootTableProvider(packOutput));
        generator.addProvider(includeServer, (DataProvider)new SPRecipeProvider(packOutput));
        generator.addProvider(includeServer, (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, SET_BUILDER, Set.of(MOD_ID)));
    }
}

