/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.world;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.saveddata.SavedData;

public class GAGPointOfInterestStorage
extends SavedData {
    private static final String FILE_NAME = "gag_poi_info";
    private final Map<BlockPos, Block> pois = new HashMap<BlockPos, Block>();
    private final Level level;

    public GAGPointOfInterestStorage(Level level) {
        this.level = level;
    }

    public static GAGPointOfInterestStorage get(ServerLevel level) {
        return (GAGPointOfInterestStorage)level.m_8895_().m_164861_(tag -> GAGPointOfInterestStorage.load((Level)level, tag), () -> new GAGPointOfInterestStorage((Level)level), FILE_NAME);
    }

    public Block add(BlockPos pos, Block block) {
        this.m_77762_();
        return this.pois.put(pos, block);
    }

    public boolean removeIfPresent(BlockPos pos) {
        this.m_77762_();
        return this.pois.remove(pos) != null;
    }

    public Optional<BlockPos> checkNearbyPOIs(Block block, BlockPos pos, int radius) {
        for (Map.Entry<BlockPos, Block> poi : this.pois.entrySet()) {
            if (poi.getValue() != block || !(poi.getKey().m_123331_((Vec3i)pos) < (double)(radius * radius))) continue;
            return Optional.of(poi.getKey());
        }
        return Optional.empty();
    }

    public static GAGPointOfInterestStorage load(Level level, CompoundTag nbt) {
        GAGPointOfInterestStorage storage = new GAGPointOfInterestStorage(level);
        if (nbt.m_128441_("pois")) {
            ListTag list = nbt.m_128437_("pois", 10);
            for (Tag tag : list) {
                CompoundTag poiTag = (CompoundTag)tag;
                Block block = (Block)storage.blockRegistry().m_7745_(ResourceLocation.m_135820_((String)poiTag.m_128461_("block")));
                BlockPos pos = BlockPos.m_122022_((long)poiTag.m_128454_("pos"));
                storage.pois.put(pos, block);
            }
        }
        return storage;
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag list = new ListTag();
        for (Map.Entry<BlockPos, Block> poi : this.pois.entrySet()) {
            list.add((Object)((Tag)Util.m_137469_((Object)new CompoundTag(), tag -> {
                tag.m_128359_("block", this.blockRegistry().m_7981_((Object)((Block)poi.getValue())).toString());
                tag.m_128356_("pos", ((BlockPos)poi.getKey()).m_121878_());
            })));
        }
        compoundTag.m_128365_("pois", (Tag)list);
        return compoundTag;
    }

    private Registry<Block> blockRegistry() {
        return this.level.m_9598_().m_175515_(Registries.f_256747_);
    }
}

