/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.voidtypes.tank;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import me.duquee.createutilities.blocks.CUTileEntities;
import me.duquee.createutilities.blocks.voidtypes.VoidLinkBehaviour;
import me.duquee.createutilities.blocks.voidtypes.tank.VoidTankTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class VoidTankBlock
extends Block
implements IWrenchable,
IBE<VoidTankTileEntity> {
    public static final BooleanProperty CLOSED = BooleanProperty.m_61465_((String)"closed");

    public VoidTankBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CLOSED});
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (worldIn.m_5776_()) {
            return;
        }
        VoidLinkBehaviour behaviour = (VoidLinkBehaviour)BlockEntityBehaviour.get((BlockGetter)worldIn, (BlockPos)pos, VoidLinkBehaviour.TYPE);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            behaviour.setOwner(player.m_36316_());
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        context.m_43725_().m_46597_(context.m_8083_(), (BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)CLOSED) == false)));
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!player.m_7500_()) {
            return InteractionResult.PASS;
        }
        FluidHelper.FluidExchange exchange = null;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof VoidTankTileEntity)) {
            return InteractionResult.FAIL;
        }
        VoidTankTileEntity te = (VoidTankTileEntity)blockEntity;
        FluidTank fluidTank = te.getFluidStorage();
        if (fluidTank == null) {
            return InteractionResult.PASS;
        }
        if (FluidHelper.tryEmptyItemIntoBE((Level)world, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)te)) {
            exchange = FluidHelper.FluidExchange.ITEM_TO_TANK;
        } else if (FluidHelper.tryFillItemFromBE((Level)world, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)te)) {
            exchange = FluidHelper.FluidExchange.TANK_TO_ITEM;
        }
        if (exchange == null) {
            if (GenericItemEmptying.canItemBeEmptied((Level)world, (ItemStack)heldItem) || GenericItemFilling.canItemBeFilled((Level)world, (ItemStack)heldItem)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public Class<VoidTankTileEntity> getBlockEntityClass() {
        return VoidTankTileEntity.class;
    }

    public BlockEntityType<? extends VoidTankTileEntity> getBlockEntityType() {
        return (BlockEntityType)CUTileEntities.VOID_TANK.get();
    }
}

