/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class CurrantTreeFeature
extends BlueprintTreeFeature {
    public CurrantTreeFeature(Codec<TreeConfiguration> config) {
        super(false, config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context) {
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        int trunkHeight = config.f_68190_.m_226153_(random);
        for (int y = 0; y < trunkHeight; ++y) {
            this.addLog(origin.m_6630_(y));
        }
        int bottomSize = Math.max(5, 3 + random.m_188503_(3) + random.m_188503_(2));
        int topSize = Math.max(3, 2 + random.m_188503_(2) + random.m_188503_(2));
        this.createLeafLayer(origin.m_7494_(), bottomSize, random);
        this.createLeafLayer(origin.m_6630_(trunkHeight), topSize, random);
    }

    public BlockState getSapling() {
        return ((Block)AtmosphericBlocks.CURRANT_SEEDLING.get()).m_49966_();
    }

    private void createLeafLayer(BlockPos pos, int leafSize, RandomSource random) {
        BlockPos offsetPos = pos.m_7918_(-1 - random.m_188503_(leafSize - 2), 0, -1 - random.m_188503_(leafSize - 2));
        for (int i = 0; i < leafSize; ++i) {
            for (int k = 0; k < leafSize; ++k) {
                this.addFoliage(offsetPos.m_7918_(i, 0, k));
            }
        }
    }
}

